/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.PerFileSheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public class PerFileSheetV2d0
extends PerFileSheet {
    static final int NUM_COLS = 17;
    static final int FILE_NAME_COL = 0;
    static final int ID_COL = 1;
    static final int PACKAGE_ID_COL = 2;
    static final int FILE_TYPE_COL = 3;
    static final int CHECKSUMS_COL = 4;
    static final int CONCLUDED_LIC_COL = 5;
    static final int LIC_INFO_IN_FILE_COL = 6;
    static final int LIC_COMMENTS_COL = 7;
    static final int SEEN_COPYRIGHT_COL = 8;
    static final int NOTICE_TEXT_COL = 9;
    static final int ARTIFACT_OF_PROJECT_COL = 10;
    static final int ARTIFACT_OF_HOMEPAGE_COL = 11;
    static final int ARTIFACT_OF_PROJECT_URL_COL = 12;
    static final int CONTRIBUTORS_COL = 13;
    static final int COMMENT_COL = 14;
    static final int FILE_DEPENDENCIES_COL = 15;
    static final int USER_DEFINED_COL = 16;
    static final boolean[] REQUIRED = new boolean[]{true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false};
    static final String[] HEADER_TITLES = new String[]{"File Name", "SPDX Identifier", "Package Identifier", "File Type(s)", "File Checksum(s)", "License Concluded", "License Info in File", "License Comments", "File Copyright Text", "Notice Text", "Artifact of Project", "Artifact of Homepage", "Artifact of URL", "Contributors", "File Comment", "File Dependencies", "User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{60, 25, 25, 30, 85, 50, 50, 60, 70, 70, 35, 60, 60, 60, 60, 60, 60};
    static final boolean[] LEFT_WRAP = new boolean[]{true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    Map<String, SpdxFile> fileCache = new HashMap<String, SpdxFile>();

    PerFileSheetV2d0(Workbook workbook, String sheetName, String version, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, sheetName, version, modelStore, documentUri, copyManager);
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    @Override
    public void add(SpdxFile fileInfo, String pkgId) throws SpreadsheetException {
        Row row = this.addRow();
        if (fileInfo.getId() != null && !fileInfo.getId().isEmpty()) {
            row.createCell(1).setCellValue(fileInfo.getId());
        }
        if (pkgId != null && !pkgId.isEmpty()) {
            row.createCell(2).setCellValue(pkgId);
        }
        try {
            if (fileInfo.getLicenseConcluded() != null) {
                row.createCell(5).setCellValue(fileInfo.getLicenseConcluded().toString());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting concluded license from file ID " + fileInfo.getId(), e);
        }
        try {
            Optional name = fileInfo.getName();
            if (name.isPresent()) {
                row.createCell(0).setCellValue((String)name.get());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting file name from file ID " + fileInfo.getId(), e);
        }
        if (fileInfo.getChecksums().size() > 0) {
            try {
                row.createCell(4).setCellValue(this.checksumsToString(fileInfo.getChecksums()));
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error getting checksums from file ID " + fileInfo.getId(), e);
            }
        }
        try {
            row.createCell(3).setCellValue(PerFileSheetV2d0.fileTypesToString(fileInfo.getFileTypes()));
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting file types from file ID " + fileInfo.getId(), e);
        }
        try {
            Optional licenseComments = fileInfo.getLicenseComments();
            if (licenseComments.isPresent() && !((String)licenseComments.get()).isEmpty()) {
                row.createCell(7).setCellValue((String)licenseComments.get());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting license comment from file ID " + fileInfo.getId(), e);
        }
        try {
            if (fileInfo.getCopyrightText() != null && !fileInfo.getCopyrightText().isEmpty()) {
                row.createCell(8).setCellValue(fileInfo.getCopyrightText());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting copyright text from file ID " + fileInfo.getId(), e);
        }
        try {
            if (fileInfo.getLicenseInfoFromFiles() != null && fileInfo.getLicenseInfoFromFiles().size() > 0) {
                row.createCell(6).setCellValue(PerFileSheetV2d0.licensesToString(fileInfo.getLicenseInfoFromFiles()));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting license info from files from file ID " + fileInfo.getId(), e);
        }
        try {
            Optional comment = fileInfo.getComment();
            if (comment.isPresent() && !((String)comment.get()).isEmpty()) {
                row.createCell(14).setCellValue((String)comment.get());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting comment file ID " + fileInfo.getId(), e);
        }
        if (fileInfo.getFileContributors() != null && fileInfo.getFileContributors().size() > 0) {
            row.createCell(13).setCellValue(PerFileSheetV2d0.stringsToCsv(fileInfo.getFileContributors()));
        }
        try {
            Optional noticeText = fileInfo.getNoticeText();
            if (noticeText.isPresent() && !((String)noticeText.get()).isEmpty()) {
                row.createCell(9).setCellValue((String)noticeText.get());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting file notice text from file ID " + fileInfo.getId(), e);
        }
    }

    @Override
    public SpdxFile getFileInfo(int rowNum) throws SpreadsheetException {
        Cell fileDependencyCells;
        SpdxFile retval;
        Cell commentCell;
        Cell noticeCell;
        Cell contributorCell;
        Cell licCommentCell;
        Cell copyrightCell;
        AnyLicenseInfo concludedLicense;
        String id;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String ver = this.validateRow(row);
        if (ver != null && !ver.isEmpty()) {
            throw new SpreadsheetException(ver);
        }
        String name = row.getCell(0).getStringCellValue();
        if (this.fileCache.containsKey(name)) {
            return this.fileCache.get(name);
        }
        Cell idCell = row.getCell(1);
        if (Objects.nonNull(idCell) && idCell.getStringCellValue() != null && !idCell.getStringCellValue().isEmpty()) {
            id = idCell.getStringCellValue().trim();
        } else {
            try {
                id = this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error getting element ID for file " + name, e);
            }
        }
        Cell checksumsCell = row.getCell(4);
        Collection<Object> checksums = new ArrayList();
        Checksum sha1 = null;
        if (Objects.nonNull(checksumsCell)) {
            try {
                checksums = this.strToChecksums(checksumsCell.getStringCellValue());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error converting file checksums: " + e.getMessage(), e);
            }
        }
        for (Checksum checksum : checksums) {
            try {
                if (!ChecksumAlgorithm.SHA1.equals((Object)checksum.getAlgorithm())) continue;
                if (Objects.isNull(sha1)) {
                    sha1 = checksum;
                    continue;
                }
                throw new SpreadsheetException("Duplicate SHA1 for file " + name);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error getting checksum for file " + name, e);
            }
        }
        if (Objects.isNull(sha1)) {
            throw new SpreadsheetException("Missing SHA1 for file " + name);
        }
        Cell concludedLicenseCell = row.getCell(5);
        if (Objects.nonNull(concludedLicenseCell) && !concludedLicenseCell.getStringCellValue().isEmpty()) {
            try {
                concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)concludedLicenseCell.getStringCellValue(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager);
            }
            catch (InvalidLicenseStringException e) {
                throw new SpreadsheetException("Error getting concluded license for file " + name, e);
            }
        } else {
            throw new SpreadsheetException("Missing concluded license for file " + name);
        }
        ArrayList<AnyLicenseInfo> licenseInfosFromFile = new ArrayList<AnyLicenseInfo>();
        Cell licenseInfoFromFileCell = row.getCell(6);
        if (Objects.nonNull(licenseInfoFromFileCell) && !licenseInfoFromFileCell.getStringCellValue().isEmpty()) {
            String[] licenseStrings = licenseInfoFromFileCell.getStringCellValue().split(",");
            for (int i = 0; i < licenseStrings.length; ++i) {
                try {
                    licenseInfosFromFile.add(LicenseInfoFactory.parseSPDXLicenseString((String)licenseStrings[i].trim(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager));
                    continue;
                }
                catch (InvalidLicenseStringException e) {
                    throw new SpreadsheetException("Error getting license infos from file for file " + name, e);
                }
            }
        }
        String copyrightText = Objects.nonNull(copyrightCell = row.getCell(8)) ? copyrightCell.getStringCellValue() : "";
        SpdxFile.SpdxFileBuilder fileBuilder = new SpdxFile.SpdxFileBuilder(this.modelStore, this.documentUri, id, this.copyManager, name, concludedLicense, licenseInfosFromFile, copyrightText, sha1);
        String typeStr = row.getCell(3).getStringCellValue();
        if (Objects.nonNull(typeStr)) {
            try {
                fileBuilder.setFileTypes(PerFileSheetV2d0.parseFileTypeString(typeStr));
            }
            catch (InvalidSPDXAnalysisException e1) {
                throw new SpreadsheetException("Error converting file types: " + e1.getMessage());
            }
        }
        if (Objects.nonNull(licCommentCell = row.getCell(7))) {
            fileBuilder.setLicenseComments(licCommentCell.getStringCellValue());
        }
        if (Objects.nonNull(contributorCell = row.getCell(13)) && !contributorCell.getStringCellValue().trim().isEmpty()) {
            fileBuilder.setFileContributors(PerFileSheetV2d0.csvToStrings(contributorCell.getStringCellValue().trim()));
        }
        if (Objects.nonNull(noticeCell = row.getCell(9)) && !noticeCell.getStringCellValue().trim().isEmpty()) {
            fileBuilder.setNoticeText(noticeCell.getStringCellValue().trim());
        }
        if (Objects.nonNull(commentCell = row.getCell(14)) && !commentCell.getStringCellValue().trim().isEmpty()) {
            fileBuilder.setComment(commentCell.getStringCellValue().trim());
        }
        try {
            retval = fileBuilder.build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error creating new SPDX file: " + e.getMessage());
        }
        Cell artifactOfNameCell = row.getCell(10);
        if (Objects.nonNull(artifactOfNameCell) && !artifactOfNameCell.getStringCellValue().isEmpty()) {
            SpdxNoAssertionLicense noAssertion;
            List<String> projectNames = PerFileSheetV2d0.csvToStrings(artifactOfNameCell.getStringCellValue());
            Cell artifactOfHomePageCell = row.getCell(11);
            List<Object> projectHomePages = Objects.nonNull(artifactOfHomePageCell) && !artifactOfHomePageCell.getStringCellValue().isEmpty() ? PerFileSheetV2d0.csvToStrings(artifactOfHomePageCell.getStringCellValue()) : new ArrayList();
            try {
                noAssertion = new SpdxNoAssertionLicense();
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error creating no assertion license for DOAP project for file " + name, e);
            }
            for (int i = 0; i < projectNames.size(); ++i) {
                SpdxPackage doapPackage;
                SpdxPackage.SpdxPackageBuilder pkgBuilder = new SpdxPackage.SpdxPackageBuilder(this.modelStore, this.documentUri, SpdxConstants.SPDX_ELEMENT_REF_PRENUM + "FromDoap-" + Integer.toString(i), this.copyManager, projectNames.get(i), (AnyLicenseInfo)noAssertion, SpdxConstants.NOASSERTION_VALUE, (AnyLicenseInfo)noAssertion).setFilesAnalyzed(false);
                if (projectHomePages.size() > i) {
                    pkgBuilder.setHomepage((String)projectHomePages.get(i));
                }
                pkgBuilder.setComment("This package was converted from a DOAP Project by the same name");
                try {
                    doapPackage = pkgBuilder.build();
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpreadsheetException("Error creating package for DOAP project for file " + name, e);
                }
                try {
                    retval.addRelationship(retval.createRelationship((SpdxElement)doapPackage, RelationshipType.GENERATED_FROM, "This relationship replaces an ArtifactOf"));
                    continue;
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpreadsheetException("Error creating relationships for DOAP project for file " + name, e);
                }
            }
        }
        if (Objects.nonNull(fileDependencyCells = row.getCell(15)) && !fileDependencyCells.getStringCellValue().isEmpty()) {
            for (String dependencyName : PerFileSheetV2d0.csvToStrings(fileDependencyCells.getStringCellValue())) {
                SpdxFile dependency = this.findFileByName(dependencyName.trim());
                try {
                    retval.addRelationship(retval.createRelationship((SpdxElement)dependency, RelationshipType.DEPENDS_ON, "This relationship replaced a file dependency property value"));
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpreadsheetException("Error creating relationship for file dependency for file " + name, e);
                }
            }
        }
        this.fileCache.put(name, retval);
        return retval;
    }

    public SpdxFile findFileByName(String fileName) throws SpreadsheetException {
        if (this.fileCache.containsKey(fileName)) {
            return this.fileCache.get(fileName);
        }
        for (int i = this.firstRowNum; i < this.lastRowNum + 1; ++i) {
            Cell fileNameCell = this.sheet.getRow(i).getCell(0);
            if (!fileNameCell.getStringCellValue().trim().equals(fileName)) continue;
            return this.getFileInfo(i);
        }
        throw new SpreadsheetException("Could not find dependant file in the spreadsheet: " + fileName);
    }

    @Override
    public List<String> getPackageIds(int row) {
        ArrayList<String> retval = new ArrayList<String>();
        Cell pkgIdCell = this.sheet.getRow(row).getCell(2);
        if (pkgIdCell == null || pkgIdCell.getStringCellValue() == null || pkgIdCell.getStringCellValue().isEmpty()) {
            return retval;
        }
        for (String pkgId : pkgIdCell.getStringCellValue().split(",")) {
            retval.add(pkgId.trim());
        }
        return retval;
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX File does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 16; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX File worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX File work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 17; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (!REQUIRED[i]) continue;
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
            }
            if (i != 5) continue;
            try {
                LicenseInfoFactory.parseSPDXLicenseString((String)cell.getStringCellValue(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager);
                continue;
            }
            catch (InvalidSPDXAnalysisException ex) {
                return "Invalid asserted license string in row " + String.valueOf(row.getRowNum()) + " details: " + ex.getMessage();
            }
        }
        return null;
    }

    @Override
    protected String getFileId(int rowNum) {
        Cell idCell = this.sheet.getRow(rowNum).getCell(1);
        if (idCell == null || idCell.getStringCellValue().isEmpty()) {
            return "";
        }
        return idCell.getStringCellValue();
    }
}

