/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxSnippet;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.library.model.pointer.ByteOffsetPointer;
import org.spdx.library.model.pointer.LineCharPointer;
import org.spdx.library.model.pointer.SinglePointer;
import org.spdx.library.model.pointer.StartEndPointer;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.PackageInfoSheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public class SnippetSheet
extends AbstractSheet {
    static final Logger logger = LoggerFactory.getLogger(SnippetSheet.class);
    static final int ID_COL = 0;
    static final int NAME_COL = 1;
    static final int SNIPPET_FROM_FILE_ID_COL = 2;
    static final int BYTE_RANGE_COL = 3;
    static final int LINE_RANGE_COL = 4;
    static final int CONCLUDED_LICENSE_COL = 5;
    static final int LICENSE_INFO_IN_SNIPPET_COL = 6;
    static final int LICENSE_COMMENT_COL = 7;
    static final int COPYRIGHT_COL = 8;
    static final int COMMENT_COL = 9;
    static final int USER_DEFINED_COLS = 10;
    static final int NUM_COLS = 11;
    static final boolean[] REQUIRED = new boolean[]{true, false, true, true, false, false, false, false, false, false, false};
    static final String[] HEADER_TITLES = new String[]{"ID", "Name", "From File ID", "Byte Range", "Line Range", "License Concluded", "License Info in Snippet", "License Comments", "Snippet Copyright Text", "Comment", "User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{25, 25, 25, 40, 40, 60, 60, 60, 60, 60, 40};
    static final boolean[] LEFT_WRAP = new boolean[]{false, false, false, false, false, true, true, true, true, true, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{true, true, true, true, true, false, false, false, false, false, false};
    private static Pattern NUMBER_RANGE_PATTERN = Pattern.compile("(\\d+):(\\d+)");
    Map<String, SpdxSnippet> snippetCache = new HashMap<String, SpdxSnippet>();

    public SnippetSheet(Workbook workbook, String snippetSheetName, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, snippetSheetName, modelStore, documentUri, copyManager);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX Snippets does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 10; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX Snippet worksheet";
            }
            boolean done = false;
            int rowNum = this.getFirstDataRow();
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getCellType() == CellType.BLANK || row.getCell(this.firstCellNum).getCellType() == CellType.STRING && row.getCell(this.firstCellNum).getStringCellValue().trim().isEmpty()) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX Snippet work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 11; ++i) {
            String range;
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (!REQUIRED[i]) continue;
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
            }
            if (i == 5) {
                try {
                    LicenseInfoFactory.parseSPDXLicenseString((String)cell.getStringCellValue(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager);
                    continue;
                }
                catch (InvalidSPDXAnalysisException ex) {
                    return "Invalid asserted license string in row " + String.valueOf(row.getRowNum()) + " details: " + ex.getMessage();
                }
            }
            if (i != 3 && i != 4 || (range = cell.getStringCellValue()) == null || range.isEmpty()) continue;
            Matcher rangeMatcher = NUMBER_RANGE_PATTERN.matcher(cell.getStringCellValue());
            if (!rangeMatcher.matches()) {
                return "Invalid range for " + HEADER_TITLES[i] + ": " + cell.getStringCellValue();
            }
            int start = 0;
            int end = 0;
            try {
                start = Integer.parseInt(rangeMatcher.group(1));
                end = Integer.parseInt(rangeMatcher.group(2));
                if (start < end) continue;
                return "Invalid range for " + HEADER_TITLES[i] + ": " + cell.getStringCellValue() + ".  End is not greater than or equal to the end.";
            }
            catch (Exception ex) {
                return "Invalid range for " + HEADER_TITLES[i] + ": " + cell.getStringCellValue();
            }
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    public void add(SpdxSnippet snippet) throws SpreadsheetException {
        Row row = this.addRow();
        if (snippet.getId() != null && !snippet.getId().isEmpty()) {
            row.createCell(0).setCellValue(snippet.getId());
        }
        try {
            Optional comment;
            Optional licenseComments;
            Collection licenseInfoFromSnippet;
            Optional lineRange;
            Optional name = snippet.getName();
            if (name.isPresent()) {
                row.createCell(1).setCellValue((String)name.get());
            }
            try {
                SpdxFile snippetFromFile = snippet.getSnippetFromFile();
                row.createCell(2).setCellValue(snippetFromFile.getId());
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Error getting the snippetFromFile", (Throwable)e);
                throw new SpreadsheetException("Unable to get the Snippet from File from the Snippet: " + e.getMessage());
            }
            try {
                StartEndPointer byteRange = snippet.getByteRange();
                try {
                    row.createCell(3).setCellValue(this.rangeToStr(byteRange));
                }
                catch (InvalidSPDXAnalysisException e) {
                    logger.error("Invalid byte range", (Throwable)e);
                    throw new SpreadsheetException("Invalid byte range: " + e.getMessage());
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Error getting the byteRange", (Throwable)e);
                throw new SpreadsheetException("Unable to get the byte range from the Snippet: " + e.getMessage());
            }
            try {
                lineRange = snippet.getLineRange();
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Error getting the lineRange", (Throwable)e);
                throw new SpreadsheetException("Unable to get the line range from the Snippet: " + e.getMessage());
            }
            if (lineRange.isPresent()) {
                try {
                    row.createCell(4).setCellValue(this.rangeToStr((StartEndPointer)lineRange.get()));
                }
                catch (InvalidSPDXAnalysisException e) {
                    logger.error("Invalid line range", (Throwable)e);
                    throw new SpreadsheetException("Invalid line range: " + e.getMessage());
                }
            }
            if (snippet.getLicenseConcluded() != null) {
                row.createCell(5).setCellValue(snippet.getLicenseConcluded().toString());
            }
            if ((licenseInfoFromSnippet = snippet.getLicenseInfoFromFiles()) != null && licenseInfoFromSnippet.size() > 0) {
                row.createCell(6).setCellValue(PackageInfoSheet.licensesToString(licenseInfoFromSnippet));
            }
            if ((licenseComments = snippet.getLicenseComments()).isPresent()) {
                row.createCell(7).setCellValue((String)licenseComments.get());
            }
            if (snippet.getCopyrightText() != null) {
                row.createCell(8).setCellValue(snippet.getCopyrightText());
            }
            if ((comment = snippet.getComment()).isPresent()) {
                row.createCell(9).setCellValue((String)comment.get());
            }
            this.snippetCache.put(snippet.getId(), snippet);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting SPDX Snippet information", e);
        }
    }

    private String rangeToStr(StartEndPointer rangePointer) throws InvalidSPDXAnalysisException {
        SinglePointer startPointer = rangePointer.getStartPointer();
        if (startPointer == null) {
            throw new InvalidSPDXAnalysisException("Missing start pointer");
        }
        SinglePointer endPointer = rangePointer.getEndPointer();
        if (endPointer == null) {
            throw new InvalidSPDXAnalysisException("Missing end pointer");
        }
        String start = null;
        if (startPointer instanceof ByteOffsetPointer) {
            start = String.valueOf(((ByteOffsetPointer)startPointer).getOffset());
        } else if (startPointer instanceof LineCharPointer) {
            start = String.valueOf(((LineCharPointer)startPointer).getLineNumber());
        } else {
            logger.error("Unknown pointer type for start pointer " + startPointer.toString());
            throw new InvalidSPDXAnalysisException("Unknown pointer type for start pointer");
        }
        String end = null;
        if (endPointer instanceof ByteOffsetPointer) {
            end = String.valueOf(((ByteOffsetPointer)endPointer).getOffset());
        } else if (endPointer instanceof LineCharPointer) {
            end = String.valueOf(((LineCharPointer)endPointer).getLineNumber());
        } else {
            logger.error("Unknown pointer type for start pointer " + startPointer.toString());
            throw new InvalidSPDXAnalysisException("Unknown pointer type for start pointer");
        }
        return start + ":" + end;
    }

    @Nullable
    public SpdxSnippet getSnippet(int rowNum) throws SpreadsheetException {
        SpdxSnippet retval;
        Cell commentCell;
        Cell licCommentCell;
        String lineRange;
        Optional moFromFile;
        SpdxNoAssertionLicense concludedLicense;
        Cell concludedLicenseCell;
        String id;
        if (this.sheet == null) {
            return null;
        }
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String ver = this.validateRow(row);
        if (ver != null && !ver.isEmpty()) {
            throw new SpreadsheetException(ver);
        }
        if (Objects.nonNull(row.getCell(0)) && !row.getCell(0).getStringCellValue().trim().isEmpty()) {
            id = row.getCell(0).getStringCellValue();
        } else {
            try {
                id = this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error getting anonymous ID");
            }
            row.getCell(0).setCellValue(id);
        }
        if (this.snippetCache.containsKey(id)) {
            return this.snippetCache.get(id);
        }
        String name = "";
        if (row.getCell(1) != null) {
            name = row.getCell(1).getStringCellValue();
        }
        if ((concludedLicenseCell = row.getCell(5)) != null && !concludedLicenseCell.getStringCellValue().trim().isEmpty()) {
            try {
                concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)concludedLicenseCell.getStringCellValue(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager);
            }
            catch (InvalidLicenseStringException e) {
                throw new SpreadsheetException("Invalid license expression " + concludedLicenseCell.getStringCellValue(), e);
            }
        }
        try {
            concludedLicense = new SpdxNoAssertionLicense();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error creating NoAssertionLicense", e);
        }
        ArrayList<Object> licenseInfosFromFile = new ArrayList<Object>();
        Cell seenLicenseCell = row.getCell(6);
        if (seenLicenseCell != null && !seenLicenseCell.getStringCellValue().trim().isEmpty()) {
            for (String licenseString : seenLicenseCell.getStringCellValue().split(",")) {
                try {
                    licenseInfosFromFile.add(LicenseInfoFactory.parseSPDXLicenseString((String)licenseString.trim(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager));
                }
                catch (InvalidLicenseStringException e) {
                    throw new SpreadsheetException("Invalid license expression in License Infos from File: " + licenseString, e);
                }
            }
        } else {
            try {
                licenseInfosFromFile.add(new SpdxNoAssertionLicense());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error creating NoAssertionLicense", e);
            }
        }
        Cell copyrightCell = row.getCell(8);
        String copyright = copyrightCell != null ? copyrightCell.getStringCellValue() : "NOASSERTION";
        String snippetFromFileId = this.getSnippetFileId(rowNum);
        if (Objects.isNull(snippetFromFileId) || snippetFromFileId.isEmpty()) {
            throw new SpreadsheetException("Missing required Snippet From File ID for Snippet ID " + id);
        }
        try {
            moFromFile = SpdxModelFactory.getModelObject((IModelStore)this.modelStore, (String)this.documentUri, (String)snippetFromFileId, (ModelCopyManager)this.copyManager);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting SnippetFromFile", e);
        }
        if (!moFromFile.isPresent()) {
            throw new SpreadsheetException("Snippet from file for snippet ID " + id + " does not exist in the model.  It must be created before getting the snippet information from the snippet sheet.  Restore the file information sheet first.");
        }
        if (!(moFromFile.get() instanceof SpdxFile)) {
            throw new SpreadsheetException("Invalid type for ID " + snippetFromFileId + ".  Expecting SpdxFile");
        }
        SpdxFile snippetFromFile = (SpdxFile)moFromFile.get();
        if (Objects.isNull(row.getCell(3)) && row.getCell(3).getStringCellValue().trim().isEmpty()) {
            throw new SpreadsheetException("Missing reqired byte range for Snippet ID " + id);
        }
        String range = row.getCell(3).getStringCellValue();
        int start = 0;
        int end = 0;
        Matcher rangeMatcher = NUMBER_RANGE_PATTERN.matcher(range);
        if (!rangeMatcher.matches()) {
            throw new SpreadsheetException("Invalid byte range: " + range);
        }
        try {
            start = Integer.parseInt(rangeMatcher.group(1));
            end = Integer.parseInt(rangeMatcher.group(2));
        }
        catch (Exception ex) {
            throw new SpreadsheetException("Invalid byte range: " + range);
        }
        SpdxSnippet.SpdxSnippetBuilder snippetBuilder = new SpdxSnippet.SpdxSnippetBuilder(this.modelStore, this.documentUri, id, this.copyManager, name, (AnyLicenseInfo)concludedLicense, licenseInfosFromFile, copyright, snippetFromFile, start, end);
        if (Objects.nonNull(row.getCell(4)) && (lineRange = row.getCell(4).getStringCellValue()) != null && !lineRange.isEmpty()) {
            int lineStart = 0;
            int lineEnd = 0;
            Matcher lineRangeMatcher = NUMBER_RANGE_PATTERN.matcher(lineRange);
            if (!lineRangeMatcher.matches()) {
                throw new SpreadsheetException("Invalid line range: " + lineRange);
            }
            try {
                lineStart = Integer.valueOf(lineRangeMatcher.group(1));
                lineEnd = Integer.valueOf(lineRangeMatcher.group(2));
            }
            catch (Exception ex) {
                throw new SpreadsheetException("Invalid line range: " + lineRange);
            }
            snippetBuilder.setLineRange(lineStart, lineEnd);
        }
        if (Objects.nonNull(licCommentCell = row.getCell(7)) && !licCommentCell.getStringCellValue().trim().isEmpty()) {
            snippetBuilder.setLicenseComments(licCommentCell.getStringCellValue());
        }
        if (Objects.nonNull(commentCell = row.getCell(9)) && !commentCell.getStringCellValue().trim().isEmpty()) {
            snippetBuilder.setComment(commentCell.getStringCellValue());
        }
        try {
            retval = snippetBuilder.build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error building Snippet", e);
        }
        this.snippetCache.put(id, retval);
        return retval;
    }

    public String getSnippetFileId(int rowNum) throws SpreadsheetException {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String ver = this.validateRow(row);
        if (ver != null && !ver.isEmpty()) {
            throw new SpreadsheetException(ver);
        }
        String id = null;
        if (row.getCell(2) != null) {
            id = row.getCell(2).getStringCellValue();
        }
        return id;
    }
}

