/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxCreatorInformation;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.SpdxSnippet;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ExtractedLicenseInfo;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.spreadsheetstore.AnnotationsSheet;
import org.spdx.spreadsheetstore.DocumentInfoSheet;
import org.spdx.spreadsheetstore.ExternalRefsSheet;
import org.spdx.spreadsheetstore.ExtractedLicenseInfoSheet;
import org.spdx.spreadsheetstore.PackageInfoSheet;
import org.spdx.spreadsheetstore.PerFileSheet;
import org.spdx.spreadsheetstore.RelationshipsSheet;
import org.spdx.spreadsheetstore.SnippetSheet;
import org.spdx.spreadsheetstore.SpdxSpreadsheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.simple.ExtendedSpdxStore;

public class SpreadsheetStore
extends ExtendedSpdxStore
implements ISerializableModelStore {
    static final Logger logger = LoggerFactory.getLogger(SpreadsheetStore.class);
    private SpreadsheetFormatType spreadsheetFormat;
    private static final ThreadLocal<DateFormat> FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        }
    };

    public SpreadsheetStore(IModelStore baseStore, SpreadsheetFormatType spreadsheetFormat) {
        super(baseStore);
        this.spreadsheetFormat = spreadsheetFormat;
    }

    public SpreadsheetStore(IModelStore baseStore) {
        this(baseStore, SpreadsheetFormatType.XLSX);
    }

    public void serialize(String documentUri, OutputStream stream) throws InvalidSPDXAnalysisException, IOException {
        ModelCopyManager copyManager = new ModelCopyManager();
        SpdxDocument doc = new SpdxDocument((IModelStore)this, documentUri, copyManager, false);
        SpdxSpreadsheet ss = new SpdxSpreadsheet((IModelStore)this, copyManager, documentUri, this.spreadsheetFormat);
        ss.getOriginsSheet().addDocument(doc);
        TreeMap<String, Collection<ExternalRef>> externalRefs = new TreeMap<String, Collection<ExternalRef>>();
        TreeMap<String, Collection<Relationship>> allRelationships = new TreeMap<String, Collection<Relationship>>();
        TreeMap<String, Collection<Annotation>> allAnnotations = new TreeMap<String, Collection<Annotation>>();
        Map<String, String> fileIdToPackageId = this.copyPackageInfoToSS(documentUri, ss.getPackageInfoSheet(), copyManager, externalRefs, allRelationships, allAnnotations);
        this.copyExternalRefsToSS(externalRefs, ss.getExternalRefsSheet());
        this.copyExtractedLicenseInfosToSS(doc.getExtractedLicenseInfos(), ss.getExtractedLicenseInfoSheet());
        this.copyPerFileInfoToSS(documentUri, copyManager, ss.getPerFileSheet(), fileIdToPackageId, allRelationships, allAnnotations);
        this.copySnippetInfoToSS(documentUri, copyManager, ss.getSnippetSheet(), allRelationships, allAnnotations);
        allRelationships.put(doc.getId(), doc.getRelationships());
        allAnnotations.put(doc.getId(), doc.getAnnotations());
        this.copyRelationshipsToSS(allRelationships, ss.getRelationshipsSheet());
        this.copyAnnotationsToSS(allAnnotations, ss.getAnnotationsSheet());
        ss.resizeRow();
        ss.write(stream);
    }

    private void copyAnnotationsToSS(Map<String, Collection<Annotation>> allAnnotations, AnnotationsSheet annotationsSheet) throws SpreadsheetException {
        for (Map.Entry<String, Collection<Annotation>> entry : allAnnotations.entrySet()) {
            Object[] annotations = entry.getValue().toArray(new Annotation[entry.getValue().size()]);
            Arrays.sort(annotations);
            for (Object annotation : annotations) {
                annotationsSheet.add((Annotation)annotation, entry.getKey());
            }
        }
    }

    private void copyRelationshipsToSS(Map<String, Collection<Relationship>> allRelationships, RelationshipsSheet relationshipsSheet) throws SpreadsheetException {
        for (Map.Entry<String, Collection<Relationship>> entry : allRelationships.entrySet()) {
            Object[] relationships = entry.getValue().toArray(new Relationship[entry.getValue().size()]);
            Arrays.sort(relationships);
            for (Object relationship : relationships) {
                relationshipsSheet.add((Relationship)relationship, entry.getKey());
            }
        }
    }

    private void copySnippetInfoToSS(String documentUri, ModelCopyManager copyManager, SnippetSheet snippetSheet, Map<String, Collection<Relationship>> allRelationships, Map<String, Collection<Annotation>> allAnnotations) throws InvalidSPDXAnalysisException {
        List snippets;
        try (Stream snippetStream = SpdxModelFactory.getElements((IModelStore)this, (String)documentUri, (ModelCopyManager)copyManager, SpdxSnippet.class);){
            snippets = snippetStream.collect(Collectors.toList());
        }
        Collections.sort(snippets);
        for (SpdxSnippet snippet : snippets) {
            Collection annotations;
            snippetSheet.add(snippet);
            Collection relationships = snippet.getRelationships();
            if (relationships.size() > 0) {
                allRelationships.put(snippet.getId(), relationships);
            }
            if ((annotations = snippet.getAnnotations()).size() <= 0) continue;
            allAnnotations.put(snippet.getId(), annotations);
        }
    }

    private void copyPerFileInfoToSS(String documentUri, ModelCopyManager copyManager, PerFileSheet perFileSheet, Map<String, String> fileIdToPackageId, Map<String, Collection<Relationship>> allRelationships, Map<String, Collection<Annotation>> allAnnotations) throws InvalidSPDXAnalysisException {
        List files;
        try (Stream fileStream = SpdxModelFactory.getElements((IModelStore)this, (String)documentUri, (ModelCopyManager)copyManager, SpdxFile.class);){
            files = fileStream.collect(Collectors.toList());
        }
        Collections.sort(files);
        for (SpdxFile file : files) {
            Collection annotations;
            perFileSheet.add(file, fileIdToPackageId.get(file.getId()));
            Collection relationships = file.getRelationships();
            if (relationships.size() > 0) {
                allRelationships.put(file.getId(), relationships);
            }
            if ((annotations = file.getAnnotations()).size() <= 0) continue;
            allAnnotations.put(file.getId(), annotations);
        }
    }

    private void copyExtractedLicenseInfosToSS(Collection<ExtractedLicenseInfo> extractedLicenseInfos, ExtractedLicenseInfoSheet extractedLicenseInfoSheet) throws InvalidSPDXAnalysisException {
        ExtractedLicenseInfo[] licenses = extractedLicenseInfos.toArray(new ExtractedLicenseInfo[extractedLicenseInfos.size()]);
        Arrays.sort(licenses, new Comparator<ExtractedLicenseInfo>(){

            @Override
            public int compare(ExtractedLicenseInfo o1, ExtractedLicenseInfo o2) {
                int result = 0;
                try {
                    result = o1.getName() != null && !o1.getName().trim().isEmpty() ? (o2.getName() != null && !o2.getName().trim().isEmpty() ? o1.getName().compareToIgnoreCase(o2.getName()) : 1) : -1;
                }
                catch (InvalidSPDXAnalysisException e) {
                    result = 0;
                }
                if (result == 0) {
                    result = o1.getLicenseId().compareToIgnoreCase(o2.getLicenseId());
                }
                return result;
            }
        });
        for (ExtractedLicenseInfo license : licenses) {
            extractedLicenseInfoSheet.add(license.getLicenseId(), license.getExtractedText(), license.getName(), license.getSeeAlso(), license.getComment());
        }
    }

    private void copyExternalRefsToSS(Map<String, Collection<ExternalRef>> externalRefsMap, ExternalRefsSheet externalRefSheet) throws SpreadsheetException {
        for (Map.Entry<String, Collection<ExternalRef>> entry : externalRefsMap.entrySet()) {
            Object[] externalRefs = entry.getValue().toArray(new ExternalRef[entry.getValue().size()]);
            Arrays.sort(externalRefs);
            for (Object externalRef : externalRefs) {
                externalRefSheet.add(entry.getKey(), (ExternalRef)externalRef);
            }
        }
    }

    private Map<String, String> copyPackageInfoToSS(String documentUri, PackageInfoSheet packageInfoSheet, ModelCopyManager copyManager, Map<String, Collection<ExternalRef>> externalRefs, Map<String, Collection<Relationship>> allRelationships, Map<String, Collection<Annotation>> allAnnotations) throws InvalidSPDXAnalysisException {
        List packages;
        HashMap<String, String> fileIdToPkgId = new HashMap<String, String>();
        try (Stream packageStream = SpdxModelFactory.getElements((IModelStore)this, (String)documentUri, (ModelCopyManager)copyManager, SpdxPackage.class);){
            packages = packageStream.collect(Collectors.toList());
        }
        Collections.sort(packages);
        for (SpdxPackage pkg : packages) {
            Collection annotations;
            String pkgId = pkg.getId();
            Collection files = pkg.getFiles();
            for (SpdxFile file : files) {
                String fileId = file.getId();
                String pkgIdsForFile = (String)fileIdToPkgId.get(fileId);
                pkgIdsForFile = pkgIdsForFile == null ? pkgId : pkgIdsForFile + ", " + pkgId;
                fileIdToPkgId.put(fileId, pkgIdsForFile);
            }
            Collection pkgExternalRefs = pkg.getExternalRefs();
            if (pkgExternalRefs != null && pkgExternalRefs.size() > 0) {
                externalRefs.put(pkgId, pkgExternalRefs);
            }
            packageInfoSheet.add(pkg);
            Collection relationships = pkg.getRelationships();
            if (relationships.size() > 0) {
                allRelationships.put(pkg.getId(), relationships);
            }
            if ((annotations = pkg.getAnnotations()).size() <= 0) continue;
            allAnnotations.put(pkg.getId(), annotations);
        }
        return fileIdToPkgId;
    }

    public String deSerialize(InputStream stream, boolean overwrite) throws InvalidSPDXAnalysisException, IOException {
        ModelCopyManager copyManager = new ModelCopyManager();
        SpdxSpreadsheet ss = new SpdxSpreadsheet(stream, (IModelStore)this, copyManager);
        if (this.exists(ss.getDocumentUri(), "SPDXRef-DOCUMENT")) {
            if (!overwrite) {
                throw new InvalidSPDXAnalysisException("Document " + ss.getDocumentUri() + " already exists.");
            }
            this.clear(ss.getDocumentUri());
        }
        SpdxDocument document = new SpdxDocument((IModelStore)this, ss.getDocumentUri(), copyManager, true);
        this.copyDocumentInfoFromSS(ss.getOriginsSheet(), document, ss.getDocumentUri(), copyManager);
        ss.getReviewersSheet().addReviewsToDocAnnotations();
        this.copyExtractedLicenseInfosFromSS(ss.getExtractedLicenseInfoSheet(), document, ss.getDocumentUri(), copyManager);
        Map<String, SpdxPackage> pkgIdToPackage = this.copyPackageInfoFromSS(ss.getPackageInfoSheet(), ss.getExternalRefsSheet(), document);
        Map<String, SpdxFile> fileIdToFile = this.copyPerFileInfoFromSS(ss.getPerFileSheet(), document, pkgIdToPackage);
        this.copyPerSnippetInfoFromSS(ss.getSnippetSheet(), document, fileIdToFile);
        this.copyAnnotationInfoFromSS(ss.getAnnotationsSheet(), document);
        Map<String, List<String>> packageContainsFileIds = this.copyRelationshipInfoFromSS(ss.getRelationshipsSheet(), document);
        this.copyAnyMissingFileContains(ss.getPerFileSheet(), pkgIdToPackage, fileIdToFile, packageContainsFileIds);
        return ss.getDocumentUri();
    }

    private void copyAnyMissingFileContains(PerFileSheet perFileSheet, Map<String, SpdxPackage> pkgIdToPackage, Map<String, SpdxFile> fileIdToFile, Map<String, List<String>> packageContainsFileIds) throws InvalidSPDXAnalysisException {
        int firstRow = perFileSheet.getFirstDataRow();
        int numFiles = perFileSheet.getNumDataRows();
        for (int i = 0; i < numFiles; ++i) {
            String fileId = perFileSheet.getFileId(firstRow + i);
            List<String> pkgIds = perFileSheet.getPackageIds(firstRow + i);
            for (String pkgId : pkgIds) {
                if (packageContainsFileIds.containsKey(pkgId) && packageContainsFileIds.get(pkgId).contains(fileId)) continue;
                SpdxPackage pkg = pkgIdToPackage.get(pkgId);
                SpdxFile file = fileIdToFile.get(fileId);
                if (pkg != null && file != null) {
                    if (pkg.getFiles().contains(file)) {
                        logger.debug("Skipping duplicate hasFiles");
                        continue;
                    }
                    pkg.addFile(file);
                    continue;
                }
                logger.warn("Can not add file " + file.getName() + " to package " + pkgId);
            }
        }
    }

    private void copyExtractedLicenseInfosFromSS(ExtractedLicenseInfoSheet extractedLicenseInfoSheet, SpdxDocument document, String documentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        int numNonStdLicenses = extractedLicenseInfoSheet.getNumDataRows();
        int firstRow = extractedLicenseInfoSheet.getFirstDataRow();
        for (int i = 0; i < numNonStdLicenses; ++i) {
            ExtractedLicenseInfo licenseInfo = new ExtractedLicenseInfo((IModelStore)this, documentUri, extractedLicenseInfoSheet.getIdentifier(firstRow + i), copyManager, true);
            licenseInfo.setExtractedText(extractedLicenseInfoSheet.getExtractedText(firstRow + i));
            licenseInfo.setName(extractedLicenseInfoSheet.getLicenseName(firstRow + i));
            licenseInfo.setSeeAlso(extractedLicenseInfoSheet.getCrossRefUrls(firstRow + i));
            licenseInfo.setComment(extractedLicenseInfoSheet.getComment(firstRow + i));
            document.addExtractedLicenseInfos(licenseInfo);
        }
    }

    private void copyDocumentInfoFromSS(DocumentInfoSheet documentInfoSheet, SpdxDocument document, String documentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Collection<ExternalDocumentRef> externalRefs;
        String docName;
        String licenseListVersion;
        Date createdDate = documentInfoSheet.getCreated();
        String created = FORMAT.get().format(createdDate);
        List<String> createdBys = documentInfoSheet.getCreatedBy();
        SpdxCreatorInformation creationInfo = document.createCreationInfo(createdBys, created);
        String creatorComment = documentInfoSheet.getAuthorComments();
        if (Objects.nonNull(creatorComment)) {
            creationInfo.setComment(creatorComment);
        }
        if (Objects.nonNull(licenseListVersion = documentInfoSheet.getLicenseListVersion())) {
            creationInfo.setLicenseListVersion(licenseListVersion);
        }
        document.setCreationInfo(creationInfo);
        String specVersion = documentInfoSheet.getSPDXVersion();
        document.setSpecVersion(specVersion);
        String dataLicenseId = documentInfoSheet.getDataLicense();
        if (dataLicenseId == null || dataLicenseId.isEmpty()) {
            dataLicenseId = "CC0-1.0";
        }
        SpdxListedLicense dataLicense = null;
        try {
            dataLicense = (SpdxListedLicense)LicenseInfoFactory.parseSPDXLicenseString((String)dataLicenseId, (IModelStore)this, (String)documentUri, (ModelCopyManager)copyManager);
        }
        catch (Exception ex) {
            logger.warn("Unable to parse the provided standard license ID.  Using CC0-1.0");
            try {
                dataLicense = (SpdxListedLicense)LicenseInfoFactory.parseSPDXLicenseString((String)"CC0-1.0", (IModelStore)this, (String)documentUri, (ModelCopyManager)copyManager);
            }
            catch (Exception e) {
                throw new InvalidSPDXAnalysisException("Unable to get document license");
            }
        }
        document.setDataLicense((AnyLicenseInfo)dataLicense);
        String docComment = documentInfoSheet.getDocumentComment();
        if (docComment != null && !(docComment = docComment.trim()).isEmpty()) {
            document.setComment(docComment);
        }
        if ((docName = documentInfoSheet.getDocumentName()) != null) {
            document.setName(docName);
        }
        if ((externalRefs = documentInfoSheet.getExternalDocumentRefs()) != null) {
            document.setExternalDocumentRefs(externalRefs);
        }
    }

    private Map<String, SpdxPackage> copyPackageInfoFromSS(PackageInfoSheet packageInfoSheet, ExternalRefsSheet externalRefsSheet, SpdxDocument analysis) throws SpreadsheetException, InvalidSPDXAnalysisException {
        List<SpdxPackage> packages = packageInfoSheet.getPackages();
        HashMap<String, SpdxPackage> pkgIdToPackage = new HashMap<String, SpdxPackage>();
        for (SpdxPackage pkg : packages) {
            for (ExternalRef externalRef : externalRefsSheet.getExternalRefsForPkgid(pkg.getId())) {
                pkg.addExternalRef(externalRef);
            }
            pkgIdToPackage.put(pkg.getId(), pkg);
        }
        return pkgIdToPackage;
    }

    private Map<String, SpdxFile> copyPerFileInfoFromSS(PerFileSheet perFileSheet, SpdxDocument analysis, Map<String, SpdxPackage> pkgIdToPackage) throws SpreadsheetException, InvalidSPDXAnalysisException {
        int firstRow = perFileSheet.getFirstDataRow();
        int numFiles = perFileSheet.getNumDataRows();
        HashMap<String, SpdxFile> retval = new HashMap<String, SpdxFile>();
        for (int i = 0; i < numFiles; ++i) {
            SpdxFile file = perFileSheet.getFileInfo(firstRow + i);
            retval.put(file.getId(), file);
        }
        return retval;
    }

    private void copyPerSnippetInfoFromSS(SnippetSheet snippetSheet, SpdxDocument analysis, Map<String, SpdxFile> fileIdToFile) throws InvalidSPDXAnalysisException, SpreadsheetException {
        int i = snippetSheet.getFirstDataRow();
        SpdxSnippet snippet = snippetSheet.getSnippet(i++);
        while (Objects.nonNull(snippet)) {
            snippet = snippetSheet.getSnippet(i++);
        }
    }

    private Map<String, List<String>> copyRelationshipInfoFromSS(RelationshipsSheet relationshipsSheet, SpdxDocument analysis) throws SpreadsheetException, InvalidSPDXAnalysisException {
        HashMap<String, List<String>> retval = new HashMap<String, List<String>>();
        int i = relationshipsSheet.getFirstDataRow();
        Relationship relationship = relationshipsSheet.getRelationship(i);
        String id = relationshipsSheet.getElmementId(i);
        while (Objects.nonNull(relationship) && Objects.nonNull(id)) {
            Optional mo = SpdxModelFactory.getModelObject((IModelStore)analysis.getModelStore(), (String)analysis.getDocumentUri(), (String)id, (ModelCopyManager)analysis.getCopyManager());
            if (!mo.isPresent()) {
                throw new SpreadsheetException("Missing SPDX element for relationship: " + id);
            }
            if (!(mo.get() instanceof SpdxElement)) {
                throw new SpreadsheetException("ID for SPDX relationship is not of type SpdxElement: " + id);
            }
            if (mo.get() instanceof SpdxPackage && relationship.getRelationshipType().equals((Object)RelationshipType.CONTAINS) && relationship.getRelatedSpdxElement().isPresent() && relationship.getRelatedSpdxElement().get() instanceof SpdxFile) {
                ArrayList<String> fileIds = (ArrayList<String>)retval.get(((ModelObject)mo.get()).getId());
                if (fileIds == null) {
                    fileIds = new ArrayList<String>();
                    retval.put(((ModelObject)mo.get()).getId(), fileIds);
                }
                fileIds.add(((SpdxElement)relationship.getRelatedSpdxElement().get()).getId());
                if (((SpdxPackage)mo.get()).getFiles().contains(relationship.getRelatedSpdxElement().get())) {
                    logger.debug("Skipping duplicate hasFile relationship");
                } else {
                    ((SpdxElement)mo.get()).addRelationship(relationship);
                }
            } else {
                ((SpdxElement)mo.get()).addRelationship(relationship);
            }
            relationship = relationshipsSheet.getRelationship(++i);
            id = relationshipsSheet.getElmementId(i);
        }
        return retval;
    }

    private void copyAnnotationInfoFromSS(AnnotationsSheet annotationsSheet, SpdxDocument analysis) throws InvalidSPDXAnalysisException, SpreadsheetException {
        int i = annotationsSheet.getFirstDataRow();
        Annotation annotation = annotationsSheet.getAnnotation(i);
        String id = annotationsSheet.getElmementId(i);
        while (annotation != null && id != null) {
            Optional mo = SpdxModelFactory.getModelObject((IModelStore)analysis.getModelStore(), (String)analysis.getDocumentUri(), (String)id, (ModelCopyManager)analysis.getCopyManager());
            if (!mo.isPresent()) {
                throw new SpreadsheetException("Missing SPDX element for annotation: " + id);
            }
            if (!(mo.get() instanceof SpdxElement)) {
                throw new SpreadsheetException("ID for SPDX annotation is not of type SpdxElement: " + id);
            }
            ((SpdxElement)mo.get()).addAnnotation(annotation);
            annotation = annotationsSheet.getAnnotation(++i);
            id = annotationsSheet.getElmementId(i);
        }
    }

    public void unload() {
        FORMAT.remove();
    }

    public static enum SpreadsheetFormatType {
        XLS,
        XLSX;

    }
}

