/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxItem;

public class SpdxItemDifference {
    private String name;
    private String commentA;
    private String commentB;
    private String concludedLicenseA;
    private String concludedLicenseB;
    private boolean concludedLicenseEquals;
    private String copyrightA;
    private String copyrightB;
    private String licenseCommentsA;
    private String licenseCommentsB;
    private boolean seenLicensesEqual;
    private AnyLicenseInfo[] uniqueSeenLicensesA;
    private AnyLicenseInfo[] uniqueSeenLicensesB;
    private boolean relationshipsEquals;
    private Relationship[] uniqueRelationshipA;
    private Relationship[] uniqueRelationshipB;
    private boolean annotationsEquals;
    private Annotation[] uniqueAnnotationsA;
    private Annotation[] uniqueAnnotationsB;

    public SpdxItemDifference(SpdxItem itemA, SpdxItem itemB, boolean concludedLicensesEqual, boolean seenLicensesEqual, AnyLicenseInfo[] uniqueSeenLicensesA, AnyLicenseInfo[] uniqueSeenLicensesB, boolean relationshipsEquals, Relationship[] uniqueRelationshipA, Relationship[] uniqueRelationshipB, boolean annotationsEquals, Annotation[] uniqueAnnotationsA, Annotation[] uniqueAnnotationsB) throws SpdxCompareException {
        this.name = itemA.getName();
        this.commentA = itemA.getComment();
        if (this.commentA == null) {
            this.commentA = "";
        }
        this.commentB = itemB.getComment();
        if (this.commentB == null) {
            this.commentB = "";
        }
        this.concludedLicenseA = itemA.getLicenseConcluded().toString();
        this.concludedLicenseB = itemB.getLicenseConcluded().toString();
        this.concludedLicenseEquals = concludedLicensesEqual;
        this.copyrightA = itemA.getCopyrightText();
        if (this.copyrightA == null) {
            this.copyrightA = "";
        }
        this.copyrightB = itemB.getCopyrightText();
        if (this.copyrightB == null) {
            this.copyrightB = "";
        }
        this.licenseCommentsA = itemA.getLicenseComments();
        if (this.licenseCommentsA == null) {
            this.licenseCommentsA = "";
        }
        this.licenseCommentsB = itemB.getLicenseComments();
        if (this.licenseCommentsB == null) {
            this.licenseCommentsB = "";
        }
        this.seenLicensesEqual = seenLicensesEqual;
        this.uniqueSeenLicensesA = uniqueSeenLicensesA;
        this.uniqueSeenLicensesB = uniqueSeenLicensesB;
        this.relationshipsEquals = relationshipsEquals;
        this.uniqueRelationshipA = uniqueRelationshipA;
        this.uniqueRelationshipB = uniqueRelationshipB;
        this.annotationsEquals = annotationsEquals;
        this.uniqueAnnotationsA = uniqueAnnotationsA;
        this.uniqueAnnotationsB = uniqueAnnotationsB;
    }

    public String getName() {
        return this.name;
    }

    public String getCommentA() {
        return this.commentA;
    }

    public String getCommentB() {
        return this.commentB;
    }

    public String getConcludedLicenseA() {
        return this.concludedLicenseA;
    }

    public String getConcludedLicenseB() {
        return this.concludedLicenseB;
    }

    public boolean isConcludedLicenseEquals() {
        return this.concludedLicenseEquals;
    }

    public String getCopyrightA() {
        return this.copyrightA;
    }

    public String getCopyrightB() {
        return this.copyrightB;
    }

    public String getLicenseCommentsA() {
        return this.licenseCommentsA;
    }

    public String getLicenseCommentsB() {
        return this.licenseCommentsB;
    }

    public boolean isSeenLicensesEquals() {
        return this.seenLicensesEqual;
    }

    public AnyLicenseInfo[] getUniqueSeenLicensesA() {
        return this.uniqueSeenLicensesA;
    }

    public AnyLicenseInfo[] getUniqueSeenLicensesB() {
        return this.uniqueSeenLicensesB;
    }

    public boolean isCommentsEquals() {
        return SpdxComparer.stringsEqual(this.commentA, this.commentB);
    }

    public boolean isCopyrightsEqual() {
        return SpdxComparer.stringsEqual(this.copyrightA, this.copyrightB);
    }

    public boolean isLicenseCommentsEqual() {
        return SpdxComparer.stringsEqual(this.licenseCommentsA, this.licenseCommentsB);
    }

    public boolean isRelationshipsEquals() {
        return this.relationshipsEquals;
    }

    public Relationship[] getUniqueRelationshipA() {
        return this.uniqueRelationshipA;
    }

    public Relationship[] getUniqueRelationshipB() {
        return this.uniqueRelationshipB;
    }

    public boolean isAnnotationsEquals() {
        return this.annotationsEquals;
    }

    public Annotation[] getUniqueAnnotationsA() {
        return this.uniqueAnnotationsA;
    }

    public Annotation[] getUniqueAnnotationsB() {
        return this.uniqueAnnotationsB;
    }
}

