/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.merge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ConjunctiveLicenseSet;
import org.spdx.rdfparser.license.DisjunctiveLicenseSet;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;

public class SpdxLicenseMapper {
    private Map<SpdxDocument, Map<AnyLicenseInfo, AnyLicenseInfo>> nonStdLicIdMap = Maps.newHashMap();

    public ExtractedLicenseInfo mappingNewNonStdLic(SpdxDocument outputDoc, SpdxDocument subDoc, ExtractedLicenseInfo subNonStdLicInfo) {
        Map<Object, Object> interMap = Maps.newHashMap();
        if (this.docInNonStdLicIdMap(subDoc)) {
            interMap = this.nonStdLicIdMap.get(subDoc);
        }
        String NewNonStdLicId = outputDoc.getDocumentContainer().getNextLicenseRef();
        ExtractedLicenseInfo subCopy = (ExtractedLicenseInfo)subNonStdLicInfo.clone();
        subNonStdLicInfo.setLicenseId(NewNonStdLicId);
        interMap.put(subCopy, subNonStdLicInfo);
        this.nonStdLicIdMap.put(subDoc, interMap);
        return subNonStdLicInfo;
    }

    public void mappingExistingNonStdLic(SpdxDocument output, ExtractedLicenseInfo outputDocLicense, SpdxDocument subDocs, ExtractedLicenseInfo subLicense) {
        Map<Object, Object> interMap = this.docInNonStdLicIdMap(subDocs) ? this.nonStdLicIdMap.get(subDocs) : Maps.newHashMap();
        interMap.put(outputDocLicense, subLicense);
        this.nonStdLicIdMap.put(subDocs, interMap);
    }

    public SpdxFile replaceNonStdLicInFile(SpdxDocument spdxDoc, SpdxFile subFileInfo) throws InvalidSPDXAnalysisException {
        AnyLicenseInfo[] subLicInfoInFile = subFileInfo.getLicenseInfoFromFiles();
        Map<AnyLicenseInfo, AnyLicenseInfo> idMap = this.foundInterMap(spdxDoc);
        Set<AnyLicenseInfo> keys = idMap.keySet();
        AnyLicenseInfo[] orgNonStdLics = keys.toArray(new AnyLicenseInfo[idMap.keySet().size()]);
        ArrayList retval = Lists.newArrayList();
        for (int i = 0; i < subLicInfoInFile.length; ++i) {
            boolean foundLicId = false;
            for (int q = 0; q < orgNonStdLics.length; ++q) {
                if (subLicInfoInFile[i].equals(orgNonStdLics[q])) {
                    foundLicId = true;
                }
                if (foundLicId) {
                    retval.add(idMap.get(orgNonStdLics[q]));
                    continue;
                }
                retval.add(subLicInfoInFile[i]);
            }
        }
        AnyLicenseInfo[] mergedFileLics = new AnyLicenseInfo[retval.size()];
        retval.toArray(mergedFileLics);
        subFileInfo.setLicenseInfosFromFiles(mergedFileLics);
        AnyLicenseInfo subConcludedLicInFile = subFileInfo.getLicenseConcluded();
        subFileInfo.setLicenseConcluded(this.mapLicenseInfo(spdxDoc, subConcludedLicInFile));
        retval.clear();
        return subFileInfo;
    }

    public AnyLicenseInfo mapNonStdLicInMap(SpdxDocument spdxDoc, AnyLicenseInfo license) {
        Map<AnyLicenseInfo, AnyLicenseInfo> idMap = this.foundInterMap(spdxDoc);
        ExtractedLicenseInfo[] orgNonStdLics = idMap.keySet().toArray(new ExtractedLicenseInfo[idMap.keySet().size()]);
        for (int i = 0; i < orgNonStdLics.length; ++i) {
            boolean foundLic = false;
            if (license.equals(orgNonStdLics[i])) {
                foundLic = true;
            }
            if (!foundLic) continue;
            license = idMap.get(orgNonStdLics[i]);
        }
        return license;
    }

    public AnyLicenseInfo mapLicenseInfo(SpdxDocument spdxDoc, AnyLicenseInfo license) {
        if (license instanceof ConjunctiveLicenseSet) {
            AnyLicenseInfo[] members = ((ConjunctiveLicenseSet)license).getMembers();
            AnyLicenseInfo[] mappedMembers = new AnyLicenseInfo[members.length];
            for (int i = 0; i < members.length; ++i) {
                mappedMembers[i] = this.mapLicenseInfo(spdxDoc, members[i]);
            }
            license = new ConjunctiveLicenseSet(mappedMembers);
        } else if (license instanceof DisjunctiveLicenseSet) {
            AnyLicenseInfo[] members = ((DisjunctiveLicenseSet)license).getMembers();
            AnyLicenseInfo[] mappedMembers = new AnyLicenseInfo[members.length];
            for (int q = 0; q < members.length; ++q) {
                mappedMembers[q] = this.mapLicenseInfo(spdxDoc, members[q]);
            }
            license = new DisjunctiveLicenseSet(mappedMembers);
        } else if (license instanceof ExtractedLicenseInfo) {
            license = this.mapNonStdLicInMap(spdxDoc, license);
        }
        return license;
    }

    public boolean docInNonStdLicIdMap(SpdxDocument spdxDoc) {
        boolean foundDocMatch = false;
        if (this.nonStdLicIdMap.containsKey(spdxDoc)) {
            foundDocMatch = true;
        }
        return foundDocMatch;
    }

    public Map<AnyLicenseInfo, AnyLicenseInfo> foundInterMap(SpdxDocument spdxDoc) {
        return this.nonStdLicIdMap.get(spdxDoc);
    }

    public boolean isNonStdLicIdMapEmpty() {
        boolean emptyMap = false;
        if (this.nonStdLicIdMap.isEmpty()) {
            emptyMap = true;
        }
        return emptyMap;
    }

    public void clearNonStdLicIdMap() {
        this.nonStdLicIdMap.clear();
    }
}

