/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.OrLaterOperator;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.model.IRdfModel;

public class WithExceptionOperator
extends AnyLicenseInfo {
    private AnyLicenseInfo license;
    private LicenseException exception;

    public WithExceptionOperator(IModelContainer modelContainer, Node licenseInfoNode) throws InvalidSPDXAnalysisException {
        super(modelContainer, licenseInfoNode);
        this.getPropertiesFromModel();
    }

    public WithExceptionOperator(AnyLicenseInfo license, LicenseException exception) {
        this.license = license;
        this.exception = exception;
    }

    protected Resource _createResource(Resource type) throws InvalidSPDXAnalysisException {
        Resource r = this.model.createResource(type);
        Property licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
        Resource licResource = this.license.createResource(this.modelContainer);
        r.addProperty(licProperty, (RDFNode)licResource);
        Property exceptionProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseException");
        Resource exceptionResource = this.exception.createResource(this.modelContainer);
        r.addProperty(exceptionProperty, (RDFNode)exceptionResource);
        return r;
    }

    public AnyLicenseInfo getLicense() {
        if (this.resource != null && this.refreshOnGet) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "member").asNode();
            Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
            ExtendedIterator tripleIter = this.model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                try {
                    AnyLicenseInfo anyLicense = LicenseInfoFactory.getLicenseInfoFromModel(this.modelContainer, t.getObject());
                    if (!(anyLicense instanceof SimpleLicensingInfo) && !(anyLicense instanceof OrLaterOperator)) {
                        logger.warn("The license for a WITH expression must be of type SimpleLicensingInfo or an OrLaterOperator, using stored exception license");
                    }
                    this.license = anyLicense;
                }
                catch (InvalidSPDXAnalysisException e) {
                    logger.warn("Error getting license info - using stored value", (Throwable)e);
                }
            }
        }
        return this.license;
    }

    public void setLicense(AnyLicenseInfo license) throws InvalidSPDXAnalysisException {
        this.license = license;
        if (this.model != null && this.node != null) {
            Property licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
            this.model.removeAll(this.resource, licProperty, null);
            licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
            Resource licResource = license.createResource(this.modelContainer);
            this.resource.addProperty(licProperty, (RDFNode)licResource);
        }
    }

    public LicenseException getException() {
        if (this.resource != null && this.refreshOnGet) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseException").asNode();
            Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
            ExtendedIterator tripleIter = this.model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                try {
                    this.exception = new LicenseException(this.modelContainer, t.getObject());
                }
                catch (InvalidSPDXAnalysisException e) {
                    logger.warn("Error getting exception, using stored exception value", (Throwable)e);
                }
            }
        }
        return this.exception;
    }

    public void setException(LicenseException exception) throws InvalidSPDXAnalysisException {
        this.exception = exception;
        if (this.model != null && this.node != null) {
            Property exceptionProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseException");
            this.model.removeAll(this.resource, exceptionProperty, null);
            exceptionProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseException");
            Resource exceptionResource = exception.createResource(this.modelContainer);
            this.resource.addProperty(exceptionProperty, (RDFNode)exceptionResource);
        }
    }

    @Override
    public String toString() {
        if (this.license == null || this.exception == null) {
            return "UNDEFINED WITH EXCEPTION";
        }
        return this.license.toString() + " " + this.exception.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof WithExceptionOperator)) {
            return false;
        }
        WithExceptionOperator comp = (WithExceptionOperator)o;
        if (comp.getLicense() == null ? this.getLicense() != null : !comp.getLicense().equals(this.getLicense())) {
            return false;
        }
        return !(comp.getException() == null ? this.getException() != null : !comp.getException().equals(this.getException()));
    }

    @Override
    public int hashCode() {
        int licHashCode = 0;
        int exceptionHashCode = 0;
        if (this.license != null) {
            licHashCode = this.license.hashCode();
        }
        if (this.exception != null) {
            exceptionHashCode = this.exception.hashCode();
        }
        return licHashCode ^ exceptionHashCode;
    }

    @Override
    public List<String> verify() {
        ArrayList retval = Lists.newArrayList();
        if (this.license == null) {
            retval.add("Missing required license for a License WITH Exception");
        } else {
            retval.addAll(this.license.verify());
        }
        if (this.exception == null) {
            retval.add("Missing required exception for a License WITH Exception");
        } else {
            retval.addAll(this.exception.verify());
        }
        return retval;
    }

    @Override
    public AnyLicenseInfo clone() {
        AnyLicenseInfo clonedLicense = null;
        if (this.license != null) {
            clonedLicense = this.license.clone();
        }
        LicenseException clonedException = null;
        if (this.exception != null) {
            clonedException = this.exception.clone();
        }
        return new WithExceptionOperator(clonedLicense, clonedException);
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (compare == this) {
            return true;
        }
        if (!(compare instanceof WithExceptionOperator)) {
            return false;
        }
        WithExceptionOperator wCompare = (WithExceptionOperator)compare;
        return RdfModelHelper.equivalentConsideringNull(this.license, wCompare.getLicense()) && RdfModelHelper.equivalentConsideringNull(this.exception, wCompare.getException());
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        Property licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
        this.model.removeAll(this.resource, licProperty, null);
        licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
        Resource licResource = this.license.createResource(this.modelContainer);
        this.resource.addProperty(licProperty, (RDFNode)licResource);
        Property exceptionProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseException");
        this.model.removeAll(this.resource, exceptionProperty, null);
        exceptionProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseException");
        Resource exceptionResource = this.exception.createResource(this.modelContainer);
        this.resource.addProperty(exceptionProperty, (RDFNode)exceptionResource);
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        Triple t;
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "member").asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            if (this.license != null) {
                throw new InvalidSPDXAnalysisException("More than one license for a license WITH expression");
            }
            AnyLicenseInfo anyLicense = LicenseInfoFactory.getLicenseInfoFromModel(this.modelContainer, t.getObject());
            if (!(anyLicense instanceof SimpleLicensingInfo) && !(anyLicense instanceof OrLaterOperator)) {
                throw new InvalidSPDXAnalysisException("The license for a WITH expression must be of type SimpleLicensingInfo or an OrLaterOperator");
            }
            this.license = anyLicense;
        }
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseException").asNode();
        m = Triple.createMatch((Node)this.node, (Node)p, null);
        tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            if (this.exception != null) {
                throw new InvalidSPDXAnalysisException("More than one exception license WITH expression");
            }
            this.exception = new LicenseException(this.modelContainer, t.getObject());
        }
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#WithExceptionOperator");
    }
}

