/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.RdfParserHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxItem;

public class SpdxFile
extends SpdxItem
implements Comparable<SpdxFile> {
    static final Logger logger = LoggerFactory.getLogger((String)SpdxFile.class.getName());
    @Deprecated
    public static final Map<FileType, String> FILE_TYPE_TO_TAG;
    @Deprecated
    public static final Map<String, FileType> TAG_TO_FILE_TYPE;
    FileType[] fileTypes = new FileType[0];
    Checksum[] checksums;
    String[] fileContributors = new String[0];
    String noticeText;
    DoapProject[] artifactOf = new DoapProject[0];
    SpdxFile[] fileDependencies = new SpdxFile[0];

    public SpdxFile(String name, String comment, Annotation[] annotations, Relationship[] relationships, AnyLicenseInfo licenseConcluded, AnyLicenseInfo[] licenseInfoInFile, String copyrightText, String licenseComment, FileType[] fileTypes, Checksum[] checksums, String[] fileContributors, String noticeText, DoapProject[] artifactOf) throws InvalidSPDXAnalysisException {
        super(name, comment, annotations, relationships, licenseConcluded, licenseInfoInFile, copyrightText, licenseComment);
        this.fileTypes = fileTypes;
        if (this.fileTypes == null) {
            this.fileTypes = new FileType[0];
        }
        this.checksums = checksums;
        if (this.checksums == null) {
            this.checksums = new Checksum[0];
        }
        this.fileContributors = fileContributors;
        if (this.fileContributors == null) {
            this.fileContributors = new String[0];
        }
        this.noticeText = noticeText;
        this.fileDependencies = new SpdxFile[0];
        this.artifactOf = artifactOf;
        if (this.artifactOf == null) {
            this.artifactOf = new DoapProject[0];
        }
    }

    public SpdxFile(String fileName, FileType[] fileTypes, String sha1Value, AnyLicenseInfo licenseConcluded, AnyLicenseInfo[] licenseInfoInFiles, String licenseComment, String copyrightText, DoapProject[] artifactOfs, String fileComment) throws InvalidSPDXAnalysisException {
        this(fileName, fileComment, new Annotation[0], new Relationship[0], licenseConcluded, licenseInfoInFiles, copyrightText, licenseComment, fileTypes, new Checksum[]{new Checksum(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1, sha1Value)}, new String[0], "", artifactOfs);
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        super.getPropertiesFromModel();
        this.getMyPropertiesFromModel();
    }

    void getMyPropertiesFromModel() throws InvalidSPDXAnalysisException {
        String[] fileTypeUris = this.findUriPropertyValues("http://spdx.org/rdf/terms#", "fileType");
        this.fileTypes = this.urisToFileType(fileTypeUris, false);
        this.checksums = this.findMultipleChecksumPropertyValues("http://spdx.org/rdf/terms#", "checksum");
        this.fileContributors = this.findMultiplePropertyValues("http://spdx.org/rdf/terms#", "fileContributor");
        this.noticeText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "noticeText");
        SpdxElement[] fileDependencyElements = this.findMultipleElementPropertyValues("http://spdx.org/rdf/terms#", "fileDependency");
        int count = 0;
        if (fileDependencyElements != null) {
            for (int i = 0; i < fileDependencyElements.length; ++i) {
                if (!(fileDependencyElements[i] instanceof SpdxFile)) continue;
                ++count;
            }
        }
        if (count > 0) {
            this.fileDependencies = new SpdxFile[count];
            int j = 0;
            for (int i = 0; i < fileDependencyElements.length; ++i) {
                if (!(fileDependencyElements[i] instanceof SpdxFile)) continue;
                this.fileDependencies[j++] = (SpdxFile)fileDependencyElements[i];
            }
        } else {
            this.fileDependencies = new SpdxFile[0];
        }
        this.artifactOf = this.findMultipleDoapPropertyValues("http://spdx.org/rdf/terms#", "artifactOf");
    }

    public SpdxFile(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getMyPropertiesFromModel();
    }

    protected static Resource findFileResource(IModelContainer modelContainer, SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        Model model = modelContainer.getModel();
        Node fileNameProperty = model.getProperty("http://spdx.org/rdf/terms#", "fileName").asNode();
        if (spdxFile.getName() == null) {
            return null;
        }
        Triple fileNameMatch = Triple.createMatch(null, (Node)fileNameProperty, (Node)NodeFactory.createLiteral((String)spdxFile.getName()));
        ExtendedIterator filenameMatchIter = model.getGraph().find(fileNameMatch);
        if (filenameMatchIter.hasNext()) {
            Triple checksumMatchTriple;
            Checksum cksum;
            Triple fileMatchTriple = (Triple)filenameMatchIter.next();
            Node fileNode = fileMatchTriple.getSubject();
            Node checksumProperty = model.getProperty("http://spdx.org/rdf/terms#", "checksum").asNode();
            Triple checksumMatch = Triple.createMatch((Node)fileNode, (Node)checksumProperty, null);
            ExtendedIterator checksumMatchIterator = model.getGraph().find(checksumMatch);
            if (checksumMatchIterator.hasNext() && (cksum = new Checksum(modelContainer, (checksumMatchTriple = (Triple)checksumMatchIterator.next()).getObject())).getAlgorithm().equals((Object)Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1) && cksum.getValue().compareToIgnoreCase(spdxFile.getSha1()) == 0) {
                return RdfParserHelper.convertToResource(model, fileNode);
            }
        }
        return null;
    }

    @Override
    public Resource findDuplicateResource(IModelContainer modelContainer, String uri) throws InvalidSPDXAnalysisException {
        return SpdxFile.findFileResource(modelContainer, this);
    }

    public String getSha1() {
        if (this.checksums != null) {
            for (int i = 0; i < this.checksums.length; ++i) {
                if (!this.checksums[i].getAlgorithm().equals((Object)Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1)) continue;
                return this.checksums[i].getValue();
            }
        }
        return "";
    }

    private FileType[] urisToFileType(String[] uris, boolean ignoreErrors) throws InvalidSPDXAnalysisException {
        ArrayList retval = Lists.newArrayList();
        for (int i = 0; i < uris.length; ++i) {
            if (uris[i] == null || uris[i].isEmpty()) continue;
            if (!uris[i].startsWith("http://spdx.org/rdf/terms#")) {
                throw new InvalidSPDXAnalysisException("Invalid file type: " + uris[i]);
            }
            String fileTypeS = uris[i].substring("http://spdx.org/rdf/terms#".length());
            try {
                retval.add(FileType.valueOf(fileTypeS));
                continue;
            }
            catch (Exception ex) {
                logger.error("Invalid file type in the model - " + fileTypeS);
                if (ignoreErrors) continue;
                throw new InvalidSPDXAnalysisException("Invalid file type: " + uris[i]);
            }
        }
        return retval.toArray(new FileType[retval.size()]);
    }

    private String[] fileTypesToUris(FileType[] fileTypes) {
        String[] retval = new String[fileTypes.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = "http://spdx.org/rdf/terms#" + fileTypes[i].toString();
        }
        return retval;
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        super.populateModel();
        this.setPropertyUriValues("http://spdx.org/rdf/terms#", "fileType", this.fileTypesToUris(this.fileTypes));
        this.setPropertyValues("http://spdx.org/rdf/terms#", "checksum", this.checksums);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "fileContributor", this.fileContributors);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "noticeText", this.noticeText);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "artifactOf", this.artifactOf);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "fileDependency", this.fileDependencies, false);
    }

    @Override
    protected String getLicenseInfoFromFilesPropertyName() {
        return "licenseInfoInFile";
    }

    @Override
    protected String getNamePropertyName() {
        return "fileName";
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#File");
    }

    public FileType[] getFileTypes() {
        if (this.resource != null && this.refreshOnGet) {
            String[] fileTypeUris = this.findUriPropertyValues("http://spdx.org/rdf/terms#", "fileType");
            try {
                this.fileTypes = this.urisToFileType(fileTypeUris, true);
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.fileTypes;
    }

    public void setFileTypes(FileType[] fileTypes) throws InvalidSPDXAnalysisException {
        this.fileTypes = fileTypes;
        if (this.fileTypes == null) {
            this.fileTypes = new FileType[0];
        }
        this.setPropertyUriValues("http://spdx.org/rdf/terms#", "fileType", this.fileTypesToUris(this.fileTypes));
    }

    public void addFileType(FileType fileType) throws InvalidSPDXAnalysisException {
        if (fileType == null) {
            return;
        }
        this.fileTypes = Arrays.copyOf(this.fileTypes, this.fileTypes.length + 1);
        this.fileTypes[this.fileTypes.length - 1] = fileType;
        this.addPropertyUriValue("http://spdx.org/rdf/terms#", "fileType", fileType.toString());
    }

    public Checksum[] getChecksums() {
        if (this.resource != null && this.refreshOnGet) {
            try {
                IRdfModel[] refresh = this.findMultipleChecksumPropertyValues("http://spdx.org/rdf/terms#", "checksum");
                if (refresh == null || !this.arraysEquivalent(refresh, this.checksums, true)) {
                    this.checksums = refresh;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Invalid checksum in model");
            }
        }
        return this.checksums;
    }

    public void setChecksums(Checksum[] checksums) throws InvalidSPDXAnalysisException {
        this.checksums = checksums;
        this.setPropertyValues("http://spdx.org/rdf/terms#", "checksum", this.checksums);
    }

    public void addChecksum(Checksum checksum) throws InvalidSPDXAnalysisException {
        if (checksum == null) {
            return;
        }
        this.checksums = Arrays.copyOf(this.checksums, this.checksums.length + 1);
        this.checksums[this.checksums.length - 1] = checksum;
        this.addPropertyValue("http://spdx.org/rdf/terms#", "checksum", checksum);
    }

    public String[] getFileContributors() {
        if (this.resource != null && this.refreshOnGet) {
            this.fileContributors = this.findMultiplePropertyValues("http://spdx.org/rdf/terms#", "fileContributor");
        }
        return this.fileContributors;
    }

    public void setFileContributors(String[] fileContributors) {
        this.fileContributors = fileContributors == null ? new String[0] : fileContributors;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "fileContributor", fileContributors);
    }

    public String getNoticeText() {
        if (this.resource != null && this.refreshOnGet) {
            this.noticeText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "noticeText");
        }
        return this.noticeText;
    }

    public void setNoticeText(String noticeText) {
        this.noticeText = noticeText;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "noticeText", noticeText);
    }

    @Deprecated
    public DoapProject[] getArtifactOf() {
        if (this.resource != null && this.refreshOnGet) {
            try {
                IRdfModel[] refresh = this.findMultipleDoapPropertyValues("http://spdx.org/rdf/terms#", "artifactOf");
                if (refresh == null || !this.arraysEquivalent(refresh, this.artifactOf, true)) {
                    this.artifactOf = refresh;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Invalid artifact of in the model");
            }
        }
        return this.artifactOf;
    }

    @Deprecated
    public void setArtifactOf(DoapProject[] artifactOf) throws InvalidSPDXAnalysisException {
        this.artifactOf = artifactOf == null ? new DoapProject[0] : artifactOf;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "artifactOf", this.artifactOf);
    }

    @Deprecated
    public SpdxFile[] getFileDependencies() {
        if (this.resource != null && this.refreshOnGet) {
            try {
                IRdfModel[] fileDependencyElements = this.findMultipleElementPropertyValues("http://spdx.org/rdf/terms#", "fileDependency");
                if (!this.arraysEquivalent(fileDependencyElements, this.fileDependencies, false)) {
                    int count = 0;
                    if (fileDependencyElements != null) {
                        for (int i = 0; i < fileDependencyElements.length; ++i) {
                            if (!(fileDependencyElements[i] instanceof SpdxFile)) continue;
                            ++count;
                        }
                    }
                    if (count > 0) {
                        this.fileDependencies = new SpdxFile[count];
                        int j = 0;
                        for (int i = 0; i < fileDependencyElements.length; ++i) {
                            if (!(fileDependencyElements[i] instanceof SpdxFile)) continue;
                            this.fileDependencies[j++] = (SpdxFile)fileDependencyElements[i];
                        }
                    }
                }
            }
            catch (InvalidSPDXAnalysisException ex) {
                logger.error("Error getting file dependencies", (Throwable)ex);
            }
        }
        return this.fileDependencies;
    }

    @Deprecated
    public void setFileDependencies(SpdxFile[] fileDependencies) throws InvalidSPDXAnalysisException {
        this.fileDependencies = fileDependencies == null ? new SpdxFile[0] : fileDependencies;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "fileDependency", this.fileDependencies);
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        return this.equivalent(o, true);
    }

    @Override
    public boolean equivalent(IRdfModel o, boolean testRelationships) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpdxFile)) {
            return false;
        }
        SpdxFile comp = (SpdxFile)o;
        if (!super.equivalent(comp, testRelationships)) {
            return false;
        }
        return this.arraysEquivalent(this.getChecksums(), comp.getChecksums(), testRelationships) && RdfModelHelper.arraysEqual((Object[])this.getFileTypes(), (Object[])comp.getFileTypes()) && RdfModelHelper.arraysEqual(this.getFileContributors(), comp.getFileContributors()) && this.arraysEquivalent(this.getArtifactOf(), comp.getArtifactOf(), testRelationships) && this.arraysEquivalent(this.getFileDependencies(), comp.getFileDependencies(), testRelationships) && RdfModelHelper.stringsEquivalent(this.getNoticeText(), comp.getNoticeText());
    }

    protected Checksum[] cloneChecksum() {
        if (this.checksums == null) {
            return null;
        }
        Checksum[] retval = new Checksum[this.checksums.length];
        for (int i = 0; i < this.checksums.length; ++i) {
            retval[i] = this.checksums[i].clone();
        }
        return retval;
    }

    protected DoapProject[] cloneArtifactOf() {
        if (this.artifactOf == null) {
            return null;
        }
        DoapProject[] retval = new DoapProject[this.artifactOf.length];
        for (int i = 0; i < this.artifactOf.length; ++i) {
            retval[i] = this.artifactOf[i].clone();
        }
        return retval;
    }

    public SpdxFile[] cloneFileDependencies(Map<String, SpdxElement> clonedElementIds) {
        if (this.fileDependencies == null) {
            return null;
        }
        SpdxFile[] retval = new SpdxFile[this.fileDependencies.length];
        for (int i = 0; i < this.fileDependencies.length; ++i) {
            retval[i] = this.fileDependencies[i].clone((Map)clonedElementIds);
        }
        return retval;
    }

    @Override
    public SpdxFile clone(Map<String, SpdxElement> clonedElementIds) {
        SpdxElement retval;
        if (clonedElementIds.containsKey(this.getId())) {
            return (SpdxFile)clonedElementIds.get(this.getId());
        }
        try {
            retval = new SpdxFile(this.name, this.comment, this.cloneAnnotations(), null, this.cloneLicenseConcluded(), this.cloneLicenseInfosFromFiles(), this.copyrightText, this.licenseComments, this.fileTypes, this.cloneChecksum(), this.fileContributors, this.noticeText, this.cloneArtifactOf());
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error cloning file: ", (Throwable)e);
            retval = null;
        }
        clonedElementIds.put(this.getId(), retval);
        if (retval != null) {
            try {
                retval.setRelationships(this.cloneRelationships(clonedElementIds));
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Unexected error setting relationships during clone", (Throwable)e);
            }
            if (this.fileDependencies != null) {
                try {
                    ((SpdxFile)retval).setFileDependencies(this.cloneFileDependencies(clonedElementIds));
                }
                catch (InvalidSPDXAnalysisException e1) {
                    logger.warn("Error setting file dependencies on clone", (Throwable)e1);
                }
            }
        }
        return retval;
    }

    @Override
    public SpdxFile clone() {
        return this.clone((Map)Maps.newHashMap());
    }

    @Override
    public List<String> verify() {
        int i;
        DoapProject[] projects;
        List<String> retval = super.verify();
        String fileName = this.getName();
        if (fileName == null) {
            fileName = "UNKNOWN";
        }
        if (this.checksums == null || this.checksums.length == 0) {
            retval.add("Missing required checksum for file " + fileName);
        } else {
            for (int i2 = 0; i2 < this.checksums.length; ++i2) {
                List<String> verify = this.checksums[i2].verify();
                this.addNameToWarnings(verify);
                retval.addAll(verify);
            }
        }
        String sha1 = this.getSha1();
        if (sha1 == null || sha1.isEmpty()) {
            retval.add("Missing required SHA1 hashcode value for " + this.name);
        }
        if ((projects = this.getArtifactOf()) != null) {
            for (i = 0; i < projects.length; ++i) {
                retval.addAll(projects[i].verify());
            }
        }
        if (this.fileDependencies != null) {
            for (i = 0; i < this.fileDependencies.length; ++i) {
                List<String> verifyFileDependency = this.fileDependencies[i].verify();
                for (int j = 0; j < verifyFileDependency.size(); ++j) {
                    retval.add("Invalid file dependency for file named " + this.fileDependencies[i].getName() + ": " + verifyFileDependency.get(j));
                }
            }
        }
        return retval;
    }

    @Override
    public int compareTo(SpdxFile file) {
        int retval = this.getName().compareTo(file.getName());
        return retval;
    }

    @Deprecated
    public String getCopyright() {
        return this.getCopyrightText();
    }

    @Deprecated
    public void setCopyright(String copyright) {
        this.setCopyrightText(copyright);
    }

    @Deprecated
    public AnyLicenseInfo getConcludedLicenses() {
        return this.getLicenseConcluded();
    }

    @Deprecated
    public void setConcludedLicenses(AnyLicenseInfo concludedLicense) throws InvalidSPDXAnalysisException {
        this.setLicenseConcluded(concludedLicense);
    }

    @Deprecated
    public String[] getContributors() {
        return this.getFileContributors();
    }

    @Deprecated
    public void setContributors(String[] contributors) {
        this.setFileContributors(contributors);
    }

    @Deprecated
    public AnyLicenseInfo[] getSeenLicenses() {
        return this.getLicenseInfoFromFiles();
    }

    @Deprecated
    public void setSeenLicenses(AnyLicenseInfo[] seenLicenses) throws InvalidSPDXAnalysisException {
        this.setLicenseInfosFromFiles(seenLicenses);
    }

    static {
        ImmutableMap.Builder fileTypeToTagBuilder = ImmutableMap.builder();
        ImmutableMap.Builder tagToFileTypeBuilder = ImmutableMap.builder();
        fileTypeToTagBuilder.put((Object)FileType.fileType_application, (Object)"APPLICATION");
        tagToFileTypeBuilder.put((Object)"APPLICATION", (Object)FileType.fileType_application);
        fileTypeToTagBuilder.put((Object)FileType.fileType_archive, (Object)"ARCHIVE");
        tagToFileTypeBuilder.put((Object)"ARCHIVE", (Object)FileType.fileType_archive);
        fileTypeToTagBuilder.put((Object)FileType.fileType_audio, (Object)"AUDIO");
        tagToFileTypeBuilder.put((Object)"AUDIO", (Object)FileType.fileType_audio);
        fileTypeToTagBuilder.put((Object)FileType.fileType_binary, (Object)"BINARY");
        tagToFileTypeBuilder.put((Object)"BINARY", (Object)FileType.fileType_binary);
        fileTypeToTagBuilder.put((Object)FileType.fileType_documentation, (Object)"DOCUMENTATION");
        tagToFileTypeBuilder.put((Object)"DOCUMENTATION", (Object)FileType.fileType_documentation);
        fileTypeToTagBuilder.put((Object)FileType.fileType_image, (Object)"IMAGE");
        tagToFileTypeBuilder.put((Object)"IMAGE", (Object)FileType.fileType_image);
        fileTypeToTagBuilder.put((Object)FileType.fileType_other, (Object)"OTHER");
        tagToFileTypeBuilder.put((Object)"OTHER", (Object)FileType.fileType_other);
        fileTypeToTagBuilder.put((Object)FileType.fileType_source, (Object)"SOURCE");
        tagToFileTypeBuilder.put((Object)"SOURCE", (Object)FileType.fileType_source);
        fileTypeToTagBuilder.put((Object)FileType.fileType_spdx, (Object)"SPDX");
        tagToFileTypeBuilder.put((Object)"SPDX", (Object)FileType.fileType_spdx);
        fileTypeToTagBuilder.put((Object)FileType.fileType_text, (Object)"TEXT");
        tagToFileTypeBuilder.put((Object)"TEXT", (Object)FileType.fileType_text);
        fileTypeToTagBuilder.put((Object)FileType.fileType_video, (Object)"VIDEO");
        tagToFileTypeBuilder.put((Object)"VIDEO", (Object)FileType.fileType_video);
        FILE_TYPE_TO_TAG = fileTypeToTagBuilder.build();
        TAG_TO_FILE_TYPE = tagToFileTypeBuilder.build();
    }

    public static enum FileType {
        fileType_application,
        fileType_archive,
        fileType_audio,
        fileType_binary,
        fileType_documentation,
        fileType_image,
        fileType_other,
        fileType_source,
        fileType_spdx,
        fileType_text,
        fileType_video;


        public String getTag() {
            return FILE_TYPE_TO_TAG.get((Object)this);
        }

        public static FileType fromTag(String tag) {
            return TAG_TO_FILE_TYPE.get(tag);
        }
    }
}

