/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.model.IRdfModel;

public class OrLaterOperator
extends AnyLicenseInfo {
    private SimpleLicensingInfo license;

    public OrLaterOperator(IModelContainer modelContainer, Node licenseInfoNode) throws InvalidSPDXAnalysisException {
        super(modelContainer, licenseInfoNode);
        this.getPropertiesFromModel();
    }

    public OrLaterOperator(SimpleLicensingInfo license) {
        this.license = license;
    }

    public SimpleLicensingInfo getLicense() {
        if (this.resource != null && this.refreshOnGet) {
            try {
                this.populateModel();
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.warn("Error getting license from model, using stored value", (Throwable)e);
            }
        }
        return this.license;
    }

    public void setLicense(SimpleLicensingInfo license) throws InvalidSPDXAnalysisException {
        this.license = license;
        if (this.model != null && this.node != null) {
            Property licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
            this.model.removeAll(this.resource, licProperty, null);
            licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
            Resource licResource = license.createResource(this.modelContainer);
            this.resource.addProperty(licProperty, (RDFNode)licResource);
        }
    }

    @Override
    public String toString() {
        if (this.license == null) {
            return "UNDEFINED OR EXCEPTION";
        }
        return this.license.toString() + "+";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OrLaterOperator)) {
            return false;
        }
        OrLaterOperator comp = (OrLaterOperator)o;
        return !(comp.getLicense() == null ? this.getLicense() != null : !comp.getLicense().equals(this.getLicense()));
    }

    @Override
    public int hashCode() {
        int licHashCode = 0;
        if (this.license != null) {
            licHashCode = this.license.hashCode();
        }
        return licHashCode;
    }

    @Override
    public List<String> verify() {
        ArrayList retval = Lists.newArrayList();
        if (this.license == null) {
            retval.add("Missing required license for a License Or Later operator");
        } else {
            retval.addAll(this.license.verify());
        }
        return retval;
    }

    @Override
    public AnyLicenseInfo clone() {
        SimpleLicensingInfo clonedLicense = null;
        if (this.license != null) {
            clonedLicense = (SimpleLicensingInfo)this.license.clone();
        }
        return new OrLaterOperator(clonedLicense);
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (!(compare instanceof OrLaterOperator)) {
            return false;
        }
        return RdfModelHelper.equivalentConsideringNull(this.getLicense(), ((OrLaterOperator)compare).getLicense());
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        Property licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
        this.model.removeAll(this.resource, licProperty, null);
        licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
        Resource licResource = this.license.createResource(this.modelContainer);
        this.resource.addProperty(licProperty, (RDFNode)licResource);
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "member").asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            if (this.license != null) {
                throw new InvalidSPDXAnalysisException("More than one license for a license WITH expression");
            }
            AnyLicenseInfo anyLicense = LicenseInfoFactory.getLicenseInfoFromModel(this.modelContainer, t.getObject());
            if (!(anyLicense instanceof SimpleLicensingInfo)) {
                throw new InvalidSPDXAnalysisException("The license for a WITH expression must be of type SimpleLicensingInfo");
            }
            this.license = (SimpleLicensingInfo)anyLicense;
        }
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#OrLaterOperator");
    }
}

