/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spdx.compare.CompareTemplateOutputHandler;
import org.spdx.compare.LineColumn;
import org.spdx.compare.SpdxCompareException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ConjunctiveLicenseSet;
import org.spdx.rdfparser.license.DisjunctiveLicenseSet;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.License;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.LicenseParserException;
import org.spdx.rdfparser.license.LicenseSet;
import org.spdx.rdfparser.license.SpdxListedLicense;

public class LicenseCompareHelper {
    protected static final String TOKEN_SPLIT_REGEX = "(^|[^\\s\\.,?'();:\"/]+)((\\s|\\.|,|\\?|'|\"|\\(|\\)|;|:|/|$)+)";
    protected static final Pattern TOKEN_SPLIT_PATTERN = Pattern.compile("(^|[^\\s\\.,?'();:\"/]+)((\\s|\\.|,|\\?|'|\"|\\(|\\)|;|:|/|$)+)");
    protected static final ImmutableSet<String> PUNCTUATION = ImmutableSet.builder().add((Object)".").add((Object)",").add((Object)"?").add((Object)"\"").add((Object)"'").add((Object)"(").add((Object)")").add((Object)";").add((Object)":").add((Object)"/").build();
    protected static final ImmutableSet<String> SKIPPABLE_TOKENS = ImmutableSet.builder().add((Object)"//").add((Object)"/*").add((Object)"*/").add((Object)"/**").add((Object)"#").add((Object)"##").add((Object)"*").add((Object)"**").add((Object)"\"\"\"").add((Object)"/").add((Object)"=begin").add((Object)"=end").build();
    protected static final Map<String, String> NORMALIZE_TOKENS = Maps.newHashMap();
    static final String DASHES_REGEX = "[\\u2012\\u2013\\u2014\\u2015]";
    static final Pattern SPACE_PATTERN;
    static final Pattern PER_CENT_PATTERN;
    static final Pattern COPYRIGHT_HOLDER_PATTERN;
    static final Pattern COPYRIGHT_HOLDERS_PATTERN;
    static final Pattern COPYRIGHT_OWNERS_PATTERN;
    static final Pattern COPYRIGHT_OWNER_PATTERN;
    static final Pattern PER_CENT_PATTERN_LF;
    static final Pattern COPYRIGHT_HOLDERS_PATTERN_LF;
    static final Pattern COPYRIGHT_HOLDER_PATTERN_LF;
    static final Pattern COPYRIGHT_OWNERS_PATTERN_LF;
    static final Pattern COPYRIGHT_OWNER_PATTERN_LF;

    public static boolean isLicenseTextEquivalent(String licenseTextA, String licenseTextB) {
        if (licenseTextA == null) {
            return licenseTextB == null || licenseTextB.isEmpty();
        }
        if (licenseTextB == null) {
            return licenseTextA.isEmpty();
        }
        if (licenseTextA.equals(licenseTextB)) {
            return true;
        }
        HashMap<Integer, LineColumn> tokenToLocationA = new HashMap<Integer, LineColumn>();
        HashMap<Integer, LineColumn> tokenToLocationB = new HashMap<Integer, LineColumn>();
        String[] licenseATokens = LicenseCompareHelper.tokenizeLicenseText(licenseTextA, tokenToLocationA);
        String[] licenseBTokens = LicenseCompareHelper.tokenizeLicenseText(licenseTextB, tokenToLocationB);
        int bTokenCounter = 0;
        int aTokenCounter = 0;
        String nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
        String nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        while (nextAToken != null) {
            if (nextBToken == null) {
                while (nextAToken != null && LicenseCompareHelper.canSkip(nextAToken)) {
                    nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
                }
                if (nextAToken == null) continue;
                return false;
            }
            if (LicenseCompareHelper.tokensEquivalent(nextAToken, nextBToken)) {
                nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
                nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
                continue;
            }
            while (nextBToken != null && LicenseCompareHelper.canSkip(nextBToken)) {
                nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
            }
            while (nextAToken != null && LicenseCompareHelper.canSkip(nextAToken)) {
                nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
            }
            if (!LicenseCompareHelper.tokensEquivalent(nextAToken, nextBToken)) {
                return false;
            }
            nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
            nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        }
        while (nextBToken != null && LicenseCompareHelper.canSkip(nextBToken)) {
            nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        }
        return nextBToken == null;
    }

    static String normalizeText(String s) {
        return s.replaceAll("\u2018|\u2019|\u201b|\u201a|`", "'").replaceAll("http://", "https://").replaceAll("''", "\"").replaceAll("\u201c|\u201d|\u201f|\u201e", "\"").replaceAll("\\u00A0", " ").replaceAll("\u2014|\u2013", "-").replaceAll("\\u2028", "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String locateOriginalText(String fullLicenseText, int startToken, int endToken, Map<Integer, LineColumn> tokenToLocation, String[] tokens) {
        if (startToken > endToken) {
            return "";
        }
        LineColumn start = tokenToLocation.get(startToken);
        if (start == null) {
            return "";
        }
        LineColumn end = tokenToLocation.get(endToken);
        BufferedReader reader = null;
        try {
            int currentLine;
            reader = new BufferedReader(new StringReader(fullLicenseText));
            String line = reader.readLine();
            for (currentLine = 1; line != null && currentLine < start.getLine(); ++currentLine) {
                line = reader.readLine();
            }
            if (line == null) {
                String string = "";
                return string;
            }
            if (end == null) {
                StringBuilder sb = new StringBuilder(line.substring(start.getColumn(), line.length()));
                ++currentLine;
                line = reader.readLine();
                while (true) {
                    if (line == null) {
                        String string = sb.toString();
                        return string;
                    }
                    sb.append(line);
                    ++currentLine;
                    line = reader.readLine();
                }
            }
            if (end.getLine() == currentLine) {
                String sb = line.substring(start.getColumn(), end.getColumn() + end.getLen());
                return sb;
            }
            StringBuilder sb = new StringBuilder(line.substring(start.getColumn(), line.length()));
            ++currentLine;
            line = reader.readLine();
            while (line != null && currentLine < end.getLine()) {
                sb.append("\n");
                sb.append(line);
                ++currentLine;
                line = reader.readLine();
            }
            if (line != null && end.getColumn() + end.getLen() > 0) {
                sb.append("\n");
                sb.append(line.substring(0, end.getColumn() + end.getLen()));
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder(tokens[startToken]);
            int i = startToken + 1;
            while (true) {
                if (i > endToken) {
                    String string = sb.toString();
                    return string;
                }
                sb.append(' ');
                sb.append(tokens[i]);
                ++i;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] tokenizeLicenseText(String licenseText, Map<Integer, LineColumn> tokenToLocation) {
        String textToTokenize = LicenseCompareHelper.normalizeText(LicenseCompareHelper.replaceMultWord(LicenseCompareHelper.replaceSpace(licenseText))).toLowerCase();
        ArrayList<String> tokens = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(textToTokenize));
            int currentLine = 1;
            int currentToken = 0;
            String line = reader.readLine();
            while (line != null) {
                Matcher lineMatcher = TOKEN_SPLIT_PATTERN.matcher(line);
                while (lineMatcher.find()) {
                    String token = lineMatcher.group(1).trim();
                    if (!token.isEmpty()) {
                        tokens.add(token);
                        tokenToLocation.put(currentToken, new LineColumn(currentLine, lineMatcher.start(), token.length()));
                        ++currentToken;
                    }
                    String fullMatch = lineMatcher.group(0);
                    for (int i = lineMatcher.group(1).length(); i < fullMatch.length(); ++i) {
                        String possiblePunctuation = fullMatch.substring(i, i + 1);
                        if (!PUNCTUATION.contains((Object)possiblePunctuation)) continue;
                        tokens.add(possiblePunctuation);
                        tokenToLocation.put(currentToken, new LineColumn(currentLine, lineMatcher.start() + i, 1));
                        ++currentToken;
                    }
                }
                ++currentLine;
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            Matcher m = TOKEN_SPLIT_PATTERN.matcher(textToTokenize);
            while (m.find()) {
                String word = m.group(1).trim();
                String seperator = m.group(2).trim();
                tokens.add(word);
                if (!PUNCTUATION.contains((Object)seperator)) continue;
                tokens.add(seperator);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String getFirstLicenseToken(String text) {
        String textToTokenize = LicenseCompareHelper.normalizeText(LicenseCompareHelper.replaceMultWord(LicenseCompareHelper.replaceSpace(text))).toLowerCase();
        Matcher m = TOKEN_SPLIT_PATTERN.matcher(textToTokenize);
        while (m.find()) {
            if (m.group(1).trim().isEmpty()) continue;
            return m.group(1).trim();
        }
        return null;
    }

    public static boolean isSingleTokenString(String text) {
        if (text.contains("\n")) {
            return false;
        }
        Matcher m = TOKEN_SPLIT_PATTERN.matcher(text);
        boolean found = false;
        while (m.find()) {
            if (m.group(1).trim().isEmpty()) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return true;
    }

    private static String replaceSpace(String s) {
        Matcher m = SPACE_PATTERN.matcher(s);
        return m.replaceAll(" ");
    }

    private static String replaceMultWord(String s) {
        Matcher m = COPYRIGHT_HOLDERS_PATTERN.matcher(s);
        String retval = m.replaceAll("copyright-holders");
        m = COPYRIGHT_HOLDERS_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-holders\n");
        m = COPYRIGHT_OWNERS_PATTERN.matcher(retval);
        retval = m.replaceAll("copyright-owners");
        m = COPYRIGHT_OWNERS_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-owners\n");
        m = COPYRIGHT_HOLDER_PATTERN.matcher(retval);
        retval = m.replaceAll("copyright-holder");
        m = COPYRIGHT_HOLDER_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-holder\n");
        m = COPYRIGHT_OWNER_PATTERN.matcher(retval);
        retval = m.replaceAll("copyright-owner");
        m = COPYRIGHT_OWNER_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-owner\n");
        m = PER_CENT_PATTERN.matcher(retval);
        retval = m.replaceAll("percent");
        m = PER_CENT_PATTERN.matcher(retval);
        retval = m.replaceAll("percent\n");
        return retval;
    }

    static String getTokenAt(String[] tokens, int tokenIndex) {
        if (tokenIndex >= tokens.length) {
            return null;
        }
        return tokens[tokenIndex];
    }

    static boolean tokensEquivalent(String tokenA, String tokenB) {
        String ns2;
        String s2;
        if (tokenA == null) {
            return tokenB == null;
        }
        if (tokenB == null) {
            return false;
        }
        String s1 = tokenA.trim().toLowerCase().replaceAll(DASHES_REGEX, "-");
        if (s1.equals(s2 = tokenB.trim().toLowerCase().replaceAll(DASHES_REGEX, "-"))) {
            return true;
        }
        String ns1 = NORMALIZE_TOKENS.get(s1);
        if (ns1 == null) {
            ns1 = s1;
        }
        if ((ns2 = NORMALIZE_TOKENS.get(s2)) == null) {
            ns2 = s2;
        }
        return ns1.equals(ns2);
    }

    static boolean canSkip(String token) {
        if (token == null) {
            return false;
        }
        if (token.trim().isEmpty()) {
            return true;
        }
        return SKIPPABLE_TOKENS.contains((Object)token.trim().toLowerCase());
    }

    public static boolean isLicenseEqual(AnyLicenseInfo license1, AnyLicenseInfo license2, Map<String, String> xlationMap) throws SpdxCompareException {
        if (license1 instanceof ConjunctiveLicenseSet) {
            if (!(license2 instanceof ConjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual((ConjunctiveLicenseSet)license1, (ConjunctiveLicenseSet)license2, xlationMap);
        }
        if (license1 instanceof DisjunctiveLicenseSet) {
            if (!(license2 instanceof DisjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual((DisjunctiveLicenseSet)license1, (DisjunctiveLicenseSet)license2, xlationMap);
        }
        if (license1 instanceof ExtractedLicenseInfo) {
            if (!(license2 instanceof ExtractedLicenseInfo)) {
                return false;
            }
            String licenseid1 = ((ExtractedLicenseInfo)license1).getLicenseId();
            String licenseid2 = ((ExtractedLicenseInfo)license2).getLicenseId();
            String xlatedLicenseId = xlationMap.get(licenseid1);
            if (xlatedLicenseId == null) {
                return false;
            }
            return xlatedLicenseId.equals(licenseid2);
        }
        return license1.equals(license2);
    }

    private static boolean isLicenseSetsEqual(LicenseSet license1, LicenseSet license2, Map<String, String> xlationMap) throws SpdxCompareException {
        AnyLicenseInfo[] licenseInfos1 = license1.getMembers();
        AnyLicenseInfo[] licenseInfos2 = license2.getMembers();
        if (licenseInfos1 == null) {
            return licenseInfos2 == null;
        }
        if (licenseInfos2 == null) {
            return false;
        }
        if (licenseInfos1.length != licenseInfos2.length) {
            return false;
        }
        for (int i = 0; i < licenseInfos1.length; ++i) {
            boolean found = false;
            for (int j = 0; j < licenseInfos2.length; ++j) {
                if (!LicenseCompareHelper.isLicenseEqual(licenseInfos1[i], licenseInfos2[j], xlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextStandardLicense(License license, String compareText) throws SpdxCompareException {
        String licenseTemplate = license.getStandardLicenseTemplate();
        if (licenseTemplate == null || licenseTemplate.trim().isEmpty()) {
            licenseTemplate = license.getLicenseText();
        }
        CompareTemplateOutputHandler compareTemplateOutputHandler = null;
        try {
            compareTemplateOutputHandler = new CompareTemplateOutputHandler(compareText);
        }
        catch (IOException e1) {
            throw new SpdxCompareException("IO Error reading the compare text: " + e1.getMessage(), e1);
        }
        try {
            SpdxLicenseTemplateHelper.parseTemplate(licenseTemplate, compareTemplateOutputHandler);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during compare: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during compare: " + e.getMessage(), e);
        }
        return compareTemplateOutputHandler.getDifferences();
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextStandardException(LicenseException exception, String compareText) throws SpdxCompareException {
        String exceptionTemplate = exception.getLicenseExceptionTemplate();
        if (exceptionTemplate == null || exceptionTemplate.trim().isEmpty()) {
            exceptionTemplate = exception.getLicenseExceptionText();
        }
        CompareTemplateOutputHandler compareTemplateOutputHandler = null;
        try {
            compareTemplateOutputHandler = new CompareTemplateOutputHandler(compareText);
        }
        catch (IOException e1) {
            throw new SpdxCompareException("IO Error reading the compare text: " + e1.getMessage(), e1);
        }
        try {
            SpdxLicenseTemplateHelper.parseTemplate(exceptionTemplate, compareTemplateOutputHandler);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during compare: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during compare: " + e.getMessage(), e);
        }
        return compareTemplateOutputHandler.getDifferences();
    }

    public static String[] matchingStandardLicenseIds(String licenseText) throws InvalidSPDXAnalysisException, SpdxCompareException {
        String[] stdLicenseIds = LicenseInfoFactory.getSpdxListedLicenseIds();
        ArrayList matchingIds = Lists.newArrayList();
        for (String stdLicId : stdLicenseIds) {
            SpdxListedLicense license = LicenseInfoFactory.getListedLicenseById(stdLicId);
            if (LicenseCompareHelper.isTextStandardLicense(license, licenseText).isDifferenceFound()) continue;
            matchingIds.add(license.getLicenseId());
        }
        return matchingIds.toArray(new String[matchingIds.size()]);
    }

    static {
        NORMALIZE_TOKENS.put("acknowledgment", "acknowledgement");
        NORMALIZE_TOKENS.put("analogue", "analog");
        NORMALIZE_TOKENS.put("analyse", "analyze");
        NORMALIZE_TOKENS.put("artefact", "artifact");
        NORMALIZE_TOKENS.put("authorisation", "authorization");
        NORMALIZE_TOKENS.put("authorised", "authorized");
        NORMALIZE_TOKENS.put("calibre", "caliber");
        NORMALIZE_TOKENS.put("cancelled", "canceled");
        NORMALIZE_TOKENS.put("apitalisations", "apitalizations");
        NORMALIZE_TOKENS.put("catalogue", "catalog");
        NORMALIZE_TOKENS.put("categorise", "categorize");
        NORMALIZE_TOKENS.put("centre", "center");
        NORMALIZE_TOKENS.put("emphasised", "emphasized");
        NORMALIZE_TOKENS.put("favour", "favor");
        NORMALIZE_TOKENS.put("favourite", "favorite");
        NORMALIZE_TOKENS.put("fulfil", "fulfill");
        NORMALIZE_TOKENS.put("fulfilment", "fulfillment");
        NORMALIZE_TOKENS.put("initialise", "initialize");
        NORMALIZE_TOKENS.put("judgment", "judgement");
        NORMALIZE_TOKENS.put("labelling", "labeling");
        NORMALIZE_TOKENS.put("labour", "labor");
        NORMALIZE_TOKENS.put("licence", "license");
        NORMALIZE_TOKENS.put("maximise", "maximize");
        NORMALIZE_TOKENS.put("modelled", "modeled");
        NORMALIZE_TOKENS.put("modelling", "modeling");
        NORMALIZE_TOKENS.put("offence", "offense");
        NORMALIZE_TOKENS.put("optimise", "optimize");
        NORMALIZE_TOKENS.put("organisation", "organization");
        NORMALIZE_TOKENS.put("organise", "organize");
        NORMALIZE_TOKENS.put("practise", "practice");
        NORMALIZE_TOKENS.put("programme", "program");
        NORMALIZE_TOKENS.put("realise", "realize");
        NORMALIZE_TOKENS.put("recognise", "recognize");
        NORMALIZE_TOKENS.put("signalling", "signaling");
        NORMALIZE_TOKENS.put("utilisation", "utilization");
        NORMALIZE_TOKENS.put("whilst", "while");
        NORMALIZE_TOKENS.put("wilful", "wilfull");
        NORMALIZE_TOKENS.put("non-commercial", "noncommercial");
        NORMALIZE_TOKENS.put("copyright-owner", "copyright-holder");
        NORMALIZE_TOKENS.put("sublicense", "sub-license");
        NORMALIZE_TOKENS.put("non-infringement", "noninfringement");
        NORMALIZE_TOKENS.put("\u00a9", "(c)");
        NORMALIZE_TOKENS.put("copyright", "(c)");
        NORMALIZE_TOKENS.put("\"", "'");
        SPACE_PATTERN = Pattern.compile("[\\u202F\\u2007\\u2060]");
        PER_CENT_PATTERN = Pattern.compile("per cent", 2);
        COPYRIGHT_HOLDER_PATTERN = Pattern.compile("copyright holder", 2);
        COPYRIGHT_HOLDERS_PATTERN = Pattern.compile("copyright holders", 2);
        COPYRIGHT_OWNERS_PATTERN = Pattern.compile("copyright owners", 2);
        COPYRIGHT_OWNER_PATTERN = Pattern.compile("copyright owner", 2);
        PER_CENT_PATTERN_LF = Pattern.compile("per\\s*\\n+\\s*cent", 2);
        COPYRIGHT_HOLDERS_PATTERN_LF = Pattern.compile("copyright\\s*\\n+\\s*holders", 2);
        COPYRIGHT_HOLDER_PATTERN_LF = Pattern.compile("copyright\\s*\\n+\\s*holder", 2);
        COPYRIGHT_OWNERS_PATTERN_LF = Pattern.compile("copyright\\s*\\n+\\s*owners", 2);
        COPYRIGHT_OWNER_PATTERN_LF = Pattern.compile("copyright\\s*\\n+\\s*owner", 2);
    }
}

