/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.spdx.html.AnnotationContext;
import org.spdx.html.ElementContext;
import org.spdx.html.ProjectContext;
import org.spdx.html.RelationshipContext;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxSnippet;

public class FileContext {
    SpdxFile spdxFile = null;
    Exception error = null;
    private Map<String, String> spdxIdToUrl;
    private Map<String, List<SpdxSnippet>> fileIdToSnippets;

    public FileContext(SpdxFile SpdxFile2, Map<String, String> spdxIdToUrl, Map<String, List<SpdxSnippet>> fileIdToSnippets) {
        this.spdxFile = SpdxFile2;
        this.spdxIdToUrl = spdxIdToUrl;
        this.fileIdToSnippets = fileIdToSnippets;
    }

    public FileContext(InvalidSPDXAnalysisException e) {
        this.error = e;
    }

    public String fileName() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getName();
        }
        return null;
    }

    public String spdxId() {
        if (this.spdxFile == null) {
            return "Error getting SPDX file information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        return this.spdxFile.getId();
    }

    public List<String> checksums() {
        if (this.spdxFile == null) {
            ArrayList retval = Lists.newArrayList();
            retval.add("Error getting SPDX file information: " + (this.error != null ? this.error.getMessage() : "null"));
            return retval;
        }
        Checksum[] fileChecksums = this.spdxFile.getChecksums();
        if (fileChecksums == null || fileChecksums.length == 0) {
            return null;
        }
        ArrayList retval = Lists.newArrayList();
        for (int i = 0; i < fileChecksums.length; ++i) {
            retval.add((String)Checksum.CHECKSUM_ALGORITHM_TO_TAG.get((Object)fileChecksums[i].getAlgorithm()) + " " + fileChecksums[i].getValue());
        }
        Collections.sort(retval);
        return retval;
    }

    public List<String> fileType() {
        if (this.spdxFile == null && this.error != null) {
            ArrayList retval = Lists.newArrayList();
            retval.add("Error getting SPDX file information: " + this.error.getMessage());
            return retval;
        }
        if (this.spdxFile != null && this.spdxFile.getFileTypes() != null && this.spdxFile.getFileTypes().length > 0) {
            ArrayList retval = Lists.newArrayList();
            SpdxFile.FileType[] fileTypes = this.spdxFile.getFileTypes();
            for (int i = 0; i < fileTypes.length; ++i) {
                retval.add(fileTypes[i].getTag());
            }
            Collections.sort(retval);
            return retval;
        }
        return null;
    }

    public String checksum() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getSha1();
        }
        return null;
    }

    public String licenseConcluded() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getLicenseConcluded().toString();
        }
        return null;
    }

    public String licenseComments() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getLicenseComments();
        }
        return null;
    }

    public List<String> licenseInfoInFile() {
        ArrayList retval = Lists.newArrayList();
        if (this.spdxFile == null && this.error != null) {
            retval.add("Error getting SPDX file information: " + this.error.getMessage());
        }
        if (this.spdxFile != null) {
            AnyLicenseInfo[] licenseInfos = this.spdxFile.getLicenseInfoFromFiles();
            for (int i = 0; i < licenseInfos.length; ++i) {
                retval.add(licenseInfos[i].toString());
            }
        }
        return retval;
    }

    public String copyrightText() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getCopyrightText();
        }
        return null;
    }

    public List<ProjectContext> artifactOf() {
        DoapProject[] projects;
        ArrayList retval = Lists.newArrayList();
        if (this.spdxFile == null && this.error != null) {
            retval.add(new ProjectContext(this.error));
        }
        if (this.spdxFile != null && (projects = this.spdxFile.getArtifactOf()) != null) {
            for (int i = 0; i < projects.length; ++i) {
                retval.add(new ProjectContext(projects[i]));
            }
        }
        return retval;
    }

    public String comment() {
        if (this.spdxFile != null) {
            return this.spdxFile.getComment();
        }
        return null;
    }

    public String noticeText() {
        if (this.spdxFile != null) {
            return this.spdxFile.getNoticeText();
        }
        return null;
    }

    public List<String> contributors() {
        if (this.spdxFile == null || this.spdxFile.getFileContributors() == null) {
            return null;
        }
        return Arrays.asList(this.spdxFile.getFileContributors());
    }

    public List<String> attributionText() {
        if (this.spdxFile == null || this.spdxFile.getAttributionText() == null) {
            return null;
        }
        return Arrays.asList(this.spdxFile.getAttributionText());
    }

    public List<String> fileDependencies() {
        if (this.spdxFile == null || this.spdxFile.getFileContributors() == null) {
            return null;
        }
        ArrayList retval = Lists.newArrayList();
        SpdxFile[] dep = this.spdxFile.getFileDependencies();
        for (int i = 0; i < dep.length; ++i) {
            retval.add(dep[i].getName());
        }
        return retval;
    }

    public List<RelationshipContext> fileRelationships() {
        Object[] relationships;
        ArrayList retval = Lists.newArrayList();
        if (this.spdxFile != null && (relationships = this.spdxFile.getRelationships()) != null) {
            Arrays.sort(relationships);
            for (Object relationship : relationships) {
                retval.add(new RelationshipContext((Relationship)relationship, this.spdxIdToUrl));
            }
        }
        return retval;
    }

    public List<AnnotationContext> fileAnnotations() {
        Object[] annotations;
        ArrayList retval = Lists.newArrayList();
        if (this.spdxFile != null && (annotations = this.spdxFile.getAnnotations()) != null) {
            Arrays.sort(annotations);
            for (Object annotation : annotations) {
                retval.add(new AnnotationContext((Annotation)annotation));
            }
        }
        return retval;
    }

    public List<ElementContext> fileSnippets() {
        List<SpdxSnippet> snippets;
        ArrayList retval = Lists.newArrayList();
        if (this.spdxFile != null && (snippets = this.fileIdToSnippets.get(this.spdxFile.getId())) != null) {
            for (SpdxSnippet snippet : snippets) {
                retval.add(new ElementContext(snippet, this.spdxIdToUrl));
            }
        }
        return retval;
    }
}

