/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import org.apache.jena.graph.Node;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.LicenseException;

public class ListedLicenseException
extends LicenseException {
    private String deprecatedVersion = null;
    private String exceptionTextHtml = null;

    public ListedLicenseException(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.deprecatedVersion = null;
        this.exceptionTextHtml = null;
    }

    public ListedLicenseException(String licenseExceptionId, String name, String licenseExceptionText, String[] seeAlso, String comment) {
        super(licenseExceptionId, name, licenseExceptionText, seeAlso, comment);
    }

    public ListedLicenseException(String licenseExceptionId, String name, String licenseExceptionText, String licenseExceptionTemplate, String[] seeAlso, String comment, String exceptionTextHtml, boolean isDeprecated, String deprecatedVersion) {
        super(licenseExceptionId, name, licenseExceptionText, licenseExceptionTemplate, seeAlso, comment);
        this.exceptionTextHtml = exceptionTextHtml;
        super.setDeprecated(isDeprecated);
        this.deprecatedVersion = deprecatedVersion;
    }

    public ListedLicenseException(String licenseExceptionId, String name, String licenseExceptionText, String licenseExceptionTemplate, String[] seeAlso, String comment) {
        this(licenseExceptionId, name, licenseExceptionText, licenseExceptionTemplate, seeAlso, comment, null, false, null);
    }

    public ListedLicenseException(String licenseExceptionId, String name, String licenseExceptionText) {
        this(licenseExceptionId, name, licenseExceptionText, null, new String[0], null);
    }

    public ListedLicenseException(String exceptionId) {
        super(exceptionId);
        this.deprecatedVersion = null;
        this.exceptionTextHtml = null;
    }

    public String getDeprecatedVersion() {
        return this.deprecatedVersion;
    }

    public void setDeprecatedVersion(String deprecatedVersion) {
        this.deprecatedVersion = deprecatedVersion;
    }

    public String getExceptionTextHtml() throws InvalidLicenseTemplateException {
        if (this.exceptionTextHtml == null) {
            String templateText = this.getLicenseExceptionTemplate();
            if (templateText != null && !templateText.trim().isEmpty()) {
                try {
                    this.exceptionTextHtml = SpdxLicenseTemplateHelper.templateTextToHtml(templateText);
                }
                catch (LicenseTemplateRuleException ex) {
                    throw new InvalidLicenseTemplateException("Invalid license rule found in exception text for exception " + this.getName() + ":" + ex.getMessage());
                }
            } else {
                this.exceptionTextHtml = SpdxLicenseTemplateHelper.formatEscapeHTML(this.getLicenseExceptionText());
            }
        }
        return this.exceptionTextHtml;
    }

    public void setExceptionTextHtml(String exceptionTextHtml) {
        this.exceptionTextHtml = exceptionTextHtml;
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return this.createListedExceptionUri(this.getLicenseExceptionId());
    }

    private String createListedExceptionUri(String id) {
        return "http://spdx.org/licenses/" + id;
    }

    @Override
    public LicenseException clone() {
        ListedLicenseException retval = new ListedLicenseException(this.getLicenseExceptionId(), this.getName(), this.getLicenseExceptionText(), this.getLicenseExceptionTemplate(), this.getSeeAlso(), this.getComment());
        retval.setDeprecated(this.isDeprecated());
        retval.setExample(this.getExample());
        retval.setExceptionTextHtml(this.exceptionTextHtml);
        return retval;
    }
}

