/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxElementFactory;
import org.spdx.rdfparser.model.pointer.PointerFactory;
import org.spdx.rdfparser.model.pointer.SinglePointer;
import org.spdx.rdfparser.model.pointer.StartEndPointer;
import org.spdx.rdfparser.referencetype.ReferenceType;

public abstract class RdfModelObject
implements IRdfModel,
Cloneable {
    static final Map<String, String> PRE_DEFINED_VALUE_URI = Maps.newHashMap();
    static final Map<String, String> PRE_DEFINED_URI_VALUE = Maps.newHashMap();
    protected Model model;
    protected Resource resource;
    protected Node node;
    protected IModelContainer modelContainer;
    static RdfModelObject rdfModelObject;
    protected boolean refreshOnGet = true;

    public RdfModelObject(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        this.modelContainer = modelContainer;
        this.model = modelContainer.getModel();
        this.node = node;
        this.refreshOnGet = modelContainer.addCheckNodeObject(node, this);
        if (node.isBlank()) {
            this.resource = this.model.createResource(new AnonId(node.getBlankNodeId()));
        } else if (node.isURI()) {
            this.resource = this.model.createResource(node.getURI());
        } else {
            throw new InvalidSPDXAnalysisException("Can not have an model node as a literal");
        }
    }

    public RdfModelObject() {
    }

    @Override
    public Resource createResource(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return this.createResource(modelContainer, true);
    }

    public Resource createResource(IModelContainer modelContainer, boolean updateModel) throws InvalidSPDXAnalysisException {
        if (this.modelContainer != null && this.modelContainer.equals(modelContainer) && this.resource != null && (!this.resource.isURIResource() || this.resource.getURI().equals(this.getUri(modelContainer)))) {
            return this.resource;
        }
        String uri = this.getUri(modelContainer);
        Resource duplicate = this.findDuplicateResource(modelContainer, uri);
        this.modelContainer = modelContainer;
        this.model = modelContainer.getModel();
        this.resource = modelContainer.createResource(duplicate, uri, this.getType(this.model), this);
        this.node = this.resource.asNode();
        if (duplicate == null || updateModel) {
            this.populateModel();
        } else {
            this.getPropertiesFromModel();
        }
        return this.resource;
    }

    public abstract void getPropertiesFromModel() throws InvalidSPDXAnalysisException;

    public Resource findDuplicateResource(IModelContainer modelContainer, String uri) throws InvalidSPDXAnalysisException {
        return RdfModelHelper.findDuplicateResource(modelContainer, uri);
    }

    public abstract String getUri(IModelContainer var1) throws InvalidSPDXAnalysisException;

    public abstract Resource getType(Model var1);

    public abstract void populateModel() throws InvalidSPDXAnalysisException;

    protected boolean resourcesEqual(Resource r1, Resource r2) {
        if (r1 == null) {
            return r2 == null;
        }
        if (r2 == null) {
            return false;
        }
        if (r1.isAnon()) {
            if (!r2.isAnon()) {
                return false;
            }
            return r1.getId().equals((Object)r2.getId());
        }
        if (!r2.isURIResource()) {
            return false;
        }
        return r1.getURI().equals(r2.getURI());
    }

    public boolean equals(Object o) {
        if (!(o instanceof RdfModelObject)) {
            return false;
        }
        RdfModelObject comp = (RdfModelObject)o;
        if (comp.resource != null || this.resource != null) {
            return this.resourcesEqual(comp.resource, this.resource);
        }
        return super.equals(o);
    }

    public int hashCode() {
        if (this.resource != null) {
            return this.resource.hashCode() ^ this.model.hashCode();
        }
        return super.hashCode();
    }

    protected SpdxElement[] findMultipleElementPropertyValues(String namespace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return null;
        }
        Node p = this.model.getProperty(namespace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        ArrayList retval = Lists.newArrayList();
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            retval.add(SpdxElementFactory.createElementFromModel(this.modelContainer, t.getObject()));
        }
        return retval.toArray(new SpdxElement[retval.size()]);
    }

    protected SpdxElement findElementPropertyValue(String namespace, String propertyName) throws InvalidSPDXAnalysisException {
        SpdxElement[] elements = this.findMultipleElementPropertyValues(namespace, propertyName);
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public String findSinglePropertyValue(String namespace, String propertyName) {
        if (this.model == null || this.node == null) {
            return null;
        }
        Statement stmt = this.resource.getProperty((Property)new PropertyImpl(namespace, propertyName));
        if (stmt == null) {
            return null;
        }
        if (stmt.getObject().isLiteral()) {
            return stmt.getObject().asLiteral().getString();
        }
        if (stmt.getObject().isResource()) {
            return PRE_DEFINED_URI_VALUE.get(stmt.getObject().asResource().getURI());
        }
        return stmt.getObject().toString();
    }

    public Integer findIntPropertyValue(String namespace, String propertyName) {
        if (this.model == null || this.node == null) {
            return null;
        }
        Node p = this.model.getProperty(namespace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            if (!t.getObject().isLiteral()) continue;
            Object retval = t.getObject().getLiteralValue();
            if (retval instanceof Integer) {
                return (Integer)retval;
            }
            if (!(retval instanceof String)) continue;
            try {
                return Integer.parseInt((String)retval);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    protected void setPropertyValue(String nameSpace, String propertyName, Integer value) {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (value != null) {
                this.resource.addProperty(p, Integer.toString(value));
            }
        }
    }

    public String[] findMultiplePropertyValues(String namespace, String propertyName) {
        if (this.model == null || this.node == null) {
            return null;
        }
        ArrayList retval = Lists.newArrayList();
        Node p = this.model.getProperty(namespace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            if (t.getObject().isURI() && PRE_DEFINED_URI_VALUE.containsKey(t.getObject().getURI())) {
                retval.add(PRE_DEFINED_URI_VALUE.get(t.getObject().getURI()));
                continue;
            }
            retval.add(t.getObject().toString(false));
        }
        return retval.toArray(new String[retval.size()]);
    }

    protected void setPropertyValue(String nameSpace, String propertyName, String[] values) {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) continue;
                    String valueUri = PRE_DEFINED_VALUE_URI.get(values[i]);
                    if (valueUri != null) {
                        Resource valueResource = this.model.createResource(valueUri);
                        this.resource.addProperty(p, (RDFNode)valueResource);
                        continue;
                    }
                    this.resource.addLiteral(p, (Object)values[i]);
                }
            }
        }
    }

    protected void setPropertyValue(String nameSpace, String propertyName, boolean value) {
        if (value) {
            this.setPropertyValue(nameSpace, propertyName, "true");
        } else {
            this.setPropertyValue(nameSpace, propertyName, "false");
        }
    }

    protected void setPropertyValue(String nameSpace, String propertyName, SpdxElement[] elements, boolean updateModel) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (elements != null) {
                for (int i = 0; i < elements.length; ++i) {
                    if (elements[i] == null) continue;
                    this.resource.addProperty(p, (RDFNode)elements[i].createResource(this.modelContainer, updateModel));
                }
            }
        }
    }

    protected void setPropertyValue(String nameSpace, String propertyName, SpdxElement element, boolean updateModel) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (element != null) {
                this.resource.addProperty(p, (RDFNode)element.createResource(this.modelContainer, updateModel));
            }
        }
    }

    protected void addPropertyValue(String nameSpace, String propertyName, SpdxElement element, boolean updateModel) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            if (element != null) {
                this.resource.addProperty(p, (RDFNode)element.createResource(this.modelContainer, updateModel));
            }
        }
    }

    protected void addPropertyValue(String nameSpace, String propertyName, SpdxElement element) throws InvalidSPDXAnalysisException {
        this.addPropertyValue(nameSpace, propertyName, element, true);
    }

    protected void setPropertyValue(String nameSpace, String propertyName, SpdxElement element) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(nameSpace, propertyName, element, true);
    }

    protected void setPropertyValue(String nameSpace, String propertyName, SpdxElement[] element) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(nameSpace, propertyName, element, true);
    }

    protected void setPropertyValues(String nameSpace, String propertyName, Annotation[] annotations) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (annotations != null) {
                for (int i = 0; i < annotations.length; ++i) {
                    this.resource.addProperty(p, (RDFNode)annotations[i].createResource(this.modelContainer));
                }
            }
        }
    }

    protected void addPropertyValue(String nameSpace, String propertyName, Annotation annotation) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            if (annotation != null) {
                this.resource.addProperty(p, (RDFNode)annotation.createResource(this.modelContainer));
            }
        }
    }

    protected void addPropertyValue(String nameSpace, String propertyName, ExternalRef externalRef) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            if (externalRef != null) {
                this.resource.addProperty(p, (RDFNode)externalRef.createResource(this.modelContainer));
            }
        }
    }

    protected Annotation[] findAnnotationPropertyValues(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return null;
        }
        ArrayList retval = Lists.newArrayList();
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            retval.add(new Annotation(this.modelContainer, t.getObject()));
        }
        return retval.toArray(new Annotation[retval.size()]);
    }

    protected Relationship[] findRelationshipPropertyValues(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return null;
        }
        ArrayList retval = Lists.newArrayList();
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            retval.add(new Relationship(this.modelContainer, t.getObject()));
        }
        return retval.toArray(new Relationship[retval.size()]);
    }

    protected StartEndPointer[] findStartEndPointerPropertyValues(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return null;
        }
        ArrayList retval = Lists.newArrayList();
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            retval.add(new StartEndPointer(this.modelContainer, t.getObject()));
        }
        return retval.toArray(new StartEndPointer[retval.size()]);
    }

    protected void setPropertyValue(String nameSpace, String propertyName, StartEndPointer[] values) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.resource.addProperty(p, (RDFNode)values[i].createResource(this.modelContainer));
                }
            }
        }
    }

    protected void setPropertyValue(String nameSpace, String propertyName, String value) {
        this.setPropertyValue(nameSpace, propertyName, new String[]{value});
    }

    protected void removePropertyValue(String nameSpace, String propertyName) {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
        }
    }

    protected void setPropertyValues(String nameSpace, String propertyName, Relationship[] relationships) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (relationships != null) {
                for (int i = 0; i < relationships.length; ++i) {
                    this.resource.addProperty(p, (RDFNode)relationships[i].createResource(this.modelContainer));
                }
            }
        }
    }

    protected void addPropertyValue(String nameSpace, String propertyName, Relationship relationship) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            if (relationship != null) {
                this.resource.addProperty(p, (RDFNode)relationship.createResource(this.modelContainer));
            }
        }
    }

    public void setPropertyValues(String nameSpace, String propertyName, AnyLicenseInfo[] licenses) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (licenses != null) {
                for (int i = 0; i < licenses.length; ++i) {
                    if (licenses[i] == null) continue;
                    this.resource.addProperty(p, (RDFNode)licenses[i].createResource(this.modelContainer));
                }
            }
        }
    }

    public void addPropertyValue(String nameSpace, String propertyName, AnyLicenseInfo license) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null && license != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.resource.addProperty(p, (RDFNode)license.createResource(this.modelContainer));
        }
    }

    protected void setPropertyValue(String nameSpace, String propertyName, AnyLicenseInfo license) throws InvalidSPDXAnalysisException {
        this.setPropertyValues(nameSpace, propertyName, new AnyLicenseInfo[]{license});
    }

    public AnyLicenseInfo[] findAnyLicenseInfoPropertyValues(String namespace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return new AnyLicenseInfo[0];
        }
        ArrayList retval = Lists.newArrayList();
        Node p = this.model.getProperty(namespace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            retval.add(LicenseInfoFactory.getLicenseInfoFromModel(this.modelContainer, t.getObject()));
        }
        return retval.toArray(new AnyLicenseInfo[retval.size()]);
    }

    public AnyLicenseInfo findAnyLicenseInfoPropertyValue(String namespace, String propertyName) throws InvalidSPDXAnalysisException {
        AnyLicenseInfo[] licenses = this.findAnyLicenseInfoPropertyValues(namespace, propertyName);
        if (licenses == null || licenses.length == 0) {
            return null;
        }
        return licenses[0];
    }

    protected Checksum[] findMultipleChecksumPropertyValues(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return new Checksum[0];
        }
        ArrayList retval = Lists.newArrayList();
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            retval.add(new Checksum(this.modelContainer, t.getObject()));
        }
        return retval.toArray(new Checksum[retval.size()]);
    }

    protected Checksum findChecksumPropertyValue(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        Checksum[] checksums = this.findMultipleChecksumPropertyValues(nameSpace, propertyName);
        if (checksums == null || checksums.length == 0) {
            return null;
        }
        return checksums[0];
    }

    protected void addPropertyValue(String nameSpace, String propertyName, Checksum checksumValue) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            if (checksumValue != null) {
                this.resource.addProperty(p, (RDFNode)checksumValue.createResource(this.modelContainer));
            }
        }
    }

    protected void setPropertyValues(String nameSpace, String propertyName, Checksum[] checksumValues) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (checksumValues != null) {
                for (int i = 0; i < checksumValues.length; ++i) {
                    if (checksumValues[i] == null) continue;
                    this.resource.addProperty(p, (RDFNode)checksumValues[i].createResource(this.modelContainer));
                }
            }
        }
    }

    protected void setPropertyValue(String nameSpace, String propertyName, ReferenceType referenceType) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (referenceType != null) {
                this.resource.addProperty(p, (RDFNode)referenceType.createResource(this.modelContainer));
            }
        }
    }

    protected ReferenceType findReferenceTypePropertyValue(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return null;
        }
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        if (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            return new ReferenceType(this.modelContainer, t.getObject());
        }
        return null;
    }

    protected void setPropertyValue(String nameSpace, String propertyName, Checksum checksumValue) throws InvalidSPDXAnalysisException {
        if (checksumValue == null) {
            this.setPropertyValues(nameSpace, propertyName, new Checksum[0]);
        } else {
            this.setPropertyValues(nameSpace, propertyName, new Checksum[]{checksumValue});
        }
    }

    protected DoapProject[] findMultipleDoapPropertyValues(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return new DoapProject[0];
        }
        ArrayList retval = Lists.newArrayList();
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            retval.add(new DoapProject(this.modelContainer, t.getObject()));
        }
        return retval.toArray(new DoapProject[retval.size()]);
    }

    protected void setPropertyValue(String nameSpace, String propertyName, DoapProject[] doapProjectValues) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (doapProjectValues != null) {
                for (int i = 0; i < doapProjectValues.length; ++i) {
                    this.resource.addProperty(p, (RDFNode)doapProjectValues[i].createResource(this.modelContainer));
                }
            }
        }
    }

    protected String findUriPropertyValue(String namespace, String propertyName) {
        String[] values = this.findUriPropertyValues(namespace, propertyName);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    protected String[] findUriPropertyValues(String namespace, String propertyName) {
        if (this.model == null || this.node == null) {
            return new String[0];
        }
        Node p = this.model.getProperty(namespace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        ArrayList retval = Lists.newArrayList();
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            if (!t.getObject().isURI()) continue;
            retval.add(this.model.expandPrefix(t.getObject().getURI()));
        }
        return retval.toArray(new String[retval.size()]);
    }

    protected void setPropertyUriValues(String nameSpace, String propertyName, String[] uris) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (uris != null) {
                for (int i = 0; i < uris.length; ++i) {
                    if (uris[i] == null) continue;
                    Resource uriResource = this.model.createResource(uris[i]);
                    this.resource.addProperty(p, (RDFNode)uriResource);
                }
            }
        }
    }

    protected void addPropertyUriValue(String nameSpace, String propertyName, String uri) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            if (uri != null) {
                Resource uriResource = this.model.createResource(uri);
                this.resource.addProperty(p, (RDFNode)uriResource);
            }
        }
    }

    protected void setPropertyUriValue(String nameSpace, String propertyName, String uri) throws InvalidSPDXAnalysisException {
        this.setPropertyUriValues(nameSpace, propertyName, new String[]{uri});
    }

    protected SPDXCreatorInformation findCreationInfoPropertyValue(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return null;
        }
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        if (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            return new SPDXCreatorInformation(this.model, t.getObject());
        }
        return null;
    }

    protected void setPropertyValue(String nameSpace, String propertyName, SPDXCreatorInformation creatorInfo) {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (creatorInfo != null) {
                this.resource.addProperty(p, (RDFNode)creatorInfo.createResource(this.model));
            }
        }
    }

    protected SinglePointer findSinglePointerPropertyValue(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return null;
        }
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        if (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            return PointerFactory.getSinglePointerFromModel(this.modelContainer, t.getObject());
        }
        return null;
    }

    protected void setPropertyValue(String nameSpace, String propertyName, SinglePointer singlePointer) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (singlePointer != null) {
                this.resource.addProperty(p, (RDFNode)singlePointer.createResource(this.modelContainer));
            }
        }
    }

    public ExternalDocumentRef[] findExternalDocRefPropertyValues(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        return RdfModelObject.findExternalDocRefPropertyValues(nameSpace, propertyName, this.modelContainer, this.node);
    }

    public static ExternalDocumentRef[] findExternalDocRefPropertyValues(String nameSpace, String propertyName, IModelContainer extDocModelContainer, Node nodeContainingExternalRefs) throws InvalidSPDXAnalysisException {
        if (extDocModelContainer == null || nodeContainingExternalRefs == null) {
            return new ExternalDocumentRef[0];
        }
        Model model = extDocModelContainer.getModel();
        ArrayList retval = Lists.newArrayList();
        Node p = model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)nodeContainingExternalRefs, (Node)p, null);
        ExtendedIterator tripleIter = model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            retval.add(new ExternalDocumentRef(extDocModelContainer, t.getObject()));
        }
        return retval.toArray(new ExternalDocumentRef[retval.size()]);
    }

    public void setPropertyValues(String nameSpace, String propertyName, ExternalDocumentRef[] externalDocRefs) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (externalDocRefs != null) {
                for (int i = 0; i < externalDocRefs.length; ++i) {
                    this.resource.addProperty(p, (RDFNode)externalDocRefs[i].createResource(this.modelContainer));
                }
            }
        }
    }

    protected void setPropertyValues(String nameSpace, String propertyName, SPDXReview[] reviewers) {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (reviewers != null) {
                for (int i = 0; i < reviewers.length; ++i) {
                    this.resource.addProperty(p, (RDFNode)reviewers[i].createResource(this.model));
                }
            }
        }
    }

    protected SPDXReview[] findReviewPropertyValues(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return new SPDXReview[0];
        }
        ArrayList retval = Lists.newArrayList();
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            retval.add(new SPDXReview(this.model, t.getObject()));
        }
        return retval.toArray(new SPDXReview[retval.size()]);
    }

    protected SpdxPackageVerificationCode findVerificationCodePropertyValue(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return null;
        }
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        if (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            return new SpdxPackageVerificationCode(this.model, t.getObject());
        }
        return null;
    }

    protected void setPropertyValue(String nameSpace, String propertyName, SpdxPackageVerificationCode verificationCode) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (verificationCode != null) {
                this.resource.addProperty(p, (RDFNode)verificationCode.createResource(this.model));
            }
        }
    }

    protected ExternalRef[] findExternalRefPropertyValues(String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        if (this.model == null || this.node == null) {
            return null;
        }
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        ArrayList retval = Lists.newArrayList();
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            retval.add(new ExternalRef(this.modelContainer, t.getObject()));
        }
        return retval.toArray(new ExternalRef[retval.size()]);
    }

    protected void setPropertyValue(String nameSpace, String propertyName, ExternalRef[] externalRefs) throws InvalidSPDXAnalysisException {
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty(nameSpace, propertyName);
            this.model.removeAll(this.resource, p, null);
            if (externalRefs != null) {
                for (int i = 0; i < externalRefs.length; ++i) {
                    this.resource.addProperty(p, (RDFNode)externalRefs[i].createResource(this.modelContainer));
                }
            }
        }
    }

    public boolean arraysEquivalent(IRdfModel[] array1, IRdfModel[] array2) {
        return RdfModelHelper.arraysEquivalent(array1, array2);
    }

    public boolean equivalentConsideringNull(IRdfModel o1, IRdfModel o2) {
        if (o1 == o2) {
            return true;
        }
        return RdfModelHelper.equivalentConsideringNull(o1, o2);
    }

    @Override
    public void setMultipleObjectsForSameNode() {
        this.refreshOnGet = true;
    }

    @Override
    public void setSingleObjectForSameNode() {
        this.refreshOnGet = false;
    }

    public boolean isRefreshOnGet() {
        return this.refreshOnGet;
    }

    public Node getNode() {
        return this.node;
    }

    static {
        PRE_DEFINED_VALUE_URI.put("NOASSERTION", "http://spdx.org/rdf/terms#noassertion");
        PRE_DEFINED_URI_VALUE.put("http://spdx.org/rdf/terms#noassertion", "NOASSERTION");
        PRE_DEFINED_VALUE_URI.put("NONE", "http://spdx.org/rdf/terms#none");
        PRE_DEFINED_URI_VALUE.put("http://spdx.org/rdf/terms#none", "NONE");
    }
}

