/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model.pointer;

import com.google.common.base.Objects;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.pointer.SinglePointer;

public class LineCharPointer
extends SinglePointer {
    private Integer lineNumber;

    public LineCharPointer(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getMyPropertiesFromModel();
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        super.getPropertiesFromModel();
        this.getMyPropertiesFromModel();
    }

    private void getMyPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.lineNumber = this.findIntPropertyValue("http://www.w3.org/2009/pointers#", "lineNumber");
    }

    public LineCharPointer(SpdxElement reference, int lineNumber) {
        super(reference);
        this.lineNumber = lineNumber;
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://www.w3.org/2009/pointers#LineCharPointer");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        super.populateModel();
        this.setPropertyValue("http://www.w3.org/2009/pointers#", "lineNumber", this.lineNumber);
    }

    public Integer getLineNumber() {
        if (this.resource != null && this.refreshOnGet) {
            this.lineNumber = this.findIntPropertyValue("http://www.w3.org/2009/pointers#", "lineNumber");
        }
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
        this.setPropertyValue("http://www.w3.org/2009/pointers#", "lineNumber", this.lineNumber);
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        if (!super.equivalent(o)) {
            return false;
        }
        if (!(o instanceof LineCharPointer)) {
            return false;
        }
        LineCharPointer comp = (LineCharPointer)o;
        return Objects.equal((Object)this.getLineNumber(), (Object)comp.getLineNumber());
    }

    @Override
    public List<String> verify() {
        List<String> retval = super.verify();
        if (this.lineNumber == null) {
            retval.add("Missing line number value");
        } else if (this.lineNumber < 0) {
            retval.add("Line number most not be negative for a line offset pointer: " + this.lineNumber.toString());
        }
        return retval;
    }

    @Override
    public LineCharPointer clone() {
        SpdxElement newReference = null;
        if (this.reference != null) {
            newReference = this.reference.clone();
        }
        return new LineCharPointer(newReference, this.lineNumber);
    }

    @Override
    public int compareTo(SinglePointer o) {
        if (o == null) {
            return 1;
        }
        int retval = this.compareReferences(o);
        if (retval != 0) {
            return retval;
        }
        if (!(o instanceof LineCharPointer)) {
            return 1;
        }
        Integer compLine = ((LineCharPointer)o).getLineNumber();
        if (this.lineNumber == null) {
            return -1;
        }
        return this.lineNumber.compareTo(compLine);
    }

    public String toString() {
        if (this.lineNumber != null) {
            return "line number " + this.lineNumber.toString();
        }
        return "Unknown line number";
    }
}

