/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.spdx.html.AnnotationContext;
import org.spdx.html.ElementContext;
import org.spdx.html.ExternalRefContext;
import org.spdx.html.RelationshipContext;
import org.spdx.html.VerificationCodeContext;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;

public class PackageContext {
    private SpdxPackage pkg = null;
    private Map<String, String> spdxIdToUrl;

    public PackageContext(SpdxPackage pkg, Map<String, String> spdxIdToUrl) throws InvalidSPDXAnalysisException {
        this.pkg = pkg;
        this.spdxIdToUrl = spdxIdToUrl;
    }

    public String name() {
        if (this.pkg != null) {
            return this.pkg.getName();
        }
        return null;
    }

    public String versionInfo() {
        if (this.pkg != null) {
            return this.pkg.getVersionInfo();
        }
        return null;
    }

    public String downloadLocation() {
        if (this.pkg != null) {
            return this.pkg.getDownloadLocation();
        }
        return null;
    }

    public String summary() {
        if (this.pkg != null) {
            return this.pkg.getSummary();
        }
        return null;
    }

    public List<String> attributionText() {
        if (this.pkg == null || this.pkg.getAttributionText() == null) {
            return null;
        }
        return Arrays.asList(this.pkg.getAttributionText());
    }

    public String sourceInfo() {
        if (this.pkg != null) {
            return this.pkg.getSourceInfo();
        }
        return null;
    }

    public String packageFileName() {
        if (this.pkg != null) {
            return this.pkg.getPackageFileName();
        }
        return null;
    }

    public String supplier() {
        if (this.pkg != null) {
            return this.pkg.getSupplier();
        }
        return null;
    }

    public String originator() {
        if (this.pkg != null) {
            return this.pkg.getOriginator();
        }
        return null;
    }

    public String description() {
        if (this.pkg != null) {
            return this.pkg.getDescription();
        }
        return null;
    }

    public VerificationCodeContext packageVerificationCode() {
        if (this.pkg == null) {
            return null;
        }
        try {
            SpdxPackageVerificationCode verificationCode = this.pkg.getPackageVerificationCode();
            if (verificationCode == null) {
                return null;
            }
            return new VerificationCodeContext(verificationCode);
        }
        catch (InvalidSPDXAnalysisException e) {
            return new VerificationCodeContext(e);
        }
    }

    public List<String> checksum() {
        if (this.pkg != null) {
            ArrayList retval = Lists.newArrayList();
            try {
                Checksum[] checksums = this.pkg.getChecksums();
                if (checksums == null || checksums.length > 0) {
                    return null;
                }
                for (int i = 0; i < checksums.length; ++i) {
                    retval.add((String)Checksum.CHECKSUM_ALGORITHM_TO_TAG.get((Object)checksums[i].getAlgorithm()) + " " + checksums[i].getValue());
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Error getting SPDX Package checksum: " + e.getMessage());
            }
            Collections.sort(retval);
            return retval;
        }
        return null;
    }

    public String copyrightText() {
        if (this.pkg != null) {
            return this.pkg.getCopyrightText();
        }
        return null;
    }

    public String licenseDeclared() {
        if (this.pkg != null) {
            try {
                AnyLicenseInfo info = this.pkg.getLicenseDeclared();
                if (info != null) {
                    return info.toString();
                }
                return null;
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package copyright: " + e.getMessage();
            }
        }
        return null;
    }

    public String licenseConcluded() {
        if (this.pkg != null) {
            AnyLicenseInfo info = this.pkg.getLicenseConcluded();
            if (info != null) {
                return info.toString();
            }
            return null;
        }
        return null;
    }

    public String licenseComments() {
        if (this.pkg != null) {
            return this.pkg.getLicenseComments();
        }
        return null;
    }

    public String homePage() {
        if (this.pkg != null) {
            return this.pkg.getHomepage();
        }
        return null;
    }

    public List<String> licenseInfoFromFiles() {
        ArrayList retval = Lists.newArrayList();
        if (this.pkg != null) {
            AnyLicenseInfo[] licenseInfos = null;
            licenseInfos = this.pkg.getLicenseInfoFromFiles();
            if (licenseInfos != null) {
                for (int i = 0; i < licenseInfos.length; ++i) {
                    retval.add(licenseInfos[i].toString());
                }
            }
        }
        Collections.sort(retval);
        return retval;
    }

    public String spdxId() {
        if (this.pkg == null) {
            return null;
        }
        return this.pkg.getId();
    }

    public List<ElementContext> hasFile() {
        ArrayList retval = Lists.newArrayList();
        if (this.pkg != null) {
            try {
                SpdxFile[] files = this.pkg.getFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        retval.add(new ElementContext(files[i], this.spdxIdToUrl));
                    }
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add(new ElementContext(e));
            }
        }
        Collections.sort(retval, new Comparator<ElementContext>(){

            @Override
            public int compare(ElementContext o1, ElementContext o2) {
                if ((o1 == null || o1.getId() == null) && o2 != null && o2.getId() != null) {
                    return 1;
                }
                if (o2 == null || o2.getId() == null) {
                    return -1;
                }
                return o1.getId().compareTo(o2.getId());
            }
        });
        return retval;
    }

    public boolean isFilesAnalyzed() {
        if (this.pkg == null) {
            return true;
        }
        try {
            return this.pkg.isFilesAnalyzed();
        }
        catch (InvalidSPDXAnalysisException e) {
            return true;
        }
    }

    public List<RelationshipContext> packageRelationships() {
        ArrayList retval = Lists.newArrayList();
        Object[] relationships = this.pkg.getRelationships();
        if (relationships != null) {
            Arrays.sort(relationships);
            for (Object relationship : relationships) {
                retval.add(new RelationshipContext((Relationship)relationship, this.spdxIdToUrl));
            }
        }
        return retval;
    }

    public List<AnnotationContext> packageAnnotations() {
        ArrayList retval = Lists.newArrayList();
        Object[] annotations = this.pkg.getAnnotations();
        if (annotations != null) {
            Arrays.sort(annotations);
            for (Object annotation : annotations) {
                retval.add(new AnnotationContext((Annotation)annotation));
            }
        }
        return retval;
    }

    public List<ExternalRefContext> externalRefs() {
        ArrayList retval = Lists.newArrayList();
        if (this.pkg != null) {
            try {
                Object[] externalRefs = this.pkg.getExternalRefs();
                if (externalRefs != null) {
                    Arrays.sort(externalRefs);
                    for (Object externalRef : externalRefs) {
                        retval.add(new ExternalRefContext((ExternalRef)externalRef));
                    }
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return retval;
    }
}

