/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;

public class CrossRef
extends RdfModelObject {
    String match;
    String url;
    Boolean isValid;
    Boolean isLive;
    String timestamp;
    Boolean isWayBackLink;
    Integer order;

    public CrossRef(String url, @Nullable Boolean isValid, @Nullable Boolean isLive, @Nullable Boolean isWayBackLink, @Nullable String match, @Nullable String timestamp, @Nullable Integer order) {
        this.url = url;
        this.isValid = isValid;
        this.isLive = isLive;
        this.isWayBackLink = isWayBackLink;
        this.match = match;
        this.timestamp = timestamp;
        this.order = order;
    }

    public CrossRef(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    public CrossRef(String url) {
        this(url, null, null, null, null, null, null);
    }

    @Override
    public List<String> verify() {
        ArrayList<String> retval = new ArrayList<String>();
        if (Objects.isNull(this.url)) {
            retval.add("URL is Null");
        }
        return retval;
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (compare instanceof CrossRef) {
            CrossRef compCrossRef = (CrossRef)compare;
            return Objects.equals(this.url, compCrossRef.getUrl());
        }
        return false;
    }

    @Nullable
    private Boolean findBooleanPropertyValue(String namespace, String propertyName) throws InvalidSPDXAnalysisException {
        String textValue = this.findSinglePropertyValue(namespace, propertyName);
        if (textValue != null) {
            if ((textValue = textValue.trim()).equals("true") || textValue.equals("1")) {
                return new Boolean(true);
            }
            if (textValue.equals("false") || textValue.equals("0")) {
                return new Boolean(false);
            }
            throw new InvalidSPDXAnalysisException("Invalid value for boolean {true, false, 0, 1}");
        }
        return null;
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.match = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "match");
        this.url = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "url");
        this.isValid = this.findBooleanPropertyValue("http://spdx.org/rdf/terms#", "isValid");
        this.isLive = this.findBooleanPropertyValue("http://spdx.org/rdf/terms#", "isLive");
        this.timestamp = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "timestamp");
        this.isWayBackLink = this.findBooleanPropertyValue("http://spdx.org/rdf/terms#", "isWayBackLink");
        String orderText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "order");
        if (Objects.nonNull(orderText)) {
            try {
                this.order = Integer.parseInt(orderText);
            }
            catch (NumberFormatException ex) {
                throw new InvalidSPDXAnalysisException("Invalid value for order - could not convert to integer: " + orderText, ex);
            }
        } else {
            this.order = null;
        }
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#CrossRef");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        this.setPropertyValue("http://spdx.org/rdf/terms#", "url", this.url);
        this.removePropertyValue("http://spdx.org/rdf/terms#", "isValid");
        if (Objects.nonNull(this.isValid)) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "isValid", this.isValid.toString());
        }
        this.removePropertyValue("http://spdx.org/rdf/terms#", "isLive");
        if (Objects.nonNull(this.isValid)) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "isLive", this.isLive.toString());
        }
        this.removePropertyValue("http://spdx.org/rdf/terms#", "isWayBackLink");
        if (Objects.nonNull(this.isValid)) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "isWayBackLink", this.isWayBackLink.toString());
        }
        this.setPropertyValue("http://spdx.org/rdf/terms#", "match", this.match);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "timestamp", this.timestamp);
        this.removePropertyValue("http://spdx.org/rdf/terms#", "order");
        if (Objects.nonNull(this.order)) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "order", this.order.toString());
        }
    }

    public String getMatch() {
        if (this.resource != null && this.refreshOnGet) {
            this.match = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "match");
        }
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "match", this.match);
    }

    public String getUrl() {
        if (this.resource != null && this.refreshOnGet) {
            this.url = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "url");
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "url", this.url);
    }

    public Boolean isValid() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            this.isValid = this.findBooleanPropertyValue("http://spdx.org/rdf/terms#", "isValid");
        }
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
        this.removePropertyValue("http://spdx.org/rdf/terms#", "isValid");
        if (Objects.nonNull(this.isValid)) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "isValid", this.isValid.toString());
        }
    }

    public Boolean isLive() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            this.isLive = this.findBooleanPropertyValue("http://spdx.org/rdf/terms#", "isLive");
        }
        return this.isLive;
    }

    public void setIsLive(Boolean isLive) {
        this.isLive = isLive;
        this.removePropertyValue("http://spdx.org/rdf/terms#", "isLive");
        if (Objects.nonNull(this.isLive)) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "isLive", this.isLive.toString());
        }
    }

    public String getTimestamp() {
        if (this.resource != null && this.refreshOnGet) {
            this.timestamp = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "timestamp");
        }
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "timestamp", this.timestamp);
    }

    public Boolean isWayBackLink() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            this.isWayBackLink = this.findBooleanPropertyValue("http://spdx.org/rdf/terms#", "isWayBackLink");
        }
        return this.isWayBackLink;
    }

    public void setIsWayBackLink(Boolean isWayBackLink) {
        this.isWayBackLink = isWayBackLink;
        this.removePropertyValue("http://spdx.org/rdf/terms#", "isWayBackLink");
        if (Objects.nonNull(this.isWayBackLink)) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "isWayBackLink", this.isWayBackLink.toString());
        }
    }

    public Integer getOrder() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            String orderText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "order");
            if (Objects.nonNull(orderText)) {
                try {
                    this.order = Integer.parseInt(orderText);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidSPDXAnalysisException("Invalid value for order - could not convert to integer: " + orderText, ex);
                }
            } else {
                this.order = null;
            }
        }
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
        this.removePropertyValue("http://spdx.org/rdf/terms#", "order");
        if (Objects.nonNull(this.order)) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "order", this.order.toString());
        }
    }

    public void setDetails(Boolean isValid, Boolean isLive, Boolean isWayBackLink, String match, String timestamp) {
        this.setIsValid(isValid);
        this.setIsLive(isLive);
        this.setIsWayBackLink(isWayBackLink);
        this.setMatch(match);
        this.setTimestamp(timestamp);
    }

    public String toString() {
        String crossRefDetails = String.format("{%s: %s,%s: %b,%s: %b,%s: %b,%s: %s,%s: %s}", "url", this.url, "isValid", this.isValid, "isLive", this.isLive, "isWayBackLink", this.isWayBackLink, "match", this.match, "timestamp", this.timestamp);
        return crossRefDetails;
    }
}

