/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.jena.graph.Node;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.CrossRef;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.model.IRdfModel;

public abstract class License
extends SimpleLicensingInfo {
    static final String XML_LITERAL = "^^http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    private boolean textInHtml = true;
    private boolean templateInHtml = false;
    protected String standardLicenseHeader;
    protected String standardLicenseTemplate;
    protected String licenseText;
    protected boolean osiApproved;
    protected Boolean fsfLibre = null;
    protected boolean deprecated;
    private String standardLicenseHeaderTemplate;

    public License(String name, String id, String text, String[] sourceUrl, String comments, String standardLicenseHeader, String template, boolean osiApproved) throws InvalidSPDXAnalysisException {
        this(name, id, text, sourceUrl, comments, standardLicenseHeader, template, osiApproved, null);
    }

    public License(String name, String id, String text, String[] sourceUrl, String comments, String standardLicenseHeader, String template, String standardLicenseHeaderTemplate, boolean osiApproved, Boolean fsfLibre) throws InvalidSPDXAnalysisException {
        super(name, id, comments, sourceUrl);
        this.standardLicenseHeader = standardLicenseHeader;
        this.standardLicenseTemplate = template;
        this.osiApproved = osiApproved;
        this.fsfLibre = fsfLibre;
        this.licenseText = text;
        this.deprecated = false;
        this.standardLicenseHeaderTemplate = standardLicenseHeaderTemplate;
    }

    public License(String name, String id, String text, String[] sourceUrl, CrossRef[] sourceUrlDetails, String comments, String standardLicenseHeader, String template, String standardLicenseHeaderTemplate, boolean osiApproved, Boolean fsfLibre) throws InvalidSPDXAnalysisException {
        super(name, id, comments, sourceUrl, sourceUrlDetails);
        this.standardLicenseHeader = standardLicenseHeader;
        this.standardLicenseTemplate = template;
        this.osiApproved = osiApproved;
        this.fsfLibre = fsfLibre;
        this.licenseText = text;
        this.deprecated = false;
        this.standardLicenseHeaderTemplate = standardLicenseHeaderTemplate;
    }

    public License(String name, String id, String text, String[] sourceUrl, String comments, String standardLicenseHeader, String template, boolean osiApproved, Boolean fsfLibre) throws InvalidSPDXAnalysisException {
        this(name, id, text, sourceUrl, comments, standardLicenseHeader, template, standardLicenseHeader, osiApproved, fsfLibre);
    }

    public License(IModelContainer modelContainer, Node licenseNode) throws InvalidSPDXAnalysisException {
        super(modelContainer, licenseNode);
        this.getPropertiesFromModel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        String osiTextValue;
        super.getPropertiesFromModel();
        this.licenseText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseText");
        if (this.licenseText != null && this.licenseText.endsWith(XML_LITERAL)) {
            this.licenseText = this.licenseText.substring(0, this.licenseText.length() - XML_LITERAL.length());
        }
        if (this.licenseText != null && this.textInHtml) {
            this.licenseText = SpdxLicenseTemplateHelper.htmlToText(this.licenseText);
        }
        this.standardLicenseHeader = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "standardLicenseHeader");
        if (this.standardLicenseHeader == null) {
            this.standardLicenseHeader = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseHeader");
        }
        if (this.standardLicenseHeader != null) {
            this.standardLicenseHeader = StringEscapeUtils.unescapeHtml4((String)this.standardLicenseHeader);
        }
        this.standardLicenseHeaderTemplate = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "standardLicenseHeaderTemplate");
        if (this.standardLicenseHeaderTemplate != null) {
            this.standardLicenseHeaderTemplate = StringEscapeUtils.unescapeHtml4((String)this.standardLicenseHeaderTemplate);
        }
        this.standardLicenseTemplate = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "standardLicenseTemplate");
        if (this.standardLicenseTemplate == null) {
            this.standardLicenseTemplate = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseTemplate");
        }
        if (this.standardLicenseTemplate != null && this.standardLicenseTemplate.endsWith(XML_LITERAL)) {
            this.standardLicenseTemplate = this.standardLicenseTemplate.substring(0, this.standardLicenseTemplate.length() - XML_LITERAL.length());
        }
        if (this.standardLicenseTemplate != null && this.templateInHtml) {
            this.standardLicenseTemplate = SpdxLicenseTemplateHelper.htmlToText(this.standardLicenseTemplate);
        }
        if ((osiTextValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "isOsiApproved")) == null) {
            osiTextValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseOsiApproved");
        }
        if (osiTextValue != null) {
            if ((osiTextValue = osiTextValue.trim()).equals("true") || osiTextValue.equals("1")) {
                this.osiApproved = true;
            } else {
                if (!osiTextValue.equals("false") && !osiTextValue.equals("0")) throw new InvalidSPDXAnalysisException("Invalid value for OSI Approved - must be {true, false, 0, 1}");
                this.osiApproved = false;
            }
        } else {
            this.osiApproved = false;
        }
        String fsfTextValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre");
        if (fsfTextValue != null) {
            if ((fsfTextValue = fsfTextValue.trim()).equals("true") || fsfTextValue.equals("1")) {
                this.fsfLibre = true;
            } else {
                if (!fsfTextValue.equals("false") && !fsfTextValue.equals("0")) throw new InvalidSPDXAnalysisException("Invalid value for FSF Free - must be {true, false, 0, 1}");
                this.fsfLibre = false;
            }
        } else {
            this.fsfLibre = null;
        }
        String deprecatedValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "isDeprecatedLicenseId");
        if (deprecatedValue == null) return;
        if ((deprecatedValue = deprecatedValue.trim()).equals("true") || deprecatedValue.equals("1")) {
            this.deprecated = true;
            return;
        } else {
            if (!deprecatedValue.equals("false") && !deprecatedValue.equals("0")) throw new InvalidSPDXAnalysisException("Invalid value for license deprecated - must be {true, false, 0, 1}");
            this.deprecated = false;
        }
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        super.populateModel();
        this.setPropertyValue("http://spdx.org/rdf/terms#", "licenseText", this.licenseText);
        this.textInHtml = false;
        this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseOsiApproved");
        if (this.osiApproved) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "isOsiApproved", "true");
        } else {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "isOsiApproved");
        }
        this.removePropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre");
        if (this.fsfLibre != null) {
            if (this.fsfLibre.booleanValue()) {
                this.setPropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre", "true");
            } else {
                this.setPropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre", "false");
            }
        } else {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre");
        }
        this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseHeader");
        this.setPropertyValue("http://spdx.org/rdf/terms#", "standardLicenseHeader", this.standardLicenseHeader);
        this.removePropertyValue("http://spdx.org/rdf/terms#", "standardLicenseHeaderTemplate");
        if (this.standardLicenseHeaderTemplate != null) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "standardLicenseHeaderTemplate", this.standardLicenseHeaderTemplate);
        }
        this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseTemplate");
        this.setPropertyValue("http://spdx.org/rdf/terms#", "standardLicenseTemplate", this.standardLicenseTemplate);
        this.templateInHtml = false;
        if (this.deprecated) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "isDeprecatedLicenseId", "true");
        } else {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "isDeprecatedLicenseId");
        }
    }

    public String getLicenseText() {
        if (this.resource != null && this.refreshOnGet) {
            this.licenseText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseText");
            if (this.licenseText != null && this.licenseText.endsWith(XML_LITERAL)) {
                this.licenseText = this.licenseText.substring(0, this.licenseText.length() - XML_LITERAL.length());
            }
            if (this.licenseText != null && this.textInHtml) {
                this.licenseText = SpdxLicenseTemplateHelper.htmlToText(this.licenseText);
            }
        }
        return this.licenseText;
    }

    public void setLicenseText(String text) {
        this.licenseText = text;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "licenseText", text);
        this.textInHtml = false;
    }

    @Deprecated
    public String getNotes() {
        return this.getComment();
    }

    @Deprecated
    public void setNotes(String notes) {
        this.setComment(notes);
    }

    public String getStandardLicenseHeader() {
        if (this.resource != null && this.refreshOnGet) {
            this.standardLicenseHeader = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "standardLicenseHeader");
            if (this.standardLicenseHeader == null) {
                this.standardLicenseHeader = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseHeader");
            }
            if (this.standardLicenseHeader != null) {
                this.standardLicenseHeader = StringEscapeUtils.unescapeHtml4((String)this.standardLicenseHeader);
            }
        }
        return this.standardLicenseHeader;
    }

    public String getStandardLicenseHeaderTemplate() {
        if (this.resource != null && this.refreshOnGet) {
            this.standardLicenseHeaderTemplate = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "standardLicenseHeaderTemplate");
            if (this.standardLicenseHeaderTemplate != null) {
                this.standardLicenseHeaderTemplate = StringEscapeUtils.unescapeHtml4((String)this.standardLicenseHeaderTemplate);
            }
        }
        return this.standardLicenseHeaderTemplate;
    }

    public void setStandardLicenseHeaderTemplate(String standardLicenseHeaderTemplate) {
        this.standardLicenseHeaderTemplate = standardLicenseHeaderTemplate;
        this.removePropertyValue("http://spdx.org/rdf/terms#", "standardLicenseHeaderTemplate");
        if (standardLicenseHeaderTemplate != null) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "standardLicenseHeaderTemplate", standardLicenseHeaderTemplate);
        }
    }

    public void setStandardLicenseHeader(String standardLicenseHeader) {
        this.standardLicenseHeader = standardLicenseHeader;
        this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseHeader");
        this.setPropertyValue("http://spdx.org/rdf/terms#", "standardLicenseHeader", standardLicenseHeader);
    }

    public String getStandardLicenseTemplate() {
        if (this.resource != null && this.refreshOnGet) {
            this.standardLicenseTemplate = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "standardLicenseTemplate");
            if (this.standardLicenseTemplate == null) {
                this.standardLicenseTemplate = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseTemplate");
            }
            if (this.standardLicenseTemplate != null && this.standardLicenseTemplate.endsWith(XML_LITERAL)) {
                this.standardLicenseTemplate = this.standardLicenseTemplate.substring(0, this.standardLicenseTemplate.length() - XML_LITERAL.length());
            }
            if (this.standardLicenseTemplate != null && this.templateInHtml) {
                this.standardLicenseTemplate = SpdxLicenseTemplateHelper.htmlToText(this.standardLicenseTemplate);
            }
        }
        return this.standardLicenseTemplate;
    }

    public void setStandardLicenseTemplate(String template) {
        this.standardLicenseTemplate = template;
        this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseTemplate");
        this.setPropertyValue("http://spdx.org/rdf/terms#", "standardLicenseTemplate", template);
        this.templateInHtml = false;
    }

    @Override
    public String toString() {
        if (this.licenseId == null) {
            return "NULL LICENSE";
        }
        return this.licenseId;
    }

    @Override
    public int hashCode() {
        if (this.getLicenseId() != null) {
            return this.getLicenseId().toLowerCase().hashCode();
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof License)) {
            return false;
        }
        License comp = (License)o;
        if (this.licenseId == null) {
            return comp.getLicenseId() == null;
        }
        return this.licenseId.equalsIgnoreCase(comp.getLicenseId());
    }

    @Override
    public List<String> verify() {
        String name;
        ArrayList retval = Lists.newArrayList();
        String id = this.getLicenseId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required license ID");
        }
        if ((name = this.getName()) == null || name.isEmpty()) {
            retval.add("Missing required license name");
        }
        this.getComment();
        this.getSeeAlso();
        this.getStandardLicenseHeader();
        this.getStandardLicenseTemplate();
        this.getStandardLicenseHeaderTemplate();
        String licenseText = this.getLicenseText();
        if (licenseText == null || licenseText.isEmpty()) {
            retval.add("Missing required license text for " + id);
        }
        return retval;
    }

    public boolean isFsfLibre() {
        if (this.resource != null && this.refreshOnGet) {
            String fsfTextValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre");
            if (fsfTextValue != null) {
                if ((fsfTextValue = fsfTextValue.trim()).equals("true") || fsfTextValue.equals("1")) {
                    this.fsfLibre = true;
                } else if (fsfTextValue.equals("false") || fsfTextValue.equals("0")) {
                    this.fsfLibre = false;
                }
            } else {
                this.fsfLibre = null;
            }
        }
        return this.fsfLibre != null && this.fsfLibre != false;
    }

    public boolean isNotFsfLibre() {
        if (this.resource != null && this.refreshOnGet) {
            String fsfTextValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre");
            if (fsfTextValue != null) {
                if ((fsfTextValue = fsfTextValue.trim()).equals("true") || fsfTextValue.equals("1")) {
                    this.fsfLibre = true;
                } else if (fsfTextValue.equals("false") || fsfTextValue.equals("0")) {
                    this.fsfLibre = false;
                }
            } else {
                this.fsfLibre = null;
            }
        }
        return this.fsfLibre != null && this.fsfLibre == false;
    }

    public Boolean getFsfLibre() {
        if (this.resource != null && this.refreshOnGet) {
            String fsfTextValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre");
            if (fsfTextValue != null) {
                if ((fsfTextValue = fsfTextValue.trim()).equals("true") || fsfTextValue.equals("1")) {
                    this.fsfLibre = true;
                } else if (fsfTextValue.equals("false") || fsfTextValue.equals("0")) {
                    this.fsfLibre = false;
                }
            } else {
                this.fsfLibre = null;
            }
        }
        return this.fsfLibre;
    }

    public boolean isOsiApproved() {
        if (this.resource != null && this.refreshOnGet) {
            String osiTextValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "isOsiApproved");
            if (osiTextValue == null) {
                osiTextValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseOsiApproved");
            }
            this.osiApproved = osiTextValue != null ? ((osiTextValue = osiTextValue.trim()).equals("true") || osiTextValue.equals("1") ? true : (osiTextValue.equals("false") || osiTextValue.equals("0") ? false : false)) : false;
        }
        return this.osiApproved;
    }

    public boolean isDeprecated() {
        if (this.resource != null && this.refreshOnGet) {
            String deprecatedValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "isDeprecatedLicenseId");
            this.deprecated = deprecatedValue != null ? ((deprecatedValue = deprecatedValue.trim()).equals("true") || deprecatedValue.equals("1") ? true : (deprecatedValue.equals("false") || deprecatedValue.equals("0") ? false : false)) : false;
        }
        return this.deprecated;
    }

    public void setOsiApproved(boolean osiApproved) {
        this.osiApproved = osiApproved;
        this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseOsiApproved");
        if (osiApproved) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "isOsiApproved", "true");
        } else {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "isOsiApproved");
        }
    }

    public void setFsfLibre(Boolean fsfLibre) {
        this.fsfLibre = fsfLibre;
        if (fsfLibre != null) {
            if (fsfLibre.booleanValue()) {
                this.setPropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre", "true");
            } else {
                this.setPropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre", "false");
            }
        } else {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "isFsfLibre");
        }
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
        this.removePropertyValue("http://spdx.org/rdf/terms#", "isDeprecatedLicenseId");
        if (this.deprecated) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "isDeprecatedLicenseId", "true");
        }
    }

    @Override
    public AnyLicenseInfo clone() {
        try {
            SpdxListedLicense retval = new SpdxListedLicense(this.getName(), this.getLicenseId(), this.getLicenseText(), this.getSeeAlso(), this.getCrossRef(), this.getComment(), this.getStandardLicenseHeader(), this.getStandardLicenseTemplate(), this.getStandardLicenseHeaderTemplate(), this.isOsiApproved(), this.getFsfLibre());
            retval.setDeprecated(this.isDeprecated());
            return retval;
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new AssertionError("Clone should never cause an Invalid SPDX Exception", e);
        }
    }

    public void copyFrom(License license) throws InvalidSPDXAnalysisException {
        this.setComment(license.getComment());
        this.setLicenseId(license.getLicenseId());
        this.setLicenseText(license.getLicenseText());
        this.setName(license.getName());
        this.setOsiApproved(license.isOsiApproved());
        this.setSeeAlso(license.getSeeAlso());
        this.setCrossRef(license.getCrossRef());
        this.setStandardLicenseHeader(license.getStandardLicenseHeader());
        this.setStandardLicenseTemplate(this.getStandardLicenseTemplate());
        this.setStandardLicenseHeaderTemplate(license.getStandardLicenseHeaderTemplate());
        this.setFsfLibre(license.getFsfLibre());
        this.setDeprecated(license.isDeprecated());
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (!(compare instanceof License)) {
            return false;
        }
        License lCompare = (License)compare;
        return LicenseCompareHelper.isLicenseTextEquivalent(this.licenseText, lCompare.getLicenseText());
    }
}

