/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.model.SpdxFile;

public class FileAttributionSheet
extends AbstractFileCompareSheet {
    private static final int FILE_ATTRIBUTION_COL_WIDTH = 50;

    public FileAttributionSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 50);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        return SpdxComparer.stringArraysEqual(fileA.getAttributionText(), fileB.getAttributionText());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        StringBuilder sb = new StringBuilder();
        String[] attribution = spdxFile.getAttributionText();
        if (attribution != null && attribution.length > 0) {
            sb.append(attribution[0]);
            for (int i = 1; i < attribution.length; ++i) {
                sb.append(", ");
                sb.append(attribution[i]);
            }
        }
        return sb.toString();
    }
}

