/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.referencetype;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;
import org.spdx.rdfparser.referencetype.ListedReferenceTypes;

public class ReferenceType
extends RdfModelObject
implements Comparable<ReferenceType> {
    static final Logger logger = LoggerFactory.getLogger(ReferenceType.class);
    String contextualExample;
    URL documentation;
    URL externalReferenceSite;
    URI referenceTypeUri;

    public ReferenceType(URI uri, String contextualExample, URL documentation, URL externalReferenceSite) throws InvalidSPDXAnalysisException {
        this.referenceTypeUri = uri;
        this.contextualExample = contextualExample;
        this.documentation = documentation;
        this.externalReferenceSite = externalReferenceSite;
    }

    public ReferenceType(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    @Override
    public List<String> verify() {
        ArrayList<String> retval = new ArrayList<String>();
        if (this.referenceTypeUri == null) {
            retval.add("Missing required URI for Reference Type");
        }
        return retval;
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (!(compare instanceof ReferenceType)) {
            return false;
        }
        ReferenceType oComp = (ReferenceType)compare;
        URI myReferenceTypeUri = this.getReferenceTypeUri();
        if (myReferenceTypeUri == null) {
            return oComp.getReferenceTypeUri() == null;
        }
        return myReferenceTypeUri.equals(oComp.getReferenceTypeUri());
    }

    public String getContextualExample() throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("This field is not implemented.");
    }

    public void setContextualExample(String contextualExample) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("This field is not implemented.");
    }

    public URL getDocumentation() throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("This field is not implemented.");
    }

    public void setDocumentation(URL documentation) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("This field is not implemented.");
    }

    public URL getExternalReferenceSite() throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("This field is not implemented.");
    }

    public void setExternalReferenceSite(URL externalReferenceSite) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("This field is not implemented.");
    }

    public URI getReferenceTypeUri() {
        return this.referenceTypeUri;
    }

    public void setReferenceTypeUri(URI referenceTypeUri) {
        this.referenceTypeUri = referenceTypeUri;
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        if (this.node == null) {
            return;
        }
        if (!this.node.isURI()) {
            throw new InvalidSPDXAnalysisException("Only URI based reference types are supported at this time.");
        }
        try {
            this.referenceTypeUri = new URI(this.node.getURI());
        }
        catch (URISyntaxException e) {
            logger.error("Invalid URI for external reference type found in the model.", (Throwable)e);
            throw new InvalidSPDXAnalysisException("Invalid URI for external reference type found in the model.");
        }
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return this.referenceTypeUri.toString();
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#ReferenceType");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
    }

    @Override
    public int compareTo(ReferenceType o) {
        if (this.getReferenceTypeUri() == null) {
            if (o.getReferenceTypeUri() == null) {
                return 0;
            }
            return 1;
        }
        if (o.getReferenceTypeUri() == null) {
            return -1;
        }
        return this.getReferenceTypeUri().compareTo(o.getReferenceTypeUri());
    }

    public String toString() {
        if (this.referenceTypeUri == null) {
            return "";
        }
        if (ListedReferenceTypes.getListedReferenceTypes().isListedReferenceType(this.referenceTypeUri)) {
            try {
                return ListedReferenceTypes.getListedReferenceTypes().getListedReferenceName(this.referenceTypeUri);
            }
            catch (InvalidSPDXAnalysisException e) {
                return this.referenceTypeUri.toString();
            }
        }
        return this.referenceTypeUri.toString();
    }

    public ReferenceType clone() {
        try {
            return new ReferenceType(this.referenceTypeUri, this.contextualExample, this.documentation, this.externalReferenceSite);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error cloning reference type", (Throwable)e);
            throw new AssertionError("Clone should never cause an Invalid SPDX Exception", e);
        }
    }
}

