/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.NonStandardLicensesSheet;

public class NonStandardLicensesSheetV1d1
extends NonStandardLicensesSheet {
    static final int NUM_COLS = 6;
    static final int IDENTIFIER_COL = 0;
    static final int EXTRACTED_TEXT_COL = 1;
    static final int LICENSE_NAME_COL = 2;
    static final int CROSS_REF_URL_COL = 3;
    static final int COMMENT_COL = 4;
    static final int USER_DEFINED_COL = 5;
    static boolean[] REQUIRED = new boolean[]{true, true, false, false, false, false};
    static final String[] HEADER_TITLES = new String[]{"Identifier", "Extracted Text", "License Name", "Cross Reference URLs", "Comment", "User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{15, 120, 50, 80, 80, 50};
    static final boolean[] LEFT_WRAP = new boolean[]{false, false, false, true, true, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{true, false, true, false, false, false};
    private static final int MAX_CELL_CONTENT_SIZE = 32700;

    public NonStandardLicensesSheetV1d1(Workbook workbook, String sheetName, String version) {
        super(workbook, sheetName, version);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for non-standard Licenses does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 5; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for non-standard Licenses worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getStringCellValue() == null || row.getCell(this.firstCellNum).getStringCellValue().trim().isEmpty()) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying non-standard License work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 6; ++i) {
            Cell cell = row.getCell(i);
            if (cell != null || !REQUIRED[i]) continue;
            return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    @Override
    public void add(String identifier, String extractedTextIn, String licenseName, String[] crossRefUrls, String comment) {
        Row row = this.addRow();
        Cell idCell = row.createCell(0);
        idCell.setCellValue(identifier);
        Cell extractedTextCell = row.createCell(1);
        String extractedText = extractedTextIn;
        if (extractedText == null) {
            extractedText = "";
        }
        if (extractedText.length() > 32700) {
            extractedText = "[WARNING: TRUNCATED]" + extractedText.substring(0, 32680);
        }
        extractedTextCell.setCellValue(extractedText);
        if (licenseName != null && !licenseName.isEmpty()) {
            Cell licenseNameCell = row.createCell(2);
            licenseNameCell.setCellValue(licenseName);
        }
        if (crossRefUrls != null && crossRefUrls.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(crossRefUrls[0]);
            for (int i = 1; i < crossRefUrls.length; ++i) {
                sb.append(", ");
                sb.append(crossRefUrls[i]);
            }
            Cell crossRefCell = row.createCell(3);
            crossRefCell.setCellValue(sb.toString());
        }
        if (comment != null && !comment.isEmpty()) {
            Cell commentCell = row.createCell(4);
            commentCell.setCellValue(comment);
        }
    }

    @Override
    public String getIdentifier(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell idCell = row.getCell(0);
        if (idCell == null) {
            return null;
        }
        return idCell.getStringCellValue();
    }

    @Override
    public String getExtractedText(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell extractedTextCell = row.getCell(1);
        if (extractedTextCell == null) {
            return null;
        }
        return extractedTextCell.getStringCellValue();
    }

    @Override
    public String getLicenseName(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell licenseNameCell = row.getCell(2);
        if (licenseNameCell == null) {
            return null;
        }
        return licenseNameCell.getStringCellValue();
    }

    @Override
    public String[] getCrossRefUrls(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell crossRefUrlsCell = row.getCell(3);
        if (crossRefUrlsCell == null) {
            return null;
        }
        String val = crossRefUrlsCell.getStringCellValue().trim();
        if (val.isEmpty()) {
            return null;
        }
        String[] retval = val.split(",");
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = retval[i].trim();
        }
        return retval;
    }

    @Override
    public String getComment(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell commentCell = row.getCell(4);
        if (commentCell == null) {
            return null;
        }
        return commentCell.getStringCellValue();
    }
}

