/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.examples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class SimpleSpdxDocument {
    public static void main(String[] args) {
        File outFile;
        if (args.length != 1) {
            SimpleSpdxDocument.usage();
            System.exit(1);
        }
        if ((outFile = new File(args[0])).exists()) {
            System.out.println("Output file already exists: " + args[0]);
            System.exit(1);
        }
        MultiFormatStore modelStore = new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY);
        String documentUri = "https://org.spdx.examples/spdx/doc/b7490f5a-b6ac-45e7-9971-4c27f1db97f7";
        ModelCopyManager copyManager = new ModelCopyManager();
        try {
            SpdxDocument document = SpdxModelFactory.createSpdxDocument((IModelStore)modelStore, (String)documentUri, (ModelCopyManager)copyManager);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            String creationDate = dateFormat.format(new Date());
            document.setCreationInfo(document.createCreationInfo(Arrays.asList("Tool: Simple SPDX Document Example"), creationDate));
            AnyLicenseInfo dataLicense = LicenseInfoFactory.parseSPDXLicenseString((String)"CC0-1.0");
            document.setDataLicense(dataLicense);
            document.setName("SPDX Example Document");
            document.setSpecVersion("SPDX-2.2");
            AnyLicenseInfo pkgConcludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)"Apache-2.0 AND MIT");
            AnyLicenseInfo pkgDeclaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)"Apache-2.0");
            String pkgId = modelStore.getNextId(IModelStore.IdType.SpdxId, documentUri);
            SpdxPackage pkg = document.createPackage(pkgId, "Example Package Name", pkgConcludedLicense, "Copyright example.org", pkgDeclaredLicense).setFilesAnalyzed(false).setComment("This package is used as an example in creating an SPDX document from scratch").setDownloadLocation("NOASSERTION").build();
            document.getDocumentDescribes().add(pkg);
            pkgId = modelStore.getNextId(IModelStore.IdType.SpdxId, documentUri);
            SpdxPackage childPkg = document.createPackage(pkgId, "Child Example Package Name", pkgConcludedLicense, "Copyright example.org", pkgDeclaredLicense).setFilesAnalyzed(false).setComment("This package is used as an example in creating an SPDX document from scratch").setDownloadLocation("NOASSERTION").build();
            Relationship relationship = pkg.createRelationship((SpdxElement)childPkg, RelationshipType.DEPENDS_ON, "");
            pkg.addRelationship(relationship);
            List warnings = document.verify();
            if (warnings.size() > 0) {
                System.out.println("The document has the following warnings:");
                for (String warning : warnings) {
                    System.out.print("\t");
                    System.out.println(warning);
                }
            }
            Throwable throwable = null;
            Iterator iterator = null;
            try (FileOutputStream outputStream = new FileOutputStream(outFile);){
                modelStore.serialize(documentUri, (OutputStream)outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            System.out.println("Example document written to " + args[0]);
            System.exit(0);
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.println("Unexpected error creating SPDX document: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("I/O error writing output JSON file");
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: SimpleSpxDocument outputFilePath");
    }
}

