/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import org.apache.commons.lang3.ArrayUtils;
import org.spdx.tools.CompareSpdxDocs;
import org.spdx.tools.GenerateVerificationCode;
import org.spdx.tools.MatchingStandardLicenses;
import org.spdx.tools.SpdxConverter;
import org.spdx.tools.SpdxVersion;
import org.spdx.tools.SpdxViewer;
import org.spdx.tools.Verify;

public class Main {
    public static void main(String[] args) {
        if (args.length < 1) {
            Main.usage();
            return;
        }
        String spdxTool = args[0];
        args = (String[])ArrayUtils.removeElement((Object[])args, (Object)args[0]);
        if ("Convert".equals(spdxTool)) {
            SpdxConverter.main(args);
        } else if ("SPDXViewer".equals(spdxTool)) {
            SpdxViewer.main(args);
        } else if ("Verify".equals(spdxTool)) {
            Verify.main(args);
        } else if ("CompareDocs".equals(spdxTool)) {
            CompareSpdxDocs.main(args);
        } else if ("GenerateVerificationCode".equals(spdxTool)) {
            GenerateVerificationCode.main(args);
        } else if ("Version".equals(spdxTool)) {
            System.out.println("SPDX Tool Version: " + SpdxVersion.getCurrentToolVersion() + "; Specification Version: " + SpdxVersion.getLibraryVersion() + "; License List Version: " + SpdxVersion.getLicenseListVersion());
        } else if ("MatchingStandardLicenses".equals(spdxTool)) {
            MatchingStandardLicenses.main(args);
        } else {
            Main.usage();
        }
    }

    private static void usage() {
        System.out.println("Usage: java -jar spdx-tools-jar-with-dependencies.jar <function> <parameters> \nfunction                 parameter                         example \n------------------------------------------------------------------------------------------------------------------- \nConvert         inputFile outputFile [fromType] [toType]   Examples/SPDXTagExample.tag TagToSpreadsheet.xls \nSPDXViewer      inputFile                                  TestFiles/SPDXRdfExample.rdf \nVerify          inputFile [type]                           TestFiles/SPDXRdfExample.rdf \nCompareDocs     output.xlsx doc1 doc2 ... docN \nGenerateVerificationCode sourceDirectory\nVersion\nMatchingStandardLicenses licenseTextFile");
    }
}

