/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.spdx.tools.schema.OwlToXsd;
import org.spdx.tools.schema.SchemaException;

public class RdfSchemaToXsd {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Invalid number of arguments");
            RdfSchemaToXsd.usage();
            return;
        }
        File fromFile = new File(args[0]);
        if (!fromFile.exists()) {
            System.err.println("Input file " + args[0] + " does not exist.");
            RdfSchemaToXsd.usage();
            return;
        }
        File toFile = new File(args[1]);
        if (toFile.exists()) {
            System.err.println("Output file " + args[1] + " already exists.");
            RdfSchemaToXsd.usage();
            return;
        }
        FileInputStream is = null;
        OntModel model = null;
        try {
            try {
                is = new FileInputStream(fromFile);
                model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                model.read((InputStream)is, "RDF/XML");
            }
            catch (FileNotFoundException e) {
                System.err.println("File not found for " + fromFile.getName());
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e2) {
                        System.err.println("Error closing input file stream: " + e2.getMessage());
                    }
                }
                return;
            }
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    System.err.println("Error closing input file stream: " + e.getMessage());
                }
            }
        }
        try {
            OwlToXsd owlToXsd = new OwlToXsd(model);
            XmlSchema xmlSchema = owlToXsd.convertToXsd();
            FileOutputStream os = null;
            try {
                try {
                    os = new FileOutputStream(toFile);
                    xmlSchema.write((OutputStream)os);
                }
                catch (IOException e) {
                    System.err.println("I/O error: " + e.getMessage());
                    if (Objects.nonNull(is)) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e3) {
                            System.err.println("Error closing input file stream: " + e3.getMessage());
                        }
                    }
                    if (Objects.nonNull(os)) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException e4) {
                            System.err.println("Error closing output file stream: " + e4.getMessage());
                        }
                    }
                    return;
                }
            }
            finally {
                if (Objects.nonNull(is)) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        System.err.println("Error closing input file stream: " + e.getMessage());
                    }
                }
                if (Objects.nonNull(os)) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e) {
                        System.err.println("Error closing output file stream: " + e.getMessage());
                    }
                }
            }
        }
        catch (XmlSchemaSerializer.XmlSchemaSerializerException e1) {
            System.err.println("Error generating XSD schema: " + e1.getMessage());
        }
        catch (SchemaException e1) {
            System.err.println("Error generating XSD schema: " + e1.getMessage());
        }
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("RdfSchemaToXsd rdfSchemaFile xsdFile");
        System.out.println("\trdfSchemaFile RDF schema file in RDF/XML format");
        System.out.println("\txsdFile output XML Schema");
    }
}

