/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxDocument;
import org.spdx.spdxRdfStore.OutputFormat;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.spreadsheetstore.SpreadsheetStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.tagvaluestore.TagValueStore;
import org.spdx.tools.InvalidFileNameException;

public class SpdxToolsHelper {
    static final String XML_INPUT_FACTORY_PROPERTY_KEY = "javax.xml.stream.XMLInputFactory";
    static Map<String, SerFileType> EXT_TO_FILETYPE;

    static {
        HashMap<String, SerFileType> temp = new HashMap<String, SerFileType>();
        temp.put("json", SerFileType.JSON);
        temp.put("rdf.xml", SerFileType.RDFXML);
        temp.put("rdf", SerFileType.RDFXML);
        temp.put("xml", SerFileType.XML);
        temp.put("xls", SerFileType.XLS);
        temp.put("xlsx", SerFileType.XLSX);
        temp.put("yaml", SerFileType.YAML);
        temp.put("tag", SerFileType.TAG);
        temp.put("spdx", SerFileType.TAG);
        temp.put("yml", SerFileType.YAML);
        temp.put("rdf.ttl", SerFileType.RDFTTL);
        EXT_TO_FILETYPE = Collections.unmodifiableMap(temp);
    }

    public static ISerializableModelStore fileTypeToStore(SerFileType fileType) throws InvalidSPDXAnalysisException {
        switch (fileType) {
            case JSON: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY, MultiFormatStore.Verbose.COMPACT);
            }
            case RDFXML: {
                RdfStore rdfStore = new RdfStore();
                rdfStore.setOutputFormat(OutputFormat.XML);
                return rdfStore;
            }
            case RDFTTL: {
                RdfStore rdfStore = new RdfStore();
                rdfStore.setOutputFormat(OutputFormat.TURTLE);
                return rdfStore;
            }
            case TAG: {
                return new TagValueStore((IModelStore)new InMemSpdxStore());
            }
            case XLS: {
                return new SpreadsheetStore((IModelStore)new InMemSpdxStore(), SpreadsheetStore.SpreadsheetFormatType.XLS);
            }
            case XLSX: {
                return new SpreadsheetStore((IModelStore)new InMemSpdxStore(), SpreadsheetStore.SpreadsheetFormatType.XLSX);
            }
            case XML: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.XML, MultiFormatStore.Verbose.COMPACT);
            }
            case YAML: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.YAML, MultiFormatStore.Verbose.COMPACT);
            }
        }
        throw new InvalidSPDXAnalysisException("Unsupported file type: " + (Object)((Object)fileType) + ".  Check back later.");
    }

    public static SerFileType fileToFileType(File file) throws InvalidFileNameException {
        SerFileType retval;
        String fileName = file.getName();
        if (!fileName.contains(".")) {
            throw new InvalidFileNameException("Can not convert file to file type - no file extension for file " + file.getPath());
        }
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if ("xml".equals(ext) && fileName.endsWith("rdf.xml")) {
            ext = "rdf.xml";
        }
        if ("ttl".equals(ext) && fileName.endsWith("rdf.ttl")) {
            ext = "rdf.ttl";
        }
        if (Objects.isNull((Object)(retval = EXT_TO_FILETYPE.get(ext)))) {
            throw new InvalidFileNameException("Unrecognized file extension: " + ext + " for file " + file.getPath());
        }
        return retval;
    }

    public static SerFileType strToFileType(String str) {
        String strFileType = str.toUpperCase().trim();
        return SerFileType.valueOf(strFileType);
    }

    public static SpdxDocument deserializeDocument(File file) throws InvalidSPDXAnalysisException, IOException, InvalidFileNameException {
        ISerializableModelStore store = SpdxToolsHelper.fileTypeToStore(SpdxToolsHelper.fileToFileType(file));
        return SpdxToolsHelper.readDocumentFromFile(store, file);
    }

    public static SpdxDocument deserializeDocument(File file, SerFileType fileType) throws InvalidSPDXAnalysisException, IOException {
        ISerializableModelStore store = SpdxToolsHelper.fileTypeToStore(fileType);
        return SpdxToolsHelper.readDocumentFromFile(store, file);
    }

    /*
     * Exception decompiling
     */
    public static SpdxDocument readDocumentFromFile(ISerializableModelStore store, File file) throws FileNotFoundException, IOException, InvalidSPDXAnalysisException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum SerFileType {
        JSON,
        RDFXML,
        XML,
        XLS,
        XLSX,
        YAML,
        TAG,
        RDFTTL;

    }
}

