/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSheet {
    static Logger logger = LoggerFactory.getLogger(AbstractSheet.class);
    static final String FONT_NAME = "Arial";
    protected static final short FONT_SIZE = 200;
    static final String CHECKBOX_FONT_NAME = "Wingdings 2";
    static final String CHECKBOX = "P";
    private static final short MAX_ROW_LINES = 10;
    protected CellStyle checkboxStyle;
    protected CellStyle dateStyle;
    protected CellStyle greenWrapped;
    protected CellStyle redWrapped;
    protected CellStyle yellowWrapped;
    protected Workbook workbook;
    protected Sheet sheet;
    protected int lastRowNum;
    protected int firstCellNum;
    protected int firstRowNum;

    public AbstractSheet(Workbook workbook, String sheetName) {
        this.workbook = workbook;
        this.sheet = workbook.getSheet(sheetName);
        if (this.sheet != null) {
            this.firstRowNum = this.sheet.getFirstRowNum();
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            this.firstCellNum = firstRow == null ? 1 : (int)firstRow.getFirstCellNum();
            this.findLastRow();
        } else {
            this.firstRowNum = 0;
            this.lastRowNum = 0;
            this.firstCellNum = 0;
        }
        this.createStyles(workbook);
    }

    private void createStyles(Workbook wb) {
        this.checkboxStyle = wb.createCellStyle();
        this.checkboxStyle.setAlignment(HorizontalAlignment.CENTER);
        this.checkboxStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.checkboxStyle.setBorderBottom(BorderStyle.THIN);
        this.checkboxStyle.setBorderLeft(BorderStyle.THIN);
        this.checkboxStyle.setBorderRight(BorderStyle.THIN);
        this.checkboxStyle.setBorderTop(BorderStyle.THIN);
        org.apache.poi.ss.usermodel.Font checkboxFont = wb.createFont();
        checkboxFont.setFontHeight((short)200);
        checkboxFont.setFontName(CHECKBOX_FONT_NAME);
        this.checkboxStyle.setFont(checkboxFont);
        this.dateStyle = wb.createCellStyle();
        DataFormat df = wb.createDataFormat();
        this.dateStyle.setDataFormat(df.getFormat("m/d/yy h:mm"));
        this.greenWrapped = AbstractSheet.createLeftWrapStyle(wb);
        this.greenWrapped.setFillForegroundColor(IndexedColors.LIGHT_GREEN.getIndex());
        this.greenWrapped.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.greenWrapped.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.yellowWrapped = AbstractSheet.createLeftWrapStyle(wb);
        this.yellowWrapped.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        this.yellowWrapped.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.redWrapped = AbstractSheet.createLeftWrapStyle(wb);
        this.redWrapped.setFillForegroundColor(IndexedColors.RED.getIndex());
        this.redWrapped.setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }

    private void findLastRow() {
        boolean done = false;
        this.lastRowNum = this.firstRowNum + 1;
        try {
            while (!done) {
                Row row = this.sheet.getRow(this.lastRowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getStringCellValue() == null || row.getCell(this.firstCellNum).getStringCellValue().isEmpty()) {
                    --this.lastRowNum;
                    done = true;
                    continue;
                }
                ++this.lastRowNum;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Row addRow() {
        ++this.lastRowNum;
        Row row = this.sheet.createRow(this.lastRowNum);
        return row;
    }

    public void clear() {
        int i = this.lastRowNum;
        while (i > this.firstRowNum) {
            Row row = this.sheet.getRow(i);
            this.sheet.removeRow(row);
            --i;
        }
        this.lastRowNum = this.firstRowNum;
    }

    public int getFirstDataRow() {
        return this.firstRowNum + 1;
    }

    public int getNumDataRows() {
        return this.lastRowNum - this.firstRowNum;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public abstract String verify();

    public static CellStyle createHeaderStyle(Workbook wb) {
        CellStyle headerStyle = wb.createCellStyle();
        headerStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        org.apache.poi.ss.usermodel.Font headerFont = wb.createFont();
        headerFont.setFontName(FONT_NAME);
        headerFont.setFontHeight((short)200);
        headerFont.setBold(true);
        headerStyle.setFont(headerFont);
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setWrapText(true);
        return headerStyle;
    }

    public static CellStyle createLeftWrapStyle(Workbook wb) {
        CellStyle wrapStyle = wb.createCellStyle();
        wrapStyle.setWrapText(true);
        wrapStyle.setAlignment(HorizontalAlignment.LEFT);
        wrapStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return wrapStyle;
    }

    public static CellStyle createCenterStyle(Workbook wb) {
        CellStyle centerStyle = wb.createCellStyle();
        centerStyle.setWrapText(false);
        centerStyle.setAlignment(HorizontalAlignment.CENTER);
        return centerStyle;
    }

    public void resizeRows() {
        int lastRow = this.getNumDataRows() + this.getFirstDataRow() - 1;
        int i = 0;
        while (i <= lastRow) {
            Row row = this.sheet.getRow(i);
            int lastCell = row.getLastCellNum();
            int maxNumLines = 1;
            int j = 0;
            while (j < lastCell) {
                int cellLines;
                Cell cell = row.getCell(j);
                if (cell != null && (cellLines = this.getNumWrappedLines(cell)) > maxNumLines) {
                    maxNumLines = cellLines;
                }
                ++j;
            }
            if (maxNumLines > 10) {
                maxNumLines = 10;
            }
            if (maxNumLines > 1) {
                row.setHeight((short)(this.sheet.getDefaultRowHeight() * maxNumLines));
            }
            ++i;
        }
    }

    private int getNumWrappedLines(Cell cell) {
        if (cell.getCellType() == CellType.STRING) {
            String val = cell.getStringCellValue();
            if (val == null || val.isEmpty()) {
                return 1;
            }
            CellStyle style = cell.getCellStyle();
            if (style == null || !style.getWrapText()) {
                return 1;
            }
            org.apache.poi.ss.usermodel.Font font = this.sheet.getWorkbook().getFontAt(style.getFontIndex());
            AttributedString astr = new AttributedString(val);
            Font awtFont = new Font(font.getFontName(), 0, font.getFontHeightInPoints());
            float cellWidth = (float)this.sheet.getColumnWidth(cell.getColumnIndex()) / 256.0f * 5.5f;
            astr.addAttribute(TextAttribute.FONT, awtFont);
            FontRenderContext context = new FontRenderContext(null, true, true);
            LineBreakMeasurer measurer = new LineBreakMeasurer(astr.getIterator(), context);
            int pos = 0;
            int numLines = 0;
            while (measurer.getPosition() < val.length()) {
                pos = measurer.nextOffset(cellWidth);
                ++numLines;
                measurer.setPosition(pos);
            }
            return numLines;
        }
        return 1;
    }
}

