/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ExtractedLicenseInfo;
import org.spdx.tools.compare.AbstractSheet;
import org.spdx.utility.compare.LicenseCompareHelper;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class ExtractedLicenseSheet
extends AbstractSheet {
    ExtractedLicenseComparator extractedLicenseComparator = new ExtractedLicenseComparator();
    private static final int EXTRACTED_TEXT_COL = 0;
    private static final int EXTRACTED_TEXT_WIDTH = 100;
    private static final String EXTRACTED_TEXT_TITLE = "Extracted License Text";
    private static final int LIC_ID_COL_WIDTH = 20;
    private static final int FIRST_LIC_ID_COL = 1;

    public ExtractedLicenseSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        sheet.setColumnWidth(0, 25600);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell extractedHeaderCell = row.createCell(0);
        extractedHeaderCell.setCellStyle(headerStyle);
        extractedHeaderCell.setCellValue(EXTRACTED_TEXT_TITLE);
        int i = 1;
        while (i < 25) {
            sheet.setColumnWidth(i, 5120);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            ++i;
        }
    }

    public void importCompareResults(SpdxComparer comparer, List<String> docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.size()) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int[] licenseIndexes = new int[comparer.getNumSpdxDocs()];
        AnyLicenseInfo[][] extractedLicenses = new AnyLicenseInfo[comparer.getNumSpdxDocs()][];
        int i = 0;
        while (i < extractedLicenses.length) {
            Cell headerCell = header.getCell(1 + i);
            headerCell.setCellValue(docNames.get(i));
            AnyLicenseInfo[] docExtractedLicenses = comparer.getSpdxDoc(i).getExtractedLicenseInfos().toArray(new AnyLicenseInfo[comparer.getSpdxDoc(i).getExtractedLicenseInfos().size()]);
            Arrays.sort(docExtractedLicenses, this.extractedLicenseComparator);
            extractedLicenses[i] = docExtractedLicenses;
            licenseIndexes[i] = 0;
            ++i;
        }
        while (!this.allLicensesExhausted(extractedLicenses, licenseIndexes)) {
            Row currentRow = this.addRow();
            String extractedLicenseText = this.getNextExtractedLicenseText(extractedLicenses, licenseIndexes);
            Cell licenseTextCell = currentRow.createCell(0);
            licenseTextCell.setCellValue(extractedLicenseText);
            int i2 = 0;
            while (i2 < extractedLicenses.length) {
                if (extractedLicenses[i2].length > licenseIndexes[i2]) {
                    if (extractedLicenses[i2][licenseIndexes[i2]] instanceof ExtractedLicenseInfo) {
                        String compareExtractedText = ((ExtractedLicenseInfo)extractedLicenses[i2][licenseIndexes[i2]]).getExtractedText();
                        if (LicenseCompareHelper.isLicenseTextEquivalent((String)extractedLicenseText, (String)compareExtractedText)) {
                            Cell licenseIdCell = currentRow.createCell(1 + i2);
                            licenseIdCell.setCellValue(this.formatLicenseInfo((ExtractedLicenseInfo)extractedLicenses[i2][licenseIndexes[i2]]));
                            int n = i2;
                            licenseIndexes[n] = licenseIndexes[n] + 1;
                        }
                    } else {
                        int n = i2;
                        licenseIndexes[n] = licenseIndexes[n] + 1;
                    }
                }
                ++i2;
            }
        }
    }

    private String formatLicenseInfo(ExtractedLicenseInfo license) throws InvalidSPDXAnalysisException {
        StringBuilder sb = new StringBuilder(license.getLicenseId());
        if (license.getName() != null && !license.getName().isEmpty()) {
            sb.append("[");
            sb.append(license.getName());
            sb.append("]");
        }
        if (license.getSeeAlso() != null && license.getSeeAlso().size() > 0) {
            sb.append("{");
            Iterator iter = license.getSeeAlso().iterator();
            sb.append((String)iter.next());
            while (iter.hasNext()) {
                sb.append(", ");
                sb.append((String)iter.next());
            }
            sb.append("}");
        }
        if (license.getComment() != null && !license.getComment().isEmpty()) {
            sb.append("(");
            sb.append(license.getComment());
            sb.append(")");
        }
        return sb.toString();
    }

    private String getNextExtractedLicenseText(AnyLicenseInfo[][] licenseInfos, int[] licenseIndexes) throws InvalidSPDXAnalysisException {
        String retval = null;
        int i = 0;
        while (i < licenseInfos.length) {
            if (licenseInfos[i].length > licenseIndexes[i]) {
                AnyLicenseInfo licenseInfo = licenseInfos[i][licenseIndexes[i]];
                String extractedText = "";
                if (licenseInfo instanceof ExtractedLicenseInfo && (extractedText = ((ExtractedLicenseInfo)licenseInfo).getExtractedText()) == null) {
                    extractedText = "";
                }
                if (retval == null || retval.compareTo(extractedText) > 0) {
                    retval = extractedText;
                }
            }
            ++i;
        }
        return retval;
    }

    private boolean allLicensesExhausted(AnyLicenseInfo[][] licenseInfos, int[] licenseIndexes) {
        int i = 0;
        while (i < licenseInfos.length) {
            if (licenseIndexes[i] < licenseInfos[i].length) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final class ExtractedLicenseComparator
    implements Comparator<AnyLicenseInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ExtractedLicenseComparator() {
        }

        @Override
        public int compare(AnyLicenseInfo o1, AnyLicenseInfo o2) {
            if (o1 instanceof ExtractedLicenseInfo) {
                if (o2 instanceof ExtractedLicenseInfo) {
                    String extracted2;
                    String extracted1;
                    block9: {
                        block8: {
                            block7: {
                                ExtractedLicenseInfo l1 = (ExtractedLicenseInfo)o1;
                                ExtractedLicenseInfo l2 = (ExtractedLicenseInfo)o2;
                                try {
                                    extracted1 = l1.getExtractedText();
                                    extracted2 = l2.getExtractedText();
                                    if (extracted1 != null || extracted2 != null) break block7;
                                    return 0;
                                }
                                catch (InvalidSPDXAnalysisException ex) {
                                    logger.error("Error comparing extracted license text", (Throwable)ex);
                                    throw new RuntimeException(ex);
                                }
                            }
                            if (extracted1 != null) break block8;
                            return -1;
                        }
                        if (extracted2 != null) break block9;
                        return 1;
                    }
                    return extracted1.compareTo(extracted2);
                }
                return 1;
            }
            return -1;
        }
    }
}

