/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.Collection;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.tools.compare.AbstractFileCompareSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class FileLicenseInfoSheet
extends AbstractFileCompareSheet {
    private static final int LICENSE_COL_WIDTH = 60;

    public FileLicenseInfoSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    String getFileValue(SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        if (spdxFile.getLicenseInfoFromFiles() == null || spdxFile.getLicenseInfoFromFiles().size() == 0) {
            return "";
        }
        Iterator iter = spdxFile.getLicenseInfoFromFiles().iterator();
        StringBuilder sb = new StringBuilder(((AnyLicenseInfo)iter.next()).toString());
        while (iter.hasNext()) {
            sb.append(", ");
            sb.append(((AnyLicenseInfo)iter.next()).toString());
        }
        return sb.toString();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Collection licenseInfosA = fileA.getLicenseInfoFromFiles();
        Collection licenseInfosB = fileB.getLicenseInfoFromFiles();
        if (licenseInfosA.size() != licenseInfosB.size()) {
            return false;
        }
        for (AnyLicenseInfo licA : licenseInfosA) {
            boolean found = false;
            for (AnyLicenseInfo licB : licenseInfosB) {
                if (!comparer.compareLicense(docIndexA, licA, docIndexB, licB)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

