/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.Arrays;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.enumerations.FileType;
import org.spdx.tools.compare.AbstractFileCompareSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class FileTypeSheet
extends AbstractFileCompareSheet {
    private static final int FILE_TYPE_COL_WIDTH = 20;

    public FileTypeSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 20);
    }

    @Override
    String getFileValue(SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        if (spdxFile.getFileTypes() == null || spdxFile.getFileTypes().size() == 0) {
            return "";
        }
        FileType[] fileTypes = spdxFile.getFileTypes().toArray(new FileType[spdxFile.getFileTypes().size()]);
        Object[] sFileTypes = new String[fileTypes.length];
        int i = 0;
        while (i < fileTypes.length) {
            sFileTypes[i] = fileTypes[i].toString();
            ++i;
        }
        Arrays.sort(sFileTypes);
        StringBuilder sb = new StringBuilder((String)sFileTypes[0]);
        int i2 = 1;
        while (i2 < sFileTypes.length) {
            sb.append(", ");
            sb.append((String)sFileTypes[i2]);
            ++i2;
        }
        return sb.toString();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException, InvalidSPDXAnalysisException {
        return SpdxComparer.stringsEqual((String)this.getFileValue(fileA), (String)this.getFileValue(fileB));
    }
}

