/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.ontology.Restriction;
import org.apache.jena.ontology.UnionClass;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.model.enumerations.SpdxEnumFactory;
import org.spdx.tools.schema.SchemaException;

public class AbstractOwlRdfConverter {
    static final Logger logger = LoggerFactory.getLogger(AbstractOwlRdfConverter.class);
    static final Set<String> SKIPPED_PROPERTIES;
    public static final Map<String, String> RENAMED_PROPERTY_TO_OWL_PROPERTY;
    public static final Map<String, String> OWL_PROPERTY_TO_RENAMED_PROPERTY;
    protected OntModel model;
    Property qualCardProperty;
    Property maxQualCardProperty;
    Property maxCardProperty;
    Property cardProperty;
    Property minCardProperty;
    Property minQualCardProperty;
    Property owlClassProperty;
    Property hasValueProperty;
    Property commentProperty;
    Property unionOfProperty;
    Property firstResource;
    Property restResource;
    Property intersectionOfProperty;
    Ontology ontology;

    static {
        HashSet<String> skipped = new HashSet<String>();
        skipped.add("http://www.w3.org/2003/06/sw-vocab-status/ns#term_status");
        skipped.add("http://www.w3.org/2002/07/owl#qualifiedCardinality");
        skipped.add("http://www.w3.org/2002/07/owl#deprecatedProperty");
        skipped.add("http://www.w3.org/2002/07/owl#deprecatedClass");
        skipped.add("http://spdx.org/rdf/terms#describesPackage");
        SKIPPED_PROPERTIES = Collections.unmodifiableSet(skipped);
        HashMap<String, String> renamedToOwl = new HashMap<String, String>();
        HashMap<String, String> owlToRenamed = new HashMap<String, String>();
        renamedToOwl.put("spdxVersion", "specVersion");
        owlToRenamed.put("specVersion", "spdxVersion");
        RENAMED_PROPERTY_TO_OWL_PROPERTY = Collections.unmodifiableMap(renamedToOwl);
        OWL_PROPERTY_TO_RENAMED_PROPERTY = Collections.unmodifiableMap(owlToRenamed);
    }

    public AbstractOwlRdfConverter(OntModel model) {
        Objects.requireNonNull(model, "Model must not be null");
        this.model = model;
        this.qualCardProperty = model.createProperty("http://www.w3.org/2002/07/owl#qualifiedCardinality");
        this.maxQualCardProperty = model.createProperty("http://www.w3.org/2002/07/owl#maxQualifiedCardinality");
        this.maxCardProperty = model.createProperty("http://www.w3.org/2002/07/owl#maxCardinality");
        this.cardProperty = model.createProperty("http://www.w3.org/2002/07/owl#cardinality");
        this.minCardProperty = model.createProperty("http://www.w3.org/2002/07/owl#minCardinality");
        this.minQualCardProperty = model.createProperty("http://www.w3.org/2002/07/owl#minQualifiedCardinality");
        this.owlClassProperty = model.createProperty("http://www.w3.org/2002/07/owl#onClass");
        this.hasValueProperty = model.createProperty("http://www.w3.org/2002/07/owl#hasValue");
        this.commentProperty = model.createProperty("http://www.w3.org/2000/01/rdf-schema#comment");
        this.unionOfProperty = model.createProperty("http://www.w3.org/2002/07/owl#unionOf");
        this.intersectionOfProperty = model.createProperty("http://www.w3.org/2002/07/owl#intersectionOf");
        this.firstResource = model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        this.restResource = model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        this.ontology = null;
        ExtendedIterator ontIter = model.listOntologies();
        if (!ontIter.hasNext()) {
            throw new RuntimeException("No ontologies defined in RDF OWL");
        }
        this.ontology = (Ontology)ontIter.next();
        if (ontIter.hasNext()) {
            throw new RuntimeException("No ontologies defined in RDF OWL");
        }
    }

    public PropertyRestrictions getPropertyRestrictions(OntClass ontClass, OntProperty property) {
        return new PropertyRestrictions(ontClass, property);
    }

    public static String checkConvertRenamedPropertyName(String owlPropertyName) {
        if (OWL_PROPERTY_TO_RENAMED_PROPERTY.containsKey(owlPropertyName)) {
            return OWL_PROPERTY_TO_RENAMED_PROPERTY.get(owlPropertyName);
        }
        return owlPropertyName;
    }

    protected Collection<OntProperty> propertiesFromClassRestrictions(OntClass oClass, boolean excludeSuperClassProperties) {
        HashSet<OntProperty> properties = new HashSet<OntProperty>();
        HashSet<OntClass> reviewedClasses = new HashSet<OntClass>();
        this.collectPropertiesFromRestrictions(oClass, properties, reviewedClasses, excludeSuperClassProperties);
        this.removeSuperProperties(properties);
        ArrayList<OntProperty> sorted = new ArrayList<OntProperty>(properties);
        Collections.sort(sorted, new Comparator<OntProperty>(){

            @Override
            public int compare(OntProperty arg0, OntProperty arg1) {
                return arg0.getLocalName().compareToIgnoreCase(arg1.getLocalName());
            }
        });
        return sorted;
    }

    private void removeSuperProperties(Collection<OntProperty> properties) {
        ArrayList<OntProperty> superProperties = new ArrayList<OntProperty>();
        for (OntProperty property : properties) {
            if (!property.isProperty()) continue;
            OntProperty op = property.asProperty();
            ExtendedIterator superIter = op.listSuperProperties();
            while (superIter.hasNext()) {
                superProperties.add((OntProperty)superIter.next());
            }
        }
        for (OntProperty superProp : superProperties) {
            if (!properties.contains(superProp)) continue;
            properties.remove(superProp);
        }
    }

    protected Collection<OntProperty> propertiesFromClassRestrictions(OntClass oClass) {
        return this.propertiesFromClassRestrictions(oClass, false);
    }

    protected Optional<Resource> getPropertyType(OntProperty property) throws SchemaException {
        ExtendedIterator rangeIter = property.listRange();
        while (rangeIter.hasNext()) {
            Resource intersectionOf;
            Resource unionOf;
            Optional<Resource> retval;
            OntResource range = (OntResource)rangeIter.next();
            if (range.isURIResource()) {
                return Optional.of(range);
            }
            if (!(range.hasProperty(this.unionOfProperty) ? (retval = this.findTypeInCollection((unionOf = range.getPropertyResourceValue(this.unionOfProperty)).getPropertyResourceValue(this.firstResource), unionOf.getPropertyResourceValue(this.restResource))).isPresent() : range.hasProperty(this.intersectionOfProperty) && (retval = this.findTypeInCollection((intersectionOf = range.getPropertyResourceValue(this.intersectionOfProperty)).getPropertyResourceValue(this.firstResource), intersectionOf.getPropertyResourceValue(this.restResource))).isPresent())) continue;
            return retval;
        }
        return Optional.empty();
    }

    private Optional<Resource> findTypeInCollection(Resource first, Resource rest) {
        if (Objects.nonNull(first) && first.isURIResource()) {
            return Optional.of(first);
        }
        if (Objects.isNull(rest) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil".equals(rest.getURI())) {
            return Optional.empty();
        }
        return this.findTypeInCollection(rest.getPropertyResourceValue(this.firstResource), rest.getPropertyResourceValue(this.restResource));
    }

    private void collectPropertiesFromRestrictions(OntClass oClass, Collection<OntProperty> properties, Collection<OntClass> reviewedClasses, boolean excludeSuperClassProperties) {
        block5: {
            block6: {
                block4: {
                    if (reviewedClasses.contains(oClass)) {
                        return;
                    }
                    reviewedClasses.add(oClass);
                    if (!oClass.isUnionClass()) break block4;
                    UnionClass uClass = oClass.asUnionClass();
                    ExtendedIterator unionClassiter = uClass.listOperands();
                    while (unionClassiter.hasNext()) {
                        this.collectPropertiesFromRestrictions((OntClass)unionClassiter.next(), properties, reviewedClasses, excludeSuperClassProperties);
                    }
                    break block5;
                }
                if (!oClass.isRestriction()) break block6;
                Restriction r = oClass.asRestriction();
                OntProperty property = r.getOnProperty();
                if (!Objects.nonNull(property)) break block5;
                properties.add(property);
                break block5;
            }
            ExtendedIterator subClassIter = oClass.listSuperClasses(excludeSuperClassProperties);
            if (excludeSuperClassProperties) {
                subClassIter = subClassIter.filterDrop(sc -> sc.isURIResource() && !"http://www.w3.org/2000/01/rdf-schema#Container".equals(sc.getURI()));
            }
            while (subClassIter.hasNext()) {
                this.collectPropertiesFromRestrictions((OntClass)subClassIter.next(), properties, reviewedClasses, excludeSuperClassProperties);
            }
        }
    }

    class PropertyRestrictions {
        private OntProperty property;
        private boolean listProperty = false;
        private boolean singleProperty = false;
        private String typeUri = null;
        private int absoluteCardinality = -1;
        private int minCardinality = -1;
        private int maxCardinality = -1;
        private boolean optional = true;
        private boolean enumProperty = false;
        Set<String> enumValues = new HashSet<String>();

        public PropertyRestrictions(OntClass ontClass, OntProperty property) {
            Objects.requireNonNull(ontClass, "Missing required ontology class");
            Objects.requireNonNull(property, "Missing required property");
            this.property = property;
            List<Restriction> restrictions = this.getRestrictionsFromSuperclasses(ontClass, property);
            this.interpretRestrictions(restrictions);
        }

        private void interpretRestrictions(List<Restriction> restrictions) {
            for (Restriction r : restrictions) {
                RDFNode typePropertyValue = r.getPropertyValue(AbstractOwlRdfConverter.this.owlClassProperty);
                if (Objects.nonNull(typePropertyValue) && typePropertyValue.isURIResource()) {
                    this.typeUri = typePropertyValue.asResource().getURI();
                    OntClass typeClass = AbstractOwlRdfConverter.this.model.getOntClass(this.typeUri);
                    if (Objects.nonNull(typeClass)) {
                        ExtendedIterator individualIter = AbstractOwlRdfConverter.this.model.listIndividuals((Resource)typeClass);
                        while (individualIter.hasNext()) {
                            Individual individual = (Individual)individualIter.next();
                            if (!individual.isURIResource()) continue;
                            Enum e = (Enum)SpdxEnumFactory.uriToEnum.get(individual.getURI());
                            if (Objects.nonNull(e)) {
                                this.enumValues.add(e.toString());
                                this.enumProperty = true;
                                continue;
                            }
                            logger.warn("Missing enum value for " + individual.getLocalName());
                        }
                    }
                } else {
                    NodeIterator hasValueIter = r.listPropertyValues(AbstractOwlRdfConverter.this.hasValueProperty);
                    while (hasValueIter.hasNext()) {
                        Enum e;
                        RDFNode hasValue = hasValueIter.next();
                        if (!hasValue.isURIResource() || !Objects.nonNull(e = (Enum)SpdxEnumFactory.uriToEnum.get(hasValue.asResource().getURI()))) continue;
                        this.enumValues.add(e.toString());
                        this.enumProperty = true;
                    }
                }
                RDFNode qualCardPropValue = r.getPropertyValue(AbstractOwlRdfConverter.this.qualCardProperty);
                RDFNode cardPropValue = r.getPropertyValue(AbstractOwlRdfConverter.this.cardProperty);
                RDFNode maxQualCardPropValue = r.getPropertyValue(AbstractOwlRdfConverter.this.maxQualCardProperty);
                RDFNode maxCardPropValue = r.getPropertyValue(AbstractOwlRdfConverter.this.maxCardProperty);
                RDFNode minCardPropValue = r.getPropertyValue(AbstractOwlRdfConverter.this.minCardProperty);
                RDFNode minQualCardPropValue = r.getPropertyValue(AbstractOwlRdfConverter.this.minQualCardProperty);
                if (Objects.nonNull(qualCardPropValue) && qualCardPropValue.isLiteral()) {
                    this.absoluteCardinality = qualCardPropValue.asLiteral().getInt();
                    if (this.absoluteCardinality > 0) {
                        this.optional = false;
                    }
                    if (this.absoluteCardinality > 1) {
                        this.listProperty = true;
                        continue;
                    }
                    this.singleProperty = true;
                    continue;
                }
                if (Objects.nonNull(cardPropValue) && cardPropValue.isLiteral()) {
                    this.absoluteCardinality = cardPropValue.asLiteral().getInt();
                    if (this.absoluteCardinality > 0) {
                        this.optional = false;
                    }
                    if (this.absoluteCardinality > 1) {
                        this.listProperty = true;
                        continue;
                    }
                    this.singleProperty = true;
                    continue;
                }
                if (Objects.nonNull(maxQualCardPropValue) && maxQualCardPropValue.isLiteral()) {
                    this.maxCardinality = maxQualCardPropValue.asLiteral().getInt();
                    if (this.maxCardinality > 1) {
                        this.listProperty = true;
                        continue;
                    }
                    if (this.maxCardinality != 1) continue;
                    this.singleProperty = true;
                    continue;
                }
                if (Objects.nonNull(maxCardPropValue) && maxCardPropValue.isLiteral()) {
                    this.maxCardinality = maxCardPropValue.asLiteral().getInt();
                    if (this.maxCardinality > 1) {
                        this.listProperty = true;
                        continue;
                    }
                    if (this.maxCardinality != 1) continue;
                    this.singleProperty = true;
                    continue;
                }
                if (Objects.nonNull(minCardPropValue) && minCardPropValue.isLiteral()) {
                    this.minCardinality = minCardPropValue.asLiteral().getInt();
                    if (this.minCardinality > 0) {
                        this.optional = false;
                    }
                    this.listProperty = true;
                    continue;
                }
                if (!Objects.nonNull(minQualCardPropValue) || !minQualCardPropValue.isLiteral()) continue;
                this.minCardinality = minQualCardPropValue.asLiteral().getInt();
                if (this.minCardinality > 0) {
                    this.optional = false;
                }
                this.listProperty = true;
            }
            if (Objects.isNull(this.typeUri)) {
                ExtendedIterator rangeIter = this.property.listRange();
                while (rangeIter.hasNext()) {
                    OntResource range = (OntResource)rangeIter.next();
                    if (!range.isURIResource() || !Objects.isNull(this.typeUri) && !this.typeUri.equals("http://www.w3.org/2000/01/rdf-schema#Literal")) continue;
                    this.typeUri = range.asResource().getURI();
                }
            }
            if (Objects.isNull(this.typeUri) && ("comment".equals(this.property.getLocalName()) || "seeAlso".equals(this.property.getLocalName()))) {
                this.typeUri = "http://www.w3.org/2001/XMLSchema#string";
            }
        }

        private List<Restriction> getRestrictionsFromSuperclasses(OntClass ontClass, OntProperty property) {
            ArrayList<Restriction> retval = new ArrayList<Restriction>();
            ExtendedIterator superClasses = ontClass.listSuperClasses();
            while (superClasses.hasNext()) {
                OntClass superClass = (OntClass)superClasses.next();
                if (superClass.isUnionClass()) {
                    UnionClass uClass = superClass.asUnionClass();
                    ExtendedIterator unionClassiter = uClass.listOperands();
                    while (unionClassiter.hasNext()) {
                        OntClass operand = (OntClass)unionClassiter.next();
                        if (!operand.isRestriction() || !property.equals((Object)operand.asRestriction().getOnProperty())) continue;
                        retval.add(operand.asRestriction());
                    }
                    continue;
                }
                if (superClass.isRestriction()) {
                    if (!property.equals((Object)superClass.asRestriction().getOnProperty())) continue;
                    retval.add(superClass.asRestriction());
                    continue;
                }
                retval.addAll(this.getRestrictionsFromSuperclasses(superClass, property));
            }
            return retval;
        }

        public PropertyRestrictions(OntProperty property) {
            Objects.requireNonNull(property, "Missing required property");
            this.property = property;
            ArrayList<Restriction> propertyRestrictions = new ArrayList<Restriction>();
            ExtendedIterator restrictionIter = property.listReferringRestrictions();
            while (restrictionIter.hasNext()) {
                propertyRestrictions.add((Restriction)restrictionIter.next());
            }
            this.interpretRestrictions(propertyRestrictions);
        }

        public OntProperty getProperty() {
            return this.property;
        }

        public boolean isListProperty() {
            return this.listProperty;
        }

        public String getTypeUri() {
            return this.typeUri;
        }

        public int getAbsoluteCardinality() {
            return this.absoluteCardinality;
        }

        public int getMinCardinality() {
            return this.minCardinality;
        }

        public int getMaxCardinality() {
            return this.maxCardinality;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isEnumProperty() {
            return this.enumProperty;
        }

        public Set<String> getEnumValues() {
            return this.enumValues;
        }

        public boolean isSingleProperty() {
            return this.singleProperty;
        }
    }
}

