/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.jacksonstore.SpdxJsonLDContext;
import org.spdx.library.model.ReferenceType;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.tools.schema.AbstractOwlRdfConverter;

public class OwlToJsonSchema
extends AbstractOwlRdfConverter {
    private static final String JSON_TYPE_STRING = "string";
    private static final String JSON_TYPE_BOOLEAN = "boolean";
    private static final String JSON_TYPE_INTEGER = "integer";
    private static final String JSON_TYPE_OBJECT = "object";
    private static final String JSON_TYPE_ARRAY = "array";
    private static final String JSON_RESTRICTION_TYPE = "type";
    private static final String JSON_RESTRICTION_ITEMS = "items";
    private static final String JSON_RESTRICTION_MIN_ITEMS = "minItems";
    private static final String JSON_RESTRICTION_MAXITEMS = "maxItems";
    private static final String SCHEMA_VERSION_URI = "http://json-schema.org/draft-07/schema#";
    private static final String RELATIONSHIP_TYPE = "http://spdx.org/rdf/terms#Relationship";
    static ObjectMapper jsonMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final Set<String> USES_SPDXIDS;
    static final String SINGLE_POINTER_URI = "http://www.w3.org/2009/pointers#SinglePointer";

    static {
        HashSet<String> spdxids = new HashSet<String>();
        spdxids.add("SpdxDocument");
        spdxids.add("SpdxElement");
        spdxids.add("File");
        spdxids.add("SpdxItem");
        spdxids.add("Package");
        spdxids.add("Snippet");
        USES_SPDXIDS = Collections.unmodifiableSet(spdxids);
    }

    public OwlToJsonSchema(OntModel model) {
        super(model);
    }

    public ObjectNode convertToJsonSchema() {
        Ontology ont;
        ObjectNode root = jsonMapper.createObjectNode();
        root.put("$schema", SCHEMA_VERSION_URI);
        ExtendedIterator ontologyIter = this.model.listOntologies();
        if (ontologyIter.hasNext() && (ont = (Ontology)ontologyIter.next()).isURIResource()) {
            String title;
            String ontologyUri;
            String version = ont.getVersionInfo();
            String string = ontologyUri = version == null ? ont.getURI() : String.valueOf(ont.getURI()) + "/" + version;
            if (Objects.nonNull(ontologyUri)) {
                root.put("$id", ontologyUri);
            }
            if (Objects.nonNull(title = ont.getLabel(null))) {
                root.put("title", title);
            }
        }
        root.put(JSON_RESTRICTION_TYPE, JSON_TYPE_OBJECT);
        ObjectNode properties = jsonMapper.createObjectNode();
        ArrayNode required = jsonMapper.createArrayNode();
        OntClass docClass = this.model.getOntClass("http://spdx.org/rdf/terms#SpdxDocument");
        Objects.requireNonNull(docClass, "Missing SpdxDocument class in OWL document");
        this.addClassProperties(docClass, properties, required);
        properties.set("documentNamespace", (JsonNode)this.createSimpleTypeSchema(JSON_TYPE_STRING, "The URI provides an unambiguous mechanism for other SPDX documents to reference SPDX elements within this SPDX document."));
        required.add("documentNamespace");
        properties.set("documentDescribes", this.toArraySchema(this.createSimpleTypeSchema(JSON_TYPE_STRING, "SPDX ID for each Package, File, or Snippet."), "Packages, files and/or Snippets described by this SPDX document", 0));
        OntClass packageClass = this.model.getOntClass("http://spdx.org/rdf/terms#Package");
        Objects.requireNonNull(packageClass, "Missing SPDX Package class in OWL document");
        properties.set("packages", this.toArrayPropertySchema(packageClass, 0));
        OntClass fileClass = this.model.getOntClass("http://spdx.org/rdf/terms#File");
        Objects.requireNonNull(fileClass, "Missing SPDX File class in OWL document");
        properties.set("files", this.toArrayPropertySchema(fileClass, 0));
        OntClass snippetClass = this.model.getOntClass("http://spdx.org/rdf/terms#Snippet");
        Objects.requireNonNull(snippetClass, "Missing SPDX Snippet class in OWL document");
        properties.set("snippets", this.toArrayPropertySchema(snippetClass, 0));
        OntClass relationshipClass = this.model.getOntClass(RELATIONSHIP_TYPE);
        Objects.requireNonNull(relationshipClass, "Missing SPDX Relationship class in OWL document");
        properties.set("relationships", this.toArrayPropertySchema(relationshipClass, 0));
        root.set("properties", (JsonNode)properties);
        root.set("required", (JsonNode)required);
        root.put("additionalProperties", false);
        return root;
    }

    private JsonNode toArrayPropertySchema(OntClass ontClass, int min) {
        return this.toArraySchema(this.ontClassToJsonSchema(ontClass), String.valueOf(OwlToJsonSchema.checkConvertRenamedPropertyName(ontClass.getLocalName())) + "s referenced in the SPDX document", min);
    }

    private JsonNode toArraySchema(ObjectNode itemSchema, String description, int min) {
        ObjectNode property = jsonMapper.createObjectNode();
        property.put("description", description);
        property.put(JSON_RESTRICTION_TYPE, JSON_TYPE_ARRAY);
        property.set(JSON_RESTRICTION_ITEMS, (JsonNode)itemSchema);
        if (min > 0) {
            property.put(JSON_RESTRICTION_MIN_ITEMS, min);
        }
        return property;
    }

    private ObjectNode ontClassToJsonSchema(OntClass ontClass) {
        ObjectNode retval = jsonMapper.createObjectNode();
        retval.put(JSON_RESTRICTION_TYPE, JSON_TYPE_OBJECT);
        ObjectNode properties = jsonMapper.createObjectNode();
        ArrayNode required = jsonMapper.createArrayNode();
        if (ontClass.getLocalName().equals("Relationship")) {
            properties.set("spdxElementId", (JsonNode)this.createSimpleTypeSchema(JSON_TYPE_STRING, "Id to which the SPDX element is related"));
            required.add("spdxElementId");
        }
        this.addClassProperties(ontClass, properties, required);
        if (properties.size() > 0) {
            retval.set("properties", (JsonNode)properties);
            if (required.size() > 0) {
                retval.set("required", (JsonNode)required);
            }
            retval.put("additionalProperties", false);
        }
        return retval;
    }

    private ObjectNode createSimpleTypeSchema(String type, @Nullable String description) {
        Objects.requireNonNull(type, "Type can not be null");
        ObjectNode retval = jsonMapper.createObjectNode();
        retval.put(JSON_RESTRICTION_TYPE, type);
        if (Objects.nonNull(description) && !description.isEmpty()) {
            retval.put("description", description);
        }
        return retval;
    }

    private void addClassProperties(OntClass spdxClass, ObjectNode jsonSchemaProperties, ArrayNode required) {
        if (USES_SPDXIDS.contains(spdxClass.getLocalName())) {
            required.add("SPDXID");
            jsonSchemaProperties.set("SPDXID", (JsonNode)this.createSimpleTypeSchema(JSON_TYPE_STRING, "Uniquely identify any element in an SPDX document which may be referenced by other elements."));
        }
        Collection<OntProperty> ontProperties = this.propertiesFromClassRestrictions(spdxClass);
        for (OntProperty property : ontProperties) {
            if (SKIPPED_PROPERTIES.contains(property.getURI())) continue;
            AbstractOwlRdfConverter.PropertyRestrictions restrictions = this.getPropertyRestrictions(spdxClass, property);
            Objects.requireNonNull(restrictions.getTypeUri(), "Missing type for property " + property.getLocalName());
            if (restrictions.getTypeUri().equals(RELATIONSHIP_TYPE)) continue;
            if (restrictions.isListProperty()) {
                jsonSchemaProperties.set(MultiFormatStore.propertyNameToCollectionPropertyName((String)OwlToJsonSchema.checkConvertRenamedPropertyName(property.getLocalName())), (JsonNode)this.deriveListPropertySchema(property, restrictions));
                if (restrictions.isOptional() && restrictions.getMinCardinality() <= 0) continue;
                required.add(MultiFormatStore.propertyNameToCollectionPropertyName((String)OwlToJsonSchema.checkConvertRenamedPropertyName(property.getLocalName())));
                continue;
            }
            jsonSchemaProperties.set(OwlToJsonSchema.checkConvertRenamedPropertyName(property.getLocalName()), (JsonNode)this.derivePropertySchema(property, restrictions));
            if (restrictions.isOptional()) continue;
            required.add(OwlToJsonSchema.checkConvertRenamedPropertyName(property.getLocalName()));
        }
    }

    private ObjectNode deriveListPropertySchema(OntProperty property, AbstractOwlRdfConverter.PropertyRestrictions restrictions) {
        ObjectNode propertySchema = jsonMapper.createObjectNode();
        Statement commentStatement = property.getProperty(this.commentProperty);
        if (Objects.nonNull(commentStatement) && Objects.nonNull(commentStatement.getObject()) && commentStatement.getObject().isLiteral()) {
            propertySchema.put("description", commentStatement.getObject().asLiteral().getString());
        }
        this.addCardinalityRestrictions(propertySchema, restrictions);
        propertySchema.put(JSON_RESTRICTION_TYPE, JSON_TYPE_ARRAY);
        propertySchema.set(JSON_RESTRICTION_ITEMS, (JsonNode)this.derivePropertySchema(property, restrictions));
        return propertySchema;
    }

    private void addCardinalityRestrictions(ObjectNode propertySchema, AbstractOwlRdfConverter.PropertyRestrictions restrictions) {
        if (restrictions.getAbsoluteCardinality() > 0) {
            propertySchema.put(JSON_RESTRICTION_MIN_ITEMS, restrictions.getAbsoluteCardinality());
            propertySchema.put(JSON_RESTRICTION_MAXITEMS, restrictions.getAbsoluteCardinality());
        } else {
            if (restrictions.getMinCardinality() > 0) {
                propertySchema.put(JSON_RESTRICTION_MIN_ITEMS, restrictions.getMinCardinality());
            }
            if (restrictions.getMaxCardinality() > 0) {
                propertySchema.put(JSON_RESTRICTION_MAXITEMS, restrictions.getMaxCardinality());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ObjectNode derivePropertySchema(OntProperty property, AbstractOwlRdfConverter.PropertyRestrictions restrictions) {
        ObjectNode propertySchema = jsonMapper.createObjectNode();
        Statement commentStatement = property.getProperty(this.commentProperty);
        if (Objects.nonNull(commentStatement) && Objects.nonNull(commentStatement.getObject()) && commentStatement.getObject().isLiteral()) {
            propertySchema.put("description", commentStatement.getObject().asLiteral().getString());
        }
        if (restrictions.isEnumProperty()) {
            propertySchema.put(JSON_RESTRICTION_TYPE, JSON_TYPE_STRING);
            ArrayNode enums = jsonMapper.createArrayNode();
            for (String val : restrictions.getEnumValues()) {
                if (property.getLocalName().equals("algorithm")) {
                    enums.add(val.replaceAll("_", "-"));
                    continue;
                }
                if (property.getLocalName().equals("referenceCategory")) {
                    if (val.contains("_")) {
                        enums.add(val.replaceAll("_", "-"));
                    }
                    enums.add(val);
                    continue;
                }
                enums.add(val);
            }
            propertySchema.set("enum", (JsonNode)enums);
            return propertySchema;
        } else if (restrictions.getTypeUri().equals("http://www.w3.org/2000/01/rdf-schema#Literal")) {
            propertySchema.put(JSON_RESTRICTION_TYPE, JSON_TYPE_STRING);
            return propertySchema;
        } else if (restrictions.getTypeUri().startsWith("http://www.w3.org/2001/XMLSchema#")) {
            String primitiveType = restrictions.getTypeUri().substring("http://www.w3.org/2001/XMLSchema#".length());
            Class primitiveClass = (Class)SpdxJsonLDContext.XMLSCHEMA_TYPE_TO_JAVA_CLASS.get(primitiveType);
            Objects.requireNonNull(primitiveClass, "No primitive class found for type " + restrictions.getTypeUri());
            if (Boolean.class.equals((Object)primitiveClass)) {
                propertySchema.put(JSON_RESTRICTION_TYPE, JSON_TYPE_BOOLEAN);
                return propertySchema;
            } else if (String.class.equals((Object)primitiveClass)) {
                propertySchema.put(JSON_RESTRICTION_TYPE, JSON_TYPE_STRING);
                return propertySchema;
            } else {
                if (!Integer.class.equals((Object)primitiveClass)) throw new RuntimeException("Unknown primitive class " + primitiveType);
                propertySchema.put(JSON_RESTRICTION_TYPE, JSON_TYPE_INTEGER);
            }
            return propertySchema;
        } else if (restrictions.getTypeUri().startsWith("http://spdx.org/rdf/terms#")) {
            String spdxType = restrictions.getTypeUri().substring("http://spdx.org/rdf/terms#".length());
            Class clazz = (Class)SpdxModelFactory.SPDX_TYPE_TO_CLASS.get(spdxType);
            if (Objects.nonNull(clazz) && AnyLicenseInfo.class.isAssignableFrom(clazz) && !"hasExtractedLicensingInfo".equals(OwlToJsonSchema.checkConvertRenamedPropertyName(property.getLocalName()))) {
                JsonNode description = propertySchema.get("description");
                if (Objects.isNull(description)) {
                    propertySchema.put("description", "License expression.  See SPDX Annex D for the license expression syntax.");
                } else {
                    propertySchema.put("description", "License expression for " + OwlToJsonSchema.checkConvertRenamedPropertyName(property.getLocalName()) + ". See SPDX Annex D for the license expression syntax.  " + description.asText());
                }
                propertySchema.put(JSON_RESTRICTION_TYPE, JSON_TYPE_STRING);
                return propertySchema;
            } else if (Objects.nonNull(clazz) && SpdxElement.class.isAssignableFrom(clazz)) {
                JsonNode description = propertySchema.get("description");
                if (Objects.isNull(description)) {
                    propertySchema.put("description", "SPDX ID for " + spdxType);
                } else {
                    propertySchema.put("description", "SPDX ID for " + spdxType + ".  " + description.asText());
                }
                propertySchema.put(JSON_RESTRICTION_TYPE, JSON_TYPE_STRING);
                return propertySchema;
            } else if (Objects.nonNull(clazz) && ReferenceType.class.isAssignableFrom(clazz)) {
                propertySchema.put(JSON_RESTRICTION_TYPE, JSON_TYPE_STRING);
                return propertySchema;
            } else {
                OntClass typeClass = this.model.getOntClass(restrictions.getTypeUri());
                Objects.requireNonNull(typeClass, "No type class found for " + restrictions.getTypeUri());
                propertySchema = this.ontClassToJsonSchema(typeClass);
                commentStatement = typeClass.getProperty(this.commentProperty);
                if (!Objects.nonNull(commentStatement) || !Objects.nonNull(commentStatement.getObject()) || !commentStatement.getObject().isLiteral()) return propertySchema;
                propertySchema.put("description", commentStatement.getObject().asLiteral().getString());
            }
            return propertySchema;
        } else {
            OntClass typeClass = this.model.getOntClass(restrictions.getTypeUri());
            commentStatement = typeClass.getProperty(this.commentProperty);
            if (Objects.nonNull(commentStatement) && Objects.nonNull(commentStatement.getObject()) && commentStatement.getObject().isLiteral()) {
                propertySchema.put("description", commentStatement.getObject().asLiteral().getString());
            }
            Objects.requireNonNull(typeClass, "No type class found for " + restrictions.getTypeUri());
            propertySchema = this.ontClassToJsonSchema(typeClass);
            if (!SINGLE_POINTER_URI.equals(restrictions.getTypeUri())) return propertySchema;
            ObjectNode properties = (ObjectNode)propertySchema.get("properties");
            if (!properties.has("offset")) {
                properties.set("offset", (JsonNode)this.createSimpleTypeSchema(JSON_TYPE_INTEGER, "Byte offset in the file"));
            }
            if (properties.has("lineNumber")) return propertySchema;
            properties.set("lineNumber", (JsonNode)this.createSimpleTypeSchema(JSON_TYPE_INTEGER, "line number offset in the file"));
        }
        return propertySchema;
    }
}

