/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class ExistingSpdxDocument {
    public static void main(String[] args) {
        File inputFile;
        if (args.length != 1) {
            ExistingSpdxDocument.usage();
            System.exit(1);
        }
        if (!(inputFile = new File(args[0])).exists()) {
            System.out.println("Input file does not exist: " + args[0]);
            System.exit(1);
        }
        MultiFormatStore modelStore = new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY);
        ModelCopyManager copyManager = new ModelCopyManager();
        String documentUri = null;
        try {
            Throwable throwable = null;
            Object var6_11 = null;
            try (FileInputStream stream = new FileInputStream(inputFile);){
                documentUri = modelStore.deSerialize((InputStream)stream, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e1) {
            System.out.println("Input file does not exist: " + args[0]);
            System.exit(1);
        }
        catch (IOException e1) {
            System.out.println("I/O error reading input file: " + args[0]);
            System.exit(1);
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.println("The SPDX document is not valid: " + e.getMessage());
            System.exit(1);
        }
        try {
            SpdxDocument document2;
            SpdxDocument document = new SpdxDocument((IModelStore)modelStore, documentUri, copyManager, false);
            Optional optionalDocument2 = SpdxModelFactory.getModelObject((IModelStore)modelStore, (String)documentUri, (String)"SPDXRef-DOCUMENT", (ModelCopyManager)copyManager);
            if (!optionalDocument2.isPresent()) {
                System.out.println("The SPDX document is not present in the model");
                System.exit(1);
            }
            if (!document.equivalent((ModelObject)(document2 = (SpdxDocument)optionalDocument2.get()))) {
                System.out.println("Oops - these 2 documents should be the same");
                System.exit(1);
            }
            Collection described = document.getDocumentDescribes();
            for (SpdxElement des : described) {
                System.out.println("The document described ID " + des.getId());
            }
            System.exit(0);
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.println("Unexpected error reading SPDX document: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: ExistingSpxDocument inputFilePath");
    }
}

