/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.List;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxFile;
import org.spdx.tools.compare.AbstractSheet;
import org.spdx.tools.compare.NormalizedFileNameComparator;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public abstract class AbstractFileCompareSheet
extends AbstractSheet {
    static final int FILENAME_COL_WIDTH = 80;
    static final int DIFF_COL_WIDTH = 10;
    static final int FILENAME_COL = 0;
    static final int DIFF_COL = 1;
    static final int FIRST_DOCUMENT_COL = 2;
    static final String FILENAME_TITLE = "File Path";
    static final String DIFF_TITLE = "Same/Diff";
    static final String DIFFERENT_VALUE = "Different";
    static final String EQUAL_VALUE = "Equal";
    static final String NO_FILE_VALUE = "[No File]";
    private static final int MAX_VALUE_LENGTH = 32000;
    private NormalizedFileNameComparator normalizedFileNameComparator = new NormalizedFileNameComparator();

    public AbstractFileCompareSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName, int columnWidth) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        sheet.setColumnWidth(0, 20480);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell fileNameHeadercell = row.createCell(0);
        fileNameHeadercell.setCellStyle(headerStyle);
        fileNameHeadercell.setCellValue(FILENAME_TITLE);
        sheet.setColumnWidth(1, 2560);
        sheet.setDefaultColumnStyle(1, defaultStyle);
        Cell diffHeaderCell = row.createCell(1);
        diffHeaderCell.setCellStyle(headerStyle);
        diffHeaderCell.setCellValue(DIFF_TITLE);
        int i = 2;
        while (i < 27) {
            sheet.setColumnWidth(i, columnWidth * 256);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            ++i;
        }
    }

    public void importCompareResults(SpdxComparer comparer, List<List<SpdxFile>> files, List<String> docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (docNames == null) {
            throw new SpdxCompareException("Document names can not be null");
        }
        if (files.size() != docNames.size()) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents being compared");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int i = 0;
        while (i < docNames.size()) {
            Cell headerCell = header.getCell(i + 2);
            headerCell.setCellValue(docNames.get(i));
            ++i;
        }
        int[] fileIndexes = new int[files.size()];
        int i2 = 0;
        while (i2 < fileIndexes.length) {
            fileIndexes[i2] = 0;
            ++i2;
        }
        while (!this.allFilesExhausted(files, fileIndexes)) {
            Row currentRow = this.addRow();
            Optional<String> fileName = this.getNextFileName(files, fileIndexes);
            Cell fileNameCell = currentRow.createCell(0);
            fileNameCell.setCellValue(NormalizedFileNameComparator.normalizeFileName(fileName));
            boolean allValuesMatch = true;
            SpdxFile lastFile = null;
            int lastDocIndex = 0;
            int i3 = 0;
            while (i3 < files.size()) {
                Cell cell = currentRow.createCell(i3 + 2);
                if (fileIndexes[i3] < files.get(i3).size() && this.normalizedFileNameComparator.compare(files.get(i3).get(fileIndexes[i3]).getName(), fileName) == 0) {
                    String val = this.getFileValue(files.get(i3).get(fileIndexes[i3]));
                    if (allValuesMatch && lastFile != null && !this.valuesMatch(comparer, lastFile, lastDocIndex, files.get(i3).get(fileIndexes[i3]), i3)) {
                        allValuesMatch = false;
                    }
                    lastFile = files.get(i3).get(fileIndexes[i3]);
                    if (val.length() > 32000) {
                        val = String.valueOf(val.substring(0, 31991)) + "[more...]";
                    }
                    cell.setCellValue(val);
                    int n = i3;
                    fileIndexes[n] = fileIndexes[n] + 1;
                } else {
                    cell.setCellValue(NO_FILE_VALUE);
                    allValuesMatch = false;
                }
                ++i3;
            }
            Cell diffCell = currentRow.createCell(1);
            if (allValuesMatch) {
                this.setCellAllEqual(diffCell);
                continue;
            }
            this.setCellDifference(diffCell);
        }
    }

    abstract boolean valuesMatch(SpdxComparer var1, SpdxFile var2, int var3, SpdxFile var4, int var5) throws SpdxCompareException, InvalidSPDXAnalysisException;

    private void setCellDifference(Cell cell) {
        cell.setCellValue(DIFFERENT_VALUE);
        cell.setCellStyle(this.yellowWrapped);
    }

    private void setCellAllEqual(Cell cell) {
        cell.setCellValue(EQUAL_VALUE);
        cell.setCellStyle(this.greenWrapped);
    }

    abstract String getFileValue(SpdxFile var1) throws InvalidSPDXAnalysisException;

    private Optional<String> getNextFileName(List<List<SpdxFile>> files, int[] fileIndexes) throws InvalidSPDXAnalysisException {
        Optional retval = Optional.empty();
        int i = 0;
        while (i < files.size()) {
            if (files.get(i).size() > fileIndexes[i]) {
                Optional fileName = files.get(i).get(fileIndexes[i]).getName();
                if (!retval.isPresent() || this.normalizedFileNameComparator.compare(retval, fileName) > 0) {
                    retval = fileName;
                }
            }
            ++i;
        }
        return retval;
    }

    private boolean allFilesExhausted(List<List<SpdxFile>> files, int[] fileIndexes) {
        int i = 0;
        while (i < fileIndexes.length) {
            if (fileIndexes[i] < files.get(i).size()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

