/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.enumerations.FileType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.referencetype.ListedReferenceTypes;

public class CompareHelper {
    static final int MAX_CHARACTERS_PER_CELL = 32000;

    private CompareHelper() {
    }

    public static String annotationToString(Annotation annotation) throws InvalidSPDXAnalysisException {
        if (annotation == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(annotation.getAnnotationDate());
        sb.append(" ");
        sb.append(annotation.getAnnotator());
        sb.append(": ");
        sb.append(annotation.getComment());
        sb.append("[");
        sb.append(annotation.getAnnotationType().toString());
        sb.append("]");
        return sb.toString();
    }

    public static String checksumsToString(Collection<Checksum> checksums) throws InvalidSPDXAnalysisException {
        if (checksums == null || checksums.size() == 0) {
            return "";
        }
        ArrayList<String> cksumString = new ArrayList<String>();
        for (Checksum checksum : checksums) {
            cksumString.add(CompareHelper.checksumToString(checksum));
        }
        Collections.sort(cksumString);
        StringBuilder sb = new StringBuilder((String)cksumString.get(0));
        int i = 1;
        while (i < cksumString.size()) {
            sb.append("\n");
            if (sb.length() + ((String)cksumString.get(i)).length() > 32000) {
                int numRemaing = cksumString.size() - i;
                sb.append('[');
                sb.append(numRemaing);
                sb.append(" more...]");
                break;
            }
            sb.append((String)cksumString.get(i));
            ++i;
        }
        return sb.toString();
    }

    public static String checksumToString(Checksum checksum) throws InvalidSPDXAnalysisException {
        if (checksum == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(checksum.getAlgorithm().toString());
        sb.append(' ');
        sb.append(checksum.getValue());
        return sb.toString();
    }

    public static String licenseInfosToString(Collection<AnyLicenseInfo> licenseInfos) {
        if (licenseInfos == null || licenseInfos.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<AnyLicenseInfo> iter = licenseInfos.iterator();
        sb.append(iter.next().toString());
        while (iter.hasNext()) {
            sb.append(", ");
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    public static String annotationsToString(Collection<Annotation> annotations) throws InvalidSPDXAnalysisException {
        if (annotations == null || annotations.size() == 0) {
            return "";
        }
        Iterator<Annotation> iter = annotations.iterator();
        StringBuilder sb = new StringBuilder(CompareHelper.annotationToString(iter.next()));
        int numRemaining = annotations.size() - 1;
        while (iter.hasNext()) {
            sb.append("\n");
            String annotation = CompareHelper.annotationToString(iter.next());
            --numRemaining;
            if (sb.length() + annotation.length() > 32000) {
                sb.append('[');
                sb.append(numRemaining);
                sb.append(" more...]");
                break;
            }
            sb.append(annotation);
        }
        return sb.toString();
    }

    public static String attributionsToString(Collection<String> attributions) {
        if (attributions == null || attributions.size() == 0) {
            return "";
        }
        Iterator<String> iter = attributions.iterator();
        StringBuilder sb = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            sb.append("\n");
            sb.append(iter.next());
        }
        return sb.toString();
    }

    public static String relationshipToString(Relationship relationship) throws InvalidSPDXAnalysisException {
        if (relationship == null) {
            return "";
        }
        if (relationship.getRelationshipType() == null) {
            return "Unknown relationship type";
        }
        StringBuilder sb = new StringBuilder(relationship.getRelationshipType().toString());
        sb.append(":");
        Optional relatedElement = relationship.getRelatedSpdxElement();
        if (!relatedElement.isPresent()) {
            sb.append("?NULL");
        } else {
            Optional relatedElementName = ((SpdxElement)relatedElement.get()).getName();
            if (relatedElementName.isPresent()) {
                sb.append('[');
                sb.append((String)relatedElementName.get());
                sb.append(']');
            }
            sb.append(((SpdxElement)relatedElement.get()).getId());
        }
        Optional comment = relationship.getComment();
        if (comment.isPresent() && !((String)comment.get()).isEmpty()) {
            sb.append('(');
            sb.append((String)comment.get());
            sb.append(')');
        }
        return sb.toString();
    }

    public static String relationshipsToString(Collection<Relationship> relationships) throws InvalidSPDXAnalysisException {
        if (relationships == null || relationships.size() == 0) {
            return "";
        }
        Iterator<Relationship> iter = relationships.iterator();
        StringBuilder sb = new StringBuilder(CompareHelper.relationshipToString(iter.next()));
        int numRemaining = relationships.size() - 1;
        while (iter.hasNext()) {
            sb.append("\n");
            String nextRelationship = CompareHelper.relationshipToString(iter.next());
            --numRemaining;
            if (sb.length() + nextRelationship.length() > 32000) {
                sb.append('[');
                sb.append(numRemaining);
                sb.append(" more...]");
                break;
            }
            sb.append(nextRelationship);
        }
        return sb.toString();
    }

    public static String formatSpdxElementList(Collection<SpdxElement> elements) throws InvalidSPDXAnalysisException {
        if (elements == null || elements.size() == 0) {
            return "";
        }
        Iterator<SpdxElement> iter = elements.iterator();
        StringBuilder sb = new StringBuilder(CompareHelper.formatElement(iter.next()));
        int numRemaining = elements.size() - 1;
        while (iter.hasNext()) {
            sb.append(", ");
            String nextElement = CompareHelper.formatElement(iter.next());
            --numRemaining;
            if (sb.length() + nextElement.length() > 32000) {
                sb.append('[');
                sb.append(numRemaining);
                sb.append(" more...]");
                break;
            }
            sb.append(nextElement);
        }
        return sb.toString();
    }

    private static String formatElement(SpdxElement element) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(element) || element.getId() == null || element.getId().isEmpty()) {
            return "[UNKNOWNID]";
        }
        StringBuilder sb = new StringBuilder(element.getId());
        Optional name = element.getName();
        if (name.isPresent()) {
            sb.append('(');
            sb.append((String)name.get());
            sb.append(')');
        }
        return sb.toString();
    }

    public static String fileTypesToString(FileType[] fileTypes) {
        if (fileTypes == null || fileTypes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(fileTypes[0].toString());
        int i = 1;
        while (i < fileTypes.length) {
            sb.append(", ");
            String fileType = fileTypes[i].toString();
            if (sb.length() + fileType.length() > 32000) {
                int numRemaing = fileTypes.length - i;
                sb.append('[');
                sb.append(numRemaing);
                sb.append(" more...]");
                break;
            }
            sb.append(fileType);
            ++i;
        }
        return sb.toString();
    }

    public static String externalRefsToString(Collection<ExternalRef> externalRefs, String docNamespace) throws InvalidSPDXAnalysisException {
        if (externalRefs == null || externalRefs.size() == 0) {
            return "";
        }
        Iterator<ExternalRef> iter = externalRefs.iterator();
        StringBuilder sb = new StringBuilder(CompareHelper.externalRefToString(iter.next(), docNamespace));
        while (iter.hasNext()) {
            sb.append("; ");
            sb.append(CompareHelper.externalRefToString(iter.next(), docNamespace));
        }
        return sb.toString();
    }

    public static String externalRefToString(ExternalRef externalRef, String docNamespace) throws InvalidSPDXAnalysisException {
        String category = null;
        category = externalRef.getReferenceCategory() == null ? "OTHER" : externalRef.getReferenceCategory().toString();
        String referenceType = null;
        if (externalRef.getReferenceType() == null) {
            referenceType = "[MISSING]";
        } else {
            try {
                referenceType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceName(new URI(externalRef.getReferenceType().getIndividualURI()));
            }
            catch (InvalidSPDXAnalysisException e) {
                referenceType = null;
            }
            catch (URISyntaxException e) {
                referenceType = null;
            }
            if (referenceType == null) {
                referenceType = externalRef.getReferenceType().getIndividualURI();
                if (docNamespace != null && !docNamespace.isEmpty() && referenceType.startsWith(docNamespace)) {
                    referenceType = referenceType.substring(docNamespace.length());
                }
            }
        }
        String referenceLocator = externalRef.getReferenceLocator();
        if (referenceLocator == null) {
            referenceLocator = "[MISSING]";
        }
        String retval = String.valueOf(category) + " " + referenceType + " " + referenceLocator;
        Optional comment = externalRef.getComment();
        if (comment.isPresent() && !((String)comment.get()).isEmpty()) {
            retval = String.valueOf(retval) + "(" + (String)comment.get() + ")";
        }
        return retval;
    }

    public static String checksumToString(Optional<Checksum> checksum) throws InvalidSPDXAnalysisException {
        if (checksum.isPresent()) {
            return CompareHelper.checksumToString(checksum.get());
        }
        return "[NONE]";
    }

    public static boolean equivalent(Optional<? extends ModelObject> c1, Optional<? extends ModelObject> c2) throws InvalidSPDXAnalysisException {
        if (!c1.isPresent()) {
            return !c2.isPresent();
        }
        if (c2.isPresent()) {
            return c1.get().equivalent(c2.get());
        }
        return false;
    }

    public static boolean equivalent(Collection<? extends ModelObject> collection1, Collection<? extends ModelObject> collection2) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(collection1)) {
            return Objects.isNull(collection2);
        }
        if (Objects.isNull(collection2)) {
            return false;
        }
        if (collection1.size() != collection2.size()) {
            return false;
        }
        for (ModelObject modelObject : collection1) {
            boolean found = false;
            for (ModelObject modelObject2 : collection2) {
                if (!modelObject.equivalent(modelObject2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

