/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.Collection;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxFile;
import org.spdx.tools.compare.AbstractFileCompareSheet;
import org.spdx.tools.compare.CompareHelper;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class FileRelationshipSheet
extends AbstractFileCompareSheet {
    static final int RELATIONSHIP_COL_WIDTH = 60;

    public FileRelationshipSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException, InvalidSPDXAnalysisException {
        return SpdxComparer.collectionsEquivalent((Collection)fileA.getRelationships(), (Collection)fileB.getRelationships());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        return CompareHelper.relationshipsToString(spdxFile.getRelationships());
    }
}

