/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxSnippet;
import org.spdx.library.model.pointer.StartEndPointer;
import org.spdx.tools.compare.AbstractSheet;
import org.spdx.tools.compare.CompareHelper;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;
import org.spdx.utility.compare.SpdxSnippetComparer;

public class SnippetSheet
extends AbstractSheet {
    static final Logger logger = LoggerFactory.getLogger(SnippetSheet.class);
    private static final int COL_WIDTH = 60;
    protected static final int FIELD_COL = 0;
    protected static final int EQUALS_COL = 1;
    protected static final int FIRST_DOC_COL = 2;
    private static final int FIELD_COL_WIDTH = 20;
    private static final int EQUALS_COL_WIDTH = 7;
    protected static final String FIELD_HEADER_TEXT = "Snippet Property";
    protected static final String EQUALS_HEADER_TEXT = "Equals";
    private static final String NO_SNIPPET = "[No Snippet]";
    protected static final String COPYRIGHT_FIELD_TEXT = "Copyright";
    protected static final String LICENSE_COMMENT_FIELD_TEXT = "License Comment";
    protected static final String DECLARED_LICENSE_FIELD_TEXT = "Declared License";
    protected static final String LICENSE_INFOS_FROM_FILES_FIELD_TEXT = "License From Files";
    protected static final String CONCLUDED_LICENSE_FIELD_TEXT = "Concluded License";
    protected static final String ID_FIELD_TEXT = "SPDX ID";
    protected static final String ANNOTATION_FIELD_TEXT = "Annotations";
    protected static final String RELATIONSHIPS_FIELD_TEXT = "Relationships";
    private static final String SNIPPET_NAME_FIELD_TEXT = "Snippet Name";
    private static final String SNIPPET_FROM_FILE_FIELD_TEXT = "From File";
    protected static final String DIFFERENT_STRING = "Diff";
    protected static final String EQUAL_STRING = "Equal";
    protected static final String MISSING_STRING = "Equal*";
    private static final String NO_VALUE = "[No Value]";
    private static final String BYTE_RANGE_FIELD_TEXT = "Byte Range";
    private static final String LINE_RANGE_FIELD_TEXT = "Line Range";

    public SnippetSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row headerRow = sheet.createRow(0);
        sheet.setColumnWidth(0, 5120);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell fieldCell = headerRow.createCell(0);
        fieldCell.setCellStyle(headerStyle);
        fieldCell.setCellValue(FIELD_HEADER_TEXT);
        sheet.setColumnWidth(1, 1792);
        sheet.setDefaultColumnStyle(1, defaultStyle);
        Cell equalsCell = headerRow.createCell(1);
        equalsCell.setCellStyle(headerStyle);
        equalsCell.setCellValue(EQUALS_HEADER_TEXT);
        int i = 2;
        while (i < 27) {
            sheet.setColumnWidth(i, 15360);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = headerRow.createCell(i);
            cell.setCellStyle(headerStyle);
            ++i;
        }
    }

    public void importCompareResults(SpdxComparer comparer, List<String> docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.size()) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            Cell headerCell = header.getCell(2 + i);
            headerCell.setCellValue(docNames.get(i));
            ++i;
        }
        SpdxSnippetComparer[] snippetComparers = comparer.getSnippetComparers();
        Arrays.sort(snippetComparers, new Comparator<SpdxSnippetComparer>(){

            @Override
            public int compare(SpdxSnippetComparer o1, SpdxSnippetComparer o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        int i2 = 0;
        while (i2 < snippetComparers.length) {
            this.addSnippetToSheet(snippetComparers[i2], comparer.getSpdxDocuments());
            ++i2;
        }
    }

    private void addSnippetToSheet(SpdxSnippetComparer comparer, List<SpdxDocument> docs) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Row snippetNameRow = this.addRow();
        boolean allDocsPresent = comparer.getNumSnippets() == docs.size();
        snippetNameRow.createCell(0).setCellValue(SNIPPET_NAME_FIELD_TEXT);
        this.setCellEqualValue(snippetNameRow.createCell(1), allDocsPresent);
        Row idRow = this.addRow();
        idRow.createCell(0).setCellValue(ID_FIELD_TEXT);
        this.setCellEqualValue(idRow.createCell(1), allDocsPresent);
        Row annotationsRow = this.addRow();
        annotationsRow.createCell(0).setCellValue(ANNOTATION_FIELD_TEXT);
        if (comparer.isAnnotationsEquals()) {
            this.setCellEqualValue(annotationsRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(annotationsRow.createCell(1));
        }
        Row relationshipsRow = this.addRow();
        relationshipsRow.createCell(0).setCellValue(RELATIONSHIPS_FIELD_TEXT);
        if (comparer.isRelationshipsEquals()) {
            this.setCellEqualValue(relationshipsRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(relationshipsRow.createCell(1));
        }
        Row concludedLicenseRow = this.addRow();
        concludedLicenseRow.createCell(0).setCellValue(CONCLUDED_LICENSE_FIELD_TEXT);
        if (comparer.isConcludedLicenseEquals()) {
            this.setCellEqualValue(concludedLicenseRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(concludedLicenseRow.createCell(1));
        }
        Row licenseInfosFromFilesRow = this.addRow();
        licenseInfosFromFilesRow.createCell(0).setCellValue(LICENSE_INFOS_FROM_FILES_FIELD_TEXT);
        if (comparer.isSeenLicenseEquals()) {
            this.setCellEqualValue(licenseInfosFromFilesRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(licenseInfosFromFilesRow.createCell(1));
        }
        Row licenseCommentRow = this.addRow();
        licenseCommentRow.createCell(0).setCellValue(LICENSE_COMMENT_FIELD_TEXT);
        if (comparer.isLicenseCommmentsEquals()) {
            this.setCellEqualValue(licenseCommentRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(licenseCommentRow.createCell(1));
        }
        Row copyrightRow = this.addRow();
        copyrightRow.createCell(0).setCellValue(COPYRIGHT_FIELD_TEXT);
        if (comparer.isCopyrightsEquals()) {
            this.setCellEqualValue(copyrightRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(copyrightRow.createCell(1));
        }
        Row snippetFromFileRow = this.addRow();
        snippetFromFileRow.createCell(0).setCellValue(SNIPPET_FROM_FILE_FIELD_TEXT);
        if (comparer.isSnippetFromFilesEquals()) {
            this.setCellEqualValue(snippetFromFileRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(snippetFromFileRow.createCell(1));
        }
        Row byteRangeRow = this.addRow();
        byteRangeRow.createCell(0).setCellValue(BYTE_RANGE_FIELD_TEXT);
        if (comparer.isByteRangeEquals()) {
            this.setCellEqualValue(byteRangeRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(byteRangeRow.createCell(1));
        }
        Row lineRangeRow = this.addRow();
        lineRangeRow.createCell(0).setCellValue(LINE_RANGE_FIELD_TEXT);
        if (comparer.isLineRangeEquals()) {
            this.setCellEqualValue(lineRangeRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(lineRangeRow.createCell(1));
        }
        int i = 0;
        while (i < docs.size()) {
            SpdxSnippet snippet = comparer.getDocSnippet(docs.get(i));
            if (snippet != null) {
                Optional name = snippet.getName();
                if (name.isPresent()) {
                    snippetNameRow.createCell(2 + i).setCellValue((String)name.get());
                } else {
                    snippetNameRow.createCell(2 + i).setCellValue(NO_VALUE);
                }
                idRow.createCell(2 + i).setCellValue(snippet.getId());
                annotationsRow.createCell(2 + i).setCellValue(CompareHelper.annotationsToString(snippet.getAnnotations()));
                relationshipsRow.createCell(2 + i).setCellValue(CompareHelper.relationshipsToString(snippet.getRelationships()));
                concludedLicenseRow.createCell(2 + i).setCellValue(snippet.getLicenseConcluded().toString());
                licenseInfosFromFilesRow.createCell(2 + i).setCellValue(CompareHelper.licenseInfosToString(snippet.getLicenseInfoFromFiles()));
                Optional licenseComments = snippet.getLicenseComments();
                if (licenseComments.isPresent()) {
                    licenseCommentRow.createCell(2 + i).setCellValue((String)licenseComments.get());
                } else {
                    licenseCommentRow.createCell(2 + i).setCellValue("");
                }
                copyrightRow.createCell(2 + i).setCellValue(snippet.getCopyrightText());
                SpdxFile snippetFromFile = snippet.getSnippetFromFile();
                if (snippetFromFile != null) {
                    snippetFromFileRow.createCell(2 + i).setCellValue(snippetFromFile.toString());
                } else {
                    snippetFromFileRow.createCell(2 + i).setCellValue(NO_VALUE);
                }
                StartEndPointer byteRange = snippet.getByteRange();
                if (byteRange != null) {
                    byteRangeRow.createCell(2 + i).setCellValue(byteRange.toString());
                } else {
                    byteRangeRow.createCell(2 + i).setCellValue(NO_VALUE);
                }
                Optional lineRange = snippet.getLineRange();
                if (lineRange.isPresent()) {
                    lineRangeRow.createCell(2 + i).setCellValue(((StartEndPointer)lineRange.get()).toString());
                } else {
                    lineRangeRow.createCell(2 + i).setCellValue(NO_VALUE);
                }
            } else {
                snippetNameRow.createCell(2 + i).setCellValue(NO_SNIPPET);
                idRow.createCell(2 + i).setCellValue(NO_SNIPPET);
                annotationsRow.createCell(2 + i).setCellValue(NO_SNIPPET);
                relationshipsRow.createCell(2 + i).setCellValue(NO_SNIPPET);
                concludedLicenseRow.createCell(2 + i).setCellValue(NO_SNIPPET);
                licenseInfosFromFilesRow.createCell(2 + i).setCellValue(NO_SNIPPET);
                licenseCommentRow.createCell(2 + i).setCellValue(NO_SNIPPET);
                copyrightRow.createCell(2 + i).setCellValue(NO_SNIPPET);
                snippetFromFileRow.createCell(2 + i).setCellValue(NO_SNIPPET);
                byteRangeRow.createCell(2 + i).setCellValue(NO_SNIPPET);
                lineRangeRow.createCell(2 + i).setCellValue(NO_SNIPPET);
            }
            ++i;
        }
    }

    private void setCellDifferentValue(Cell cell) {
        cell.setCellValue(DIFFERENT_STRING);
        cell.setCellStyle(this.yellowWrapped);
    }

    private void setCellEqualValue(Cell cell, boolean allPkgsPresent) {
        if (allPkgsPresent) {
            cell.setCellValue(EQUAL_STRING);
        } else {
            cell.setCellValue(MISSING_STRING);
        }
        cell.setCellStyle(this.greenWrapped);
    }
}

