/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.tools.schema.AbstractOwlRdfConverter;

public class OwlToJsonContext
extends AbstractOwlRdfConverter {
    static final Map<String, String> NAMESPACES;
    public static final ObjectMapper JSON_MAPPER;

    static {
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        namespaceMap.put("http://spdx.org/rdf/terms#", "spdx");
        namespaceMap.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        namespaceMap.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        namespaceMap.put("http://www.w3.org/2009/pointers#", "rdfpointer");
        namespaceMap.put("http://www.w3.org/2002/07/owl#", "owl");
        namespaceMap.put("http://usefulinc.com/ns/doap#", "doap");
        namespaceMap.put("http://www.w3.org/2001/XMLSchema#", "xs");
        NAMESPACES = Collections.unmodifiableMap(namespaceMap);
        JSON_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    }

    public OwlToJsonContext(OntModel model) {
        super(model);
    }

    public ObjectNode convertToContext() {
        ObjectNode contexts = JSON_MAPPER.createObjectNode();
        NAMESPACES.forEach((namespace, name) -> contexts.put(name, namespace));
        ObjectNode documentContext = JSON_MAPPER.createObjectNode();
        documentContext.put("@type", "spdx:SpdxDocument");
        documentContext.put("@id", "spdx:spdxDocument");
        contexts.set("Document", (JsonNode)documentContext);
        contexts.put("SPDXID", "@id");
        contexts.put("externalDocumentId", "@id");
        TreeMap<String, OntProperty> sortedOntProperties = new TreeMap<String, OntProperty>();
        ExtendedIterator iter = this.model.listAllOntProperties();
        while (iter.hasNext()) {
            OntProperty property = (OntProperty)iter.next();
            if (!property.isURIResource()) continue;
            String propNamespace = this.uriToNamespace(property.getURI());
            String propName = this.uriToPropName(property.getURI());
            String id = String.valueOf(propNamespace) + propName;
            sortedOntProperties.put(id, property);
        }
        for (Map.Entry ontPropEntry : sortedOntProperties.entrySet()) {
            String propNamespace = this.uriToNamespace(((OntProperty)ontPropEntry.getValue()).getURI());
            String propName = this.uriToPropName(((OntProperty)ontPropEntry.getValue()).getURI());
            AbstractOwlRdfConverter.PropertyRestrictions propertyRestrictions = new AbstractOwlRdfConverter.PropertyRestrictions((OntProperty)ontPropEntry.getValue());
            boolean hasListProperty = propertyRestrictions.isListProperty();
            String typeUri = propertyRestrictions.getTypeUri();
            if (hasListProperty) {
                String listPropName = MultiFormatStore.propertyNameToCollectionPropertyName((String)propName);
                ObjectNode listPropContext = JSON_MAPPER.createObjectNode();
                listPropContext.put("@id", String.valueOf(propNamespace) + listPropName);
                if (Objects.nonNull(typeUri)) {
                    listPropContext.put("@type", String.valueOf(this.uriToNamespace(typeUri)) + this.uriToPropName(typeUri));
                }
                listPropContext.put("@container", "@set");
                contexts.set(listPropName, (JsonNode)listPropContext);
            }
            if (!propertyRestrictions.isSingleProperty()) continue;
            ObjectNode propContext = JSON_MAPPER.createObjectNode();
            propContext.put("@id", (String)ontPropEntry.getKey());
            if (Objects.nonNull(typeUri)) {
                propContext.put("@type", String.valueOf(this.uriToNamespace(typeUri)) + this.uriToPropName(typeUri));
            }
            contexts.set(propName, (JsonNode)propContext);
        }
        ObjectNode context = JSON_MAPPER.createObjectNode();
        context.set("@context", (JsonNode)contexts);
        return context;
    }

    private String uriToNamespace(String uri) {
        int poundIndex = uri.lastIndexOf(35);
        String propNamespace = uri.substring(0, poundIndex + 1);
        if (NAMESPACES.containsKey(propNamespace)) {
            propNamespace = String.valueOf(NAMESPACES.get(propNamespace)) + ":";
        }
        return propNamespace;
    }

    private String uriToPropName(String uri) {
        int poundIndex = uri.lastIndexOf(35);
        return OwlToJsonContext.checkConvertRenamedPropertyName(uri.substring(poundIndex + 1));
    }
}

