/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.specs2.control.eff.Eff;
import org.specs2.control.eff.Eff$;
import org.specs2.control.eff.Evaluate;
import org.specs2.control.eff.Fx1;
import org.specs2.control.eff.Fx3;
import org.specs2.control.eff.FxAppend;
import org.specs2.control.eff.MemberIn$;
import org.specs2.control.eff.MemberInOut$;
import org.specs2.control.eff.Safe;
import org.specs2.control.eff.Writer;
import org.specs2.control.eff.syntax.all$;
import org.specs2.control.package$Operations$;
import org.specs2.fp.Traverse$;
import org.specs2.fp.package;
import org.specs2.io.DirectoryPath;
import org.specs2.io.FilePath;
import org.specs2.io.FilePathReader;
import org.specs2.io.FileSystem$copyLock$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015daB\u0001\u0003!\u0003\r\t!\u0003\u0002\u000b\r&dWmU=ti\u0016l'BA\u0002\u0005\u0003\tIwN\u0003\u0002\u0006\r\u000511\u000f]3dgJR\u0011aB\u0001\u0004_J<7\u0001A\n\u0004\u0001)\u0001\u0002CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tqa)\u001b7f!\u0006$\bNU3bI\u0016\u0014\b\"B\u000b\u0001\t\u00031\u0012A\u0002\u0013j]&$H\u0005F\u0001\u0018!\tY\u0001$\u0003\u0002\u001a\u0019\t!QK\\5u\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003)!W\r\\3uK\u001aKG.\u001a\u000b\u0003;1\u00022A\b\u0014*\u001d\ty2E\u0004\u0002!C5\tA!\u0003\u0002#\t\u000591m\u001c8ue>d\u0017B\u0001\u0013&\u0003\u001d\u0001\u0018mY6bO\u0016T!A\t\u0003\n\u0005\u001dB#!C(qKJ\fG/[8o\u0015\t!S\u0005\u0005\u0002\fU%\u00111\u0006\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015i#\u00041\u0001/\u0003!1\u0017\u000e\\3QCRD\u0007CA\t0\u0013\t\u0001$A\u0001\u0005GS2,\u0007+\u0019;i\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003E)\b\u000fZ1uK\u001aKG.Z\"p]R,g\u000e\u001e\u000b\u0003i\u0019#\"!\u000e\u001c\u0011\u0007y1s\u0003C\u00038c\u0001\u0007\u0001(\u0001\u0004va\u0012\fG/\u001a\t\u0005\u0017eZ4(\u0003\u0002;\u0019\tIa)\u001e8di&|g.\r\t\u0003y\rs!!P!\u0011\u0005ybQ\"A \u000b\u0005\u0001C\u0011A\u0002\u001fs_>$h(\u0003\u0002C\u0019\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011E\u0002C\u0003.c\u0001\u0007a\u0006C\u0003I\u0001\u0011\u0005\u0011*A\u0007sKBd\u0017mY3J]\u001aKG.\u001a\u000b\u0005k)[U\nC\u0003.\u000f\u0002\u0007a\u0006C\u0003M\u000f\u0002\u00071(\u0001\u0004t_V\u00148-\u001a\u0005\u0006\u001d\u001e\u0003\raO\u0001\u0007i\u0006\u0014x-\u001a;\t\u000bA\u0003A\u0011A)\u0002\u0013]\u0014\u0018\u000e^3GS2,GcA\u001bS'\")Qf\u0014a\u0001]!)Ak\u0014a\u0001w\u000591m\u001c8uK:$\b\"\u0002,\u0001\t\u00039\u0016!E<ji\",\u0005\u000f[3nKJ\fGNR5mKR\u0011\u0001l\u0017\u000b\u0003keCQAW+A\u0002U\n\u0011b\u001c9fe\u0006$\u0018n\u001c8\t\u000bq+\u0006\u0019\u0001\u0018\u0002\tA\fG\u000f\u001b\u0005\u0006=\u0002!\taX\u0001\u0007[.$\u0017N]:\u0015\u0005U\u0002\u0007\"\u0002/^\u0001\u0004\t\u0007CA\tc\u0013\t\u0019'AA\u0007ESJ,7\r^8ssB\u000bG\u000f\u001b\u0005\u0006=\u0002!\t!\u001a\u000b\u0003k\u0019DQ\u0001\u00183A\u00029BQ\u0001\u001b\u0001\u0005\u0002%\fQ!\u001e8kCJ$B!\u000e6um\")1n\u001aa\u0001Y\u00061!.\u0019:Ve2\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\u00079,GOC\u0001r\u0003\u0011Q\u0017M^1\n\u0005Mt'aA+S\u0019\")Qo\u001aa\u0001C\u0006!A-Z:u\u0011\u00159x\r1\u0001<\u0003-\u0011XmZ3y\r&dG/\u001a:\t\u000be\u0004A\u0011\u0002>\u0002\t\r|\u0007/\u001f\u000b\u0005/m\f)\u0001C\u0003}q\u0002\u0007Q0A\u0003j]B,H\u000fE\u0002\u007f\u0003\u0003i\u0011a \u0006\u0003\u0007AL1!a\u0001\u0000\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\u0005\u001d\u0001\u00101\u0001\u0002\n\u00051q.\u001e;qkR\u00042A`A\u0006\u0013\r\tia \u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003#\u0001A\u0011AA\n\u0003\u001d\u0019w\u000e]=ESJ$R!NA\u000b\u00033Aq!a\u0006\u0002\u0010\u0001\u0007\u0011-A\u0002te\u000eDa!^A\b\u0001\u0004\t\u0007bBA\u000f\u0001\u0011\u0005\u0011qD\u0001\tG>\u0004\u0018PR5mKR!\u0011\u0011EA\u0013)\r)\u00141\u0005\u0005\u0007[\u0005m\u0001\u0019\u0001\u0018\t\rU\fY\u00021\u0001b\u000f!\tI\u0003\u0001Q\t\n\u0005-\u0012\u0001C2pafdunY6\u0011\t\u00055\u0012qF\u0007\u0002\u0001\u0019A\u0011\u0011\u0007\u0001!\u0012\u0013\t\u0019D\u0001\u0005d_BLHj\\2l'\r\tyC\u0003\u0005\t\u0003o\ty\u0003\"\u0001\u0002:\u00051A(\u001b8jiz\"\"!a\u000b\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005Q1M]3bi\u00164\u0015\u000e\\3\u0015\u0007u\t\t\u0005\u0003\u0004.\u0003w\u0001\rA\f\u0005\b\u0003\u000b\u0002A\u0011AA$\u0003\u0019!W\r\\3uKR\u0019Q'!\u0013\t\u000f\u0005-\u00131\ta\u0001]\u0005!a-\u001b7f\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u001f\"2!NA)\u0011\u001d\t\u0019&!\u0014A\u0002\u0005\f1\u0001Z5s\u000f\u001d\t9F\u0001E\u0001\u00033\n!BR5mKNK8\u000f^3n!\r\t\u00121\f\u0004\u0007\u0003\tA\t!!\u0018\u0014\u000b\u0005m#\"a\u0018\u0011\u0005E\u0001\u0001\u0002CA\u001c\u00037\"\t!a\u0019\u0015\u0005\u0005e\u0003")
public interface FileSystem
extends FilePathReader {
    public FileSystem$copyLock$ org$specs2$io$FileSystem$$copyLock();

    public static /* synthetic */ Eff deleteFile$(FileSystem $this, FilePath filePath) {
        return $this.deleteFile(filePath);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, Object> deleteFile(FilePath filePath) {
        return package$Operations$.MODULE$.delayed((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> filePath.toFile().delete());
    }

    public static /* synthetic */ Eff updateFileContent$(FileSystem $this, FilePath filePath, Function1 update) {
        return $this.updateFileContent(filePath, (Function1<String, String>)update);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> updateFileContent(FilePath filePath, Function1<String, String> update) {
        return this.readFile(filePath).flatMap((Function1 & Serializable & scala.Serializable)s -> this.writeFile(filePath, (String)update.apply(s)));
    }

    public static /* synthetic */ Eff replaceInFile$(FileSystem $this, FilePath filePath, String source, String target) {
        return $this.replaceInFile(filePath, source, target);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> replaceInFile(FilePath filePath, String source, String target) {
        return this.updateFileContent(filePath, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> x$1.replace(source, target));
    }

    public static /* synthetic */ Eff writeFile$(FileSystem $this, FilePath filePath, String content) {
        return $this.writeFile(filePath, content);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> writeFile(FilePath filePath, String content) {
        return (Eff)package.syntax$.MODULE$.MonadOps(this.mkdirs(filePath), Eff$.MODULE$.EffMonad()).$greater$greater(package$Operations$.MODULE$.protect((Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            try (PrintWriter writer2 = new PrintWriter(filePath.path(), "UTF-8");){
                try {
                    Right$ right$ = package$.MODULE$.Right();
                    writer2.write(content);
                    left = right$.apply((Object)BoxedUnit.UNIT);
                }
                catch (Exception e) {
                    left = package$.MODULE$.Left().apply((Object)e);
                }
            }
            return left;
        }).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Eff eff2;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Exception e = (Exception)left.value();
                eff2 = (Eff)package.syntax$.MODULE$.MonadOps(package$Operations$.MODULE$.logThrowable(e, MemberIn$.MODULE$.MemberInAppendR(MemberIn$.MODULE$.MemberIn3L())), Eff$.MODULE$.EffMonad()).$greater$greater(package$Operations$.MODULE$.warn(new StringBuilder(21).append("could not write file ").append(filePath.path()).toString()));
            } else if (either instanceof Right) {
                eff2 = package$Operations$.MODULE$.unit();
            } else {
                throw new MatchError((Object)either);
            }
            return eff2;
        }));
    }

    public static /* synthetic */ Eff withEphemeralFile$(FileSystem $this, FilePath path, Eff operation) {
        return $this.withEphemeralFile(path, operation);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> withEphemeralFile(FilePath path, Eff<FxAppend<Fx1<?>, Fx3<?, ?, Safe>>, BoxedUnit> operation) {
        return all$.MODULE$.SafeEffectOps(operation).thenFinally((Eff)package.syntax$.MODULE$.FunctorOps(this.deleteFile(path), Eff$.MODULE$.EffMonad()).void(), MemberInOut$.MODULE$.MemberInOutAppendR(MemberInOut$.MODULE$.MemberInOut3R()));
    }

    public static /* synthetic */ Eff mkdirs$(FileSystem $this, DirectoryPath path) {
        return $this.mkdirs(path);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> mkdirs(DirectoryPath path) {
        return (Eff)package.syntax$.MODULE$.FunctorOps(package$Operations$.MODULE$.protect((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> path.toFile().mkdirs()), Eff$.MODULE$.EffMonad()).void();
    }

    public static /* synthetic */ Eff mkdirs$(FileSystem $this, FilePath path) {
        return $this.mkdirs(path);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> mkdirs(FilePath path) {
        return this.mkdirs(path.dir());
    }

    public static /* synthetic */ Eff unjar$(FileSystem $this, URL jarUrl, DirectoryPath dest, String regexFilter) {
        return $this.unjar(jarUrl, dest, regexFilter);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> unjar(URL jarUrl, DirectoryPath dest, String regexFilter) {
        Pattern regex = Pattern.compile(regexFilter);
        InputStream uis = jarUrl.openStream();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(uis));
        return package$Operations$.MODULE$.delayed((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                this.extractEntry$1(zis.getNextEntry(), dest, regex, zis);
            }
            finally {
                zis.close();
            }
        });
    }

    private void copy(InputStream input, OutputStream output) {
        byte[] data = new byte[2048];
        this.readData$1(input.read(data, 0, 2048), input, output, data);
    }

    public static /* synthetic */ Eff copyDir$(FileSystem $this, DirectoryPath src, DirectoryPath dest) {
        return $this.copyDir(src, dest);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> copyDir(DirectoryPath src, DirectoryPath dest) {
        return (Eff)package.syntax$.MODULE$.MonadOps(package.syntax$.MODULE$.MonadOps(this.mkdirs(dest), Eff$.MODULE$.EffMonad()).$greater$greater(this.listDirectFilePaths(src).flatMap((Function1 & Serializable & scala.Serializable)files -> (Eff)package.syntax$.MODULE$.FunctorOps(package.syntax$.MODULE$.SequenceOps(files.toList().map((Function1 & Serializable & scala.Serializable)filePath -> this.copyFile(dest, (FilePath)filePath), List$.MODULE$.canBuildFrom()), Traverse$.MODULE$.listInstance(), Eff$.MODULE$.EffMonad()).sequence(), Eff$.MODULE$.EffMonad()).void())), Eff$.MODULE$.EffMonad()).$greater$greater(this.listDirectDirectoryPaths(src).flatMap((Function1 & Serializable & scala.Serializable)directories -> (Eff)package.syntax$.MODULE$.FunctorOps(package.syntax$.MODULE$.SequenceOps(directories.toList().map((Function1 & Serializable & scala.Serializable)dir -> this.copyDir((DirectoryPath)dir, dest.$div(dir.name())), List$.MODULE$.canBuildFrom()), Traverse$.MODULE$.listInstance(), Eff$.MODULE$.EffMonad()).sequence(), Eff$.MODULE$.EffMonad()).void()));
    }

    public static /* synthetic */ Eff copyFile$(FileSystem $this, DirectoryPath dest, FilePath filePath) {
        return $this.copyFile(dest, filePath);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> copyFile(DirectoryPath dest, FilePath filePath) {
        return (Eff)package.syntax$.MODULE$.MonadOps(this.mkdirs(dest), Eff$.MODULE$.EffMonad()).$greater$greater(package.syntax$.MODULE$.FunctorOps(package$Operations$.MODULE$.delayed((Function0 & Serializable & scala.Serializable)() -> {
            Path path;
            FileSystem$copyLock$ fileSystem$copyLock$ = this.org$specs2$io$FileSystem$$copyLock();
            synchronized (fileSystem$copyLock$) {
                path = Files.copy(Paths.get(filePath.path(), new String[0]), Paths.get(dest.path(), new String[0]).resolve(Paths.get(filePath.name().name(), new String[0])), StandardCopyOption.REPLACE_EXISTING);
            }
            return path;
        }), Eff$.MODULE$.EffMonad()).void());
    }

    public static /* synthetic */ Eff createFile$(FileSystem $this, FilePath filePath) {
        return $this.createFile(filePath);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, Object> createFile(FilePath filePath) {
        return (Eff)package.syntax$.MODULE$.MonadOps(this.mkdirs(filePath.dir()), Eff$.MODULE$.EffMonad()).$greater$greater(package$Operations$.MODULE$.delayed((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> filePath.toFile().createNewFile()));
    }

    public static /* synthetic */ Eff delete$(FileSystem $this, FilePath file) {
        return $this.delete(file);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> delete(FilePath file) {
        return (Eff)package.syntax$.MODULE$.FunctorOps(package$Operations$.MODULE$.delayed((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> file.toFile().delete()), Eff$.MODULE$.EffMonad()).void();
    }

    public static /* synthetic */ Eff delete$(FileSystem $this, DirectoryPath dir) {
        return $this.delete(dir);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> delete(DirectoryPath dir) {
        return (Eff)package.syntax$.MODULE$.MonadOps(this.listFilePaths(dir).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Eff)package.syntax$.MODULE$.FunctorOps(package.syntax$.MODULE$.SequenceOps((Object)((List)x$2.map((Function1 & Serializable & scala.Serializable)file -> this.delete((FilePath)file), List$.MODULE$.canBuildFrom())).toList(), Traverse$.MODULE$.listInstance(), Eff$.MODULE$.EffMonad()).sequence(), Eff$.MODULE$.EffMonad()).void()), Eff$.MODULE$.EffMonad()).$greater$greater(this.delete(dir.toFilePath()));
    }

    private void extractEntry$1(ZipEntry entry, DirectoryPath dest$1, Pattern regex$1, ZipInputStream zis$1) {
        while (entry != null) {
            Matcher matcher = regex$1.matcher(entry.getName());
            if (matcher.matches()) {
                String target = matcher.replaceFirst(new StringBuilder(2).append(Matcher.quoteReplacement(dest$1.path())).append("$1").toString());
                if (!entry.isDirectory()) {
                    new File(target).getParentFile().mkdirs();
                    new File(target).createNewFile();
                    FileOutputStream fos = new FileOutputStream(target);
                    try (BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);){
                        this.copy(zis$1, dest);
                        dest.flush();
                    }
                }
            }
            entry = zis$1.getNextEntry();
        }
    }

    private void readData$1(int count, InputStream input$1, OutputStream output$1, byte[] data$1) {
        while (count != -1) {
            output$1.write(data$1, 0, count);
            output$1.flush();
            count = input$1.read(data$1, 0, 2048);
        }
    }

    public static void $init$(FileSystem $this) {
    }
}

