/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.matcher.describe;

import java.io.Serializable;
import org.specs2.matcher.describe.ComparisonResult;
import org.specs2.matcher.describe.Diffable;
import org.specs2.matcher.describe.MapDifference$;
import org.specs2.matcher.describe.MapIdentical$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;

public class MapDiffable<K, V>
implements Diffable<Map<K, V>> {
    private final Diffable<V> diff;

    public MapDiffable(Diffable<V> diff) {
        this.diff = diff;
    }

    @Override
    public ComparisonResult diff(Map<K, V> actual, Map<K, V> expected) {
        Seq<Tuple2<K, ComparisonResult>> changed = this.findChanged(actual, expected);
        Seq<Tuple2<K, V>> added = this.findAdded(actual, expected);
        Seq<Tuple2<K, V>> removed = this.findRemoved(actual, expected);
        Seq keys = (Seq)((IterableOps)((IterableOps)changed.$plus$plus(added)).$plus$plus(removed)).map((Function1 & Serializable)_$1 -> _$1._1());
        Seq identical = actual.filterKeys((Function1 & Serializable)k -> !keys.contains(k)).toSeq();
        return (ComparisonResult)((Object)(keys.isEmpty() ? MapIdentical$.MODULE$.apply(actual) : MapDifference$.MODULE$.apply((Seq<Tuple2<Object, Object>>)identical, changed, added, removed)));
    }

    private Seq<Tuple2<K, ComparisonResult>> findChanged(Map<K, V> actual, Map<K, V> expected) {
        return (Seq)actual.keySet().intersect((Set)expected.keySet()).toSeq().flatMap((Function1 & Serializable)k -> actual.get(k).flatMap((Function1 & Serializable)v1 -> expected.get(k).map((Function1 & Serializable)v2 -> {
            ComparisonResult result = this.diff.diff(v1, v2);
            return Tuple2$.MODULE$.apply(v2, (Object)result);
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object v2 = tuple2._1();
                ComparisonResult result = (ComparisonResult)tuple2._2();
                return !result.identical();
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object v2 = tuple2._1();
                ComparisonResult result = (ComparisonResult)tuple2._2();
                return Tuple2$.MODULE$.apply(k, (Object)result);
            }
            throw new MatchError((Object)tuple2);
        })));
    }

    private Seq<Tuple2<K, V>> findAdded(Map<K, V> actual, Map<K, V> expected) {
        return expected.filterKeys((Function1 & Serializable)k -> !actual.contains(k)).toSeq();
    }

    private Seq<Tuple2<K, V>> findRemoved(Map<K, V> actual, Map<K, V> expected) {
        return actual.filterKeys((Function1 & Serializable)k -> !expected.contains(k)).toSeq();
    }
}

