/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.spf4j.io.compress.Compress;
import org.spf4j.maven.MavenRepositoryUtils;
import org.spf4j.maven.plugin.avro.avscp.SchemaMojoBase;

@Mojo(name="avro-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.INITIALIZE)
public final class SchemaDependenciesMojo
extends SchemaMojoBase {
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Parameter(name="excludes")
    private List<String> excludes = Collections.EMPTY_LIST;

    private static List<Pattern> getPatterns(Collection<String> patterns) {
        ArrayList<Pattern> result = new ArrayList<Pattern>(patterns.size());
        for (String sp : patterns) {
            result.add(Pattern.compile(sp));
        }
        return result;
    }

    private static boolean matches(Iterable<Pattern> patterns, String what) {
        for (Pattern p : patterns) {
            if (!p.matcher(what).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        Log log = this.getLog();
        log.info((CharSequence)"Resolving schema dependencies");
        List<Pattern> patterns = SchemaDependenciesMojo.getPatterns(this.excludes);
        HashSet deps = new HashSet();
        RepositorySystemSession repositorySession = this.mavenSession.getRepositorySession();
        List dependencies = this.mavenProject.getDependencies();
        try {
            for (Dependency dep : dependencies) {
                deps.addAll(MavenRepositoryUtils.resolveArtifactAndDependencies((String)"compile", (String)dep.getGroupId(), (String)dep.getArtifactId(), (String)dep.getClassifier(), (String)dep.getType(), (String)dep.getVersion(), (List)this.mavenProject.getRemoteProjectRepositories(), (RepositorySystem)this.repoSystem, (RepositorySystemSession)repositorySession));
            }
        }
        catch (DependencyResolutionException ex) {
            throw new MojoExecutionException("Cannot resolve dependencies for " + (Object)((Object)this), (Exception)((Object)ex));
        }
        log.info((CharSequence)("resolved schema dependencies: " + deps));
        Path dependenciesTargetPath = this.dependenciesDirectory.toPath();
        try {
            Files.createDirectories(dependenciesTargetPath, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        ArrayList classes = new ArrayList(64);
        for (File file : deps) {
            try {
                if (file.isDirectory()) {
                    FileUtils.copyDirectory((File)file, (File)dependenciesTargetPath.toFile());
                    continue;
                }
                List unzip = Compress.unzip2((Path)file.toPath(), (Path)dependenciesTargetPath, p -> {
                    Path fileName = p.getFileName();
                    if (fileName == null) {
                        return false;
                    }
                    String fn = fileName.toString();
                    if (fn.endsWith("class")) {
                        Path root = p.getRoot();
                        Path relativize = root != null ? root.relativize((Path)p) : p;
                        classes.add(relativize.toString());
                    }
                    if (SchemaDependenciesMojo.matches(patterns, p.toString())) {
                        return false;
                    }
                    return fn.endsWith("avsc") || fn.endsWith("avpr") || fn.endsWith("avdl");
                });
                if (unzip.isEmpty()) continue;
                log.info((CharSequence)("Found dependency schemas: " + unzip + " from " + file));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Cannot unzip " + file, (Exception)ex);
            }
        }
        Path classesInfo = dependenciesTargetPath.resolve("classes.txt");
        try {
            Files.write(classesInfo, classes, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot write " + classesInfo, (Exception)ex);
        }
    }

    @Override
    public String toString() {
        return "SchemaDependenciesMojo{mavenSession=" + this.mavenSession + ", repoSystem=" + this.repoSystem + ", mojoExecution=" + this.mojoExecution + ", " + super.toString() + '}';
    }
}

