/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.SchemaRefWriter;
import org.apache.avro.SchemaResolver;
import org.apache.avro.SchemaResolvers;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.spf4j.avro.SchemaRef;
import org.spf4j.maven.MavenSchemaResolver;

@SuppressFBWarnings(value={"AI_ANNOTATION_ISSUES_NEEDS_NULLABLE"})
abstract class SchemaMojoBase
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject mavenProject;
    @Parameter(name="dependenciesDirectory", defaultValue="${project.build.directory}/schema-dependencies", readonly=true)
    protected File dependenciesDirectory;
    @Parameter(name="sourceDirectory", defaultValue="${basedir}/src/main/avro")
    protected File sourceDirectory;
    @Parameter(name="generatedJavaTarget", defaultValue="${project.build.directory}/generated-sources/avro")
    protected File generatedJavaTarget;
    @Parameter(name="generatedAvscTarget", defaultValue="${project.build.directory}/generated-sources/avsc")
    protected File generatedAvscTarget;
    @Parameter(name="target", defaultValue="${project.build.directory}")
    protected File target;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession mavenSession;
    @Parameter(name="useSchemaReferencesForAvsc", defaultValue="false")
    protected boolean useSchemaReferencesForAvsc = false;
    @Parameter(name="schemaArtifactClassifier", defaultValue="avsc")
    protected String schemaArtifactClassifier = "avsc";
    @Parameter(name="schemaArtifactExtension", defaultValue="jar")
    protected String schemaArtifactExtension = "jar";
    @Component
    protected RepositorySystem repoSystem;

    SchemaMojoBase() {
    }

    public final RepositorySystem getRepoSystem() {
        return this.repoSystem;
    }

    public final MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public final File getGeneratedAvscTarget() {
        return this.generatedAvscTarget;
    }

    public final File getTarget() {
        return this.target;
    }

    private Map<String, String> idx2Name() throws IOException {
        Path indexFile = this.generatedAvscTarget.toPath().resolve("schema_index.properties");
        Properties result = new Properties();
        try (BufferedReader br = Files.newBufferedReader(indexFile, StandardCharsets.UTF_8);){
            result.load(br);
        }
        catch (NoSuchFileException ex) {
            return Collections.EMPTY_MAP;
        }
        return result;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.useSchemaReferencesForAvsc && SchemaRefWriter.isSchemaRefsSupported()) {
            Map<String, String> currentMappings;
            try {
                currentMappings = this.idx2Name();
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Exception loading schema index: " + this.generatedAvscTarget.toPath().resolve("schema_index.properties"), (Exception)ex);
            }
            final MavenSchemaResolver res = new MavenSchemaResolver(this.repoSystem, this.getMavenSession().getRepositorySession(), this.mavenProject.getRemoteProjectRepositories(), this.schemaArtifactClassifier, this.schemaArtifactExtension);
            SchemaResolvers.registerDefault((SchemaResolver)new SchemaResolver(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Schema resolveSchema(String id) {
                    SchemaRef ref = new SchemaRef((CharSequence)id);
                    if (!SchemaMojoBase.this.mavenProject.getGroupId().equals(ref.getGroupId())) return res.resolveSchema(id);
                    if (!SchemaMojoBase.this.mavenProject.getArtifactId().equals(ref.getArtifactId())) return res.resolveSchema(id);
                    if (!SchemaMojoBase.this.mavenProject.getVersion().equals(ref.getVersion())) return res.resolveSchema(id);
                    String name = (String)currentMappings.get(ref.getRef());
                    Path schemaPath = SchemaMojoBase.this.generatedAvscTarget.toPath().resolve(name.replace('.', '/') + ".avsc");
                    try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(schemaPath, new OpenOption[0]));){
                        Schema schema = new Schema.Parser().parse((InputStream)bis);
                        return schema;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }

                public String getId(Schema schema) {
                    return res.getId(schema);
                }
            });
        }
    }

    public String toString() {
        return "SchemaMojoBase{dependenciesDirectory=" + this.dependenciesDirectory + ", sourceDirectory=" + this.sourceDirectory + ", generatedJavaTarget=" + this.generatedJavaTarget + ", generatedAvscTarget=" + this.generatedAvscTarget + ", target=" + this.target + '}';
    }
}

