/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.spf4j.io.compress.Compress;
import org.spf4j.maven.plugin.avro.avscp.SchemaMojoBase;

@Mojo(name="avro-package", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public final class SchemaPackageMojo
extends SchemaMojoBase {
    @Parameter(name="packageAvsc", defaultValue="true")
    private boolean packageAvsc = true;
    @Parameter(name="packageAvscSources", defaultValue="true")
    private boolean packageAvscSources = true;

    public String[] getSourceFiles() {
        FileSetManager fsm = new FileSetManager();
        FileSet fs = new FileSet();
        fs.setDirectory(this.sourceDirectory.getAbsolutePath());
        fs.addInclude("**/*.avsc");
        fs.addInclude("**/*.avpr");
        fs.addInclude("**/*.avdl");
        fs.setFollowSymlinks(false);
        return fsm.getIncludedFiles(fs);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        Log logger = this.getLog();
        Path sourcePath = this.sourceDirectory.toPath();
        if (this.packageAvsc) {
            logger.info((CharSequence)"Packaging schemas");
            Path avsc = this.target.toPath().resolve(this.mavenProject.getArtifactId() + '-' + this.mavenProject.getVersion() + '-' + "avsc." + this.schemaArtifactExtension);
            try {
                if (Files.notExists(sourcePath, new LinkOption[0])) {
                    return;
                }
                Compress.zip((Path)this.generatedAvscTarget.toPath(), (Path)avsc);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Cannot package schemas and sources from " + this.generatedAvscTarget, (Exception)ex);
            }
            DefaultArtifact schemas = new DefaultArtifact(this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.mavenProject.getVersion(), "compile", this.schemaArtifactExtension, this.schemaArtifactClassifier, (ArtifactHandler)new DefaultArtifactHandler(this.schemaArtifactExtension));
            schemas.setFile(avsc.toFile());
            logger.debug((CharSequence)("Attaching " + schemas + " from " + avsc));
            this.mavenProject.addAttachedArtifact((Artifact)schemas);
        }
        if (this.packageAvscSources) {
            logger.info((CharSequence)"Packaging schema sources");
            Path sources = this.target.toPath().resolve(this.mavenProject.getArtifactId() + '-' + this.mavenProject.getVersion() + '-' + "avroSources.jar");
            try {
                Compress.zip((Path)sourcePath, (Path)sources);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Cannot package sources from " + this.sourceDirectory, (Exception)ex);
            }
            DefaultArtifact avroSources = new DefaultArtifact(this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.mavenProject.getVersion(), "compile", "jar", "avroSources", (ArtifactHandler)new DefaultArtifactHandler("jar"));
            avroSources.setFile(sources.toFile());
            logger.debug((CharSequence)("Attaching " + avroSources + " from " + sources));
            this.mavenProject.addAttachedArtifact((Artifact)avroSources);
        }
    }

    @Override
    public String toString() {
        return "SchemaPackageMojo{schemaArtifactClassifier=" + this.schemaArtifactClassifier + ", " + super.toString() + '}';
    }
}

