/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.spf4j.maven.plugin.avro.avscp.SchemaMojoBase;
import org.spf4j.maven.plugin.avro.avscp.ValidatorMojo;
import org.spf4j.maven.plugin.avro.avscp.validation.Validator;
import org.spf4j.maven.plugin.avro.avscp.validation.Validators;

@Mojo(name="avro-validate", defaultPhase=LifecyclePhase.TEST, requiresProject=true)
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "SCII_SPOILED_CHILD_INTERFACE_IMPLEMENTOR", "EI_EXPOSE_REP"})
public final class SchemaValidatorMojo
extends SchemaMojoBase
implements ValidatorMojo {
    @Parameter(name="excludeValidators")
    private List<String> excludeValidators = Collections.EMPTY_LIST;
    @Parameter(name="validatorConfigs")
    private Map<String, String> validatorConfigs = Collections.EMPTY_MAP;

    @Override
    public Map<String, String> getValidatorConfigs() {
        return this.validatorConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"PCAIL_POSSIBLE_CONSTANT_ALLOCATION_IN_LOOP"})
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        Log logger = this.getLog();
        logger.info((CharSequence)"Validating schemas");
        Class<String> clazz = String.class;
        synchronized (String.class) {
            String orig = System.getProperty("allowUndefinedLogicalTypes");
            try {
                System.setProperty("allowUndefinedLogicalTypes", "true");
                Validators validators = new Validators(this.excludeValidators);
                for (String file : this.getSchemaFiles()) {
                    try {
                        File src = new File(this.generatedAvscTarget, file);
                        Schema.Parser parser = new Schema.Parser();
                        Schema schema = parser.parse(src);
                        Map<String, Validator.Result> vresult = validators.validate(schema, this);
                        String sIdl = schema.getProp("sourceIdl");
                        this.handleValidation(vresult, logger, schema.getFullName() + (sIdl != null ? " from " + sIdl : ""));
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("Cannot validate " + file, (Exception)ex);
                    }
                }
                try {
                    Map<String, Validator.Result> vresult = validators.validate(null, this);
                    this.handleValidation(vresult, logger, "project");
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Cannot validate " + this, (Exception)ex);
                }
            }
            finally {
                if (orig != null) {
                    System.setProperty("allowUndefinedLogicalTypes", orig);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void handleValidation(Map<String, Validator.Result> vresult, Log logger, String detail) throws MojoExecutionException {
        if (!vresult.isEmpty()) {
            boolean failed = false;
            for (Map.Entry<String, Validator.Result> res : vresult.entrySet()) {
                Validator.Result vres = res.getValue();
                if (vres.isValid()) continue;
                failed = true;
                String vName = res.getKey();
                logger.error((CharSequence)("Validator " + vName + " failed with error: " + vres.getValidationErrorMessage()));
                Exception ex = vres.getValidationException();
                if (ex == null) continue;
                logger.error((CharSequence)("Validator " + vName + " exception"), (Throwable)ex);
            }
            if (failed) {
                logger.error((CharSequence)("Schema validation failed for " + detail));
                throw new MojoExecutionException("Failed to validate " + detail);
            }
        }
    }

    public String[] getSchemaFiles() {
        FileSetManager fsm = new FileSetManager();
        FileSet fs = new FileSet();
        fs.setDirectory(this.generatedAvscTarget.getAbsolutePath());
        fs.addInclude("**/*.avsc");
        fs.setFollowSymlinks(false);
        return fsm.getIncludedFiles(fs);
    }

    @Override
    public String toString() {
        return "SchemaValidatorMojo{excludes=" + this.excludeValidators + ", " + super.toString() + '}';
    }
}

