/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp.validation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spf4j.maven.plugin.avro.avscp.ValidatorMojo;

public interface Validator<T> {
    public @NonNull String getName();

    public Class<T> getValidationInput();

    @CheckReturnValue
    public @NonNull Result validate(T var1, ValidatorMojo var2) throws IOException, MojoExecutionException;

    public static class Result {
        private static final Result VALID = new Result(true, null, null);
        private final boolean isValid;
        private final String validationErrorMessage;
        private final Exception validationException;

        private Result(boolean isValid, @Nullable String validationErrorMessage, @Nullable Exception validationException) {
            this.isValid = isValid;
            this.validationErrorMessage = validationErrorMessage;
            this.validationException = validationException;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public boolean isFailed() {
            return !this.isValid;
        }

        public String getValidationErrorMessage() {
            return this.validationErrorMessage;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Exception getValidationException() {
            return this.validationException;
        }

        public static Result valid() {
            return VALID;
        }

        public static Result failed(String validationErrorMessage) {
            return new Result(false, validationErrorMessage, null);
        }

        public static Result failed(String validationErrorMessage, Exception ex) {
            return new Result(false, validationErrorMessage, ex);
        }

        public static Result failed(Exception ex) {
            return new Result(false, ex.getMessage(), ex);
        }
    }
}

