/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp.validation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.apache.avro.Schema;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.spf4j.base.Pair;
import org.spf4j.maven.plugin.avro.avscp.ValidatorMojo;
import org.spf4j.maven.plugin.avro.avscp.validation.Validator;
import org.spf4j.maven.plugin.avro.avscp.validation.impl.SchemaCompatibilityValidator;
import org.spf4j.maven.plugin.avro.avscp.validation.impl.SchemaDocValidator;
import org.spf4j.maven.plugin.avro.avscp.validation.impl.SchemaNamesValidator;

public final class Validators {
    private static final Map<String, Validator<?>> VALIDATORS = new HashMap();
    private final Map<String, Validator<?>> validators = new HashMap(VALIDATORS);

    public Validators(List<String> exclude) {
        for (String vname : exclude) {
            this.validators.remove(vname);
        }
    }

    @CheckReturnValue
    public Map<String, Validator.Result> validate(Object obj, ValidatorMojo mojo) throws IOException, MojoExecutionException {
        Log log = mojo.getLog();
        HashMap<String, Validator.Result> result = new HashMap<String, Validator.Result>(4);
        for (Validator<?> v : this.validators.values()) {
            Validator.Result res;
            String name;
            ConfiguredValidatorMojo cMojo;
            Map<String, String> validatorConfigs;
            if ((obj != null || v.getValidationInput() != Void.class) && (obj == null || !v.getValidationInput().isAssignableFrom(obj.getClass())) || Boolean.parseBoolean((validatorConfigs = (cMojo = new ConfiguredValidatorMojo(mojo, (name = v.getName()) + '.')).getValidatorConfigs()).getOrDefault("skip", "false"))) continue;
            if (obj instanceof Schema) {
                if (Validators.skipValidator((Schema)obj, name)) continue;
                log.info((CharSequence)("Validating " + name + " for " + ((Schema)obj).getFullName() + ", config is: " + validatorConfigs));
            } else {
                log.info((CharSequence)("Validating " + name + " for " + obj + ", config is: " + validatorConfigs));
            }
            if (!(res = v.validate(obj, cMojo)).isFailed()) continue;
            if (!Boolean.parseBoolean(validatorConfigs.getOrDefault("failOnIssue", "true"))) {
                log.info((CharSequence)res.getValidationErrorMessage());
                continue;
            }
            result.put(v.getName(), res);
        }
        return result;
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    public static boolean skipValidator(Schema obj, String validatorName) {
        Object iVal = obj.getObjectProp("ignoreValidators");
        if (iVal instanceof String && validatorName.equals(iVal)) {
            return true;
        }
        return iVal instanceof List && ((List)iVal).contains(validatorName);
    }

    public String toString() {
        return "Validators{validators=" + this.validators + '}';
    }

    static {
        SchemaDocValidator sdVal = new SchemaDocValidator();
        VALIDATORS.put(sdVal.getName(), sdVal);
        SchemaNamesValidator snVal = new SchemaNamesValidator();
        VALIDATORS.put(snVal.getName(), snVal);
        SchemaCompatibilityValidator scVal = new SchemaCompatibilityValidator();
        VALIDATORS.put(scVal.getName(), scVal);
        ServiceLoader<Validator> factories = ServiceLoader.load(Validator.class);
        for (Validator v : factories) {
            Validator ex = VALIDATORS.put(v.getName(), v);
            if (ex == null) continue;
            Logger.getLogger(Validators.class.getName()).log(Level.WARNING, "Ignoring {0} because of {1}", new Object[]{ex, v});
        }
    }

    private static class ConfiguredValidatorMojo
    implements ValidatorMojo {
        private final ValidatorMojo mojo;
        private final String name;
        private final int l;
        private Map<String, String> configs;

        ConfiguredValidatorMojo(ValidatorMojo mojo, String name) {
            this.mojo = mojo;
            this.name = name;
            this.l = name.length();
            this.configs = null;
        }

        @Override
        public Map<String, String> getValidatorConfigs() {
            if (this.configs == null) {
                this.configs = this.mojo.getValidatorConfigs().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(this.name) && entry.getValue() != null).map(entry -> Pair.of((Object)((String)entry.getKey()).substring(this.l), entry.getValue())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (String)x.getValue()));
            }
            return this.configs;
        }

        @Override
        public RepositorySystem getRepoSystem() {
            return this.mojo.getRepoSystem();
        }

        @Override
        public MavenSession getMavenSession() {
            return this.mojo.getMavenSession();
        }

        @Override
        public MavenProject getMavenProject() {
            return this.mojo.getMavenProject();
        }

        @Override
        public File getGeneratedAvscTarget() {
            return this.mojo.getGeneratedAvscTarget();
        }

        @Override
        public File getTarget() {
            return this.mojo.getTarget();
        }

        @Override
        public Log getLog() {
            return this.mojo.getLog();
        }
    }
}

