/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp.validation.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.version.Version;
import org.spf4j.avro.schema.SchemaDiff;
import org.spf4j.avro.schema.Schemas;
import org.spf4j.io.compress.Compress;
import org.spf4j.maven.MavenRepositoryUtils;
import org.spf4j.maven.plugin.avro.avscp.ValidatorMojo;
import org.spf4j.maven.plugin.avro.avscp.validation.Validator;

public final class SchemaCompatibilityValidator
implements Validator<Void> {
    @Override
    public String getName() {
        return "compatibility";
    }

    @Override
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public Validator.Result validate(Void nv, ValidatorMojo mojo) throws IOException {
        String schemaArtifactExtension;
        List rangeVersions;
        String strNrDays;
        MavenProject mavenProject = mojo.getMavenProject();
        Map<String, String> validatorConfigs = mojo.getValidatorConfigs();
        Log log = mojo.getLog();
        String versionRange = validatorConfigs.get("versionRange");
        if (versionRange == null) {
            versionRange = "[," + mavenProject.getVersion() + ')';
        }
        int maxNrVersToCheck = 30;
        String strNrVer = validatorConfigs.get("maxNrOfVersionsToCheckForCompatibility");
        if (strNrVer != null) {
            maxNrVersToCheck = Integer.parseInt(strNrVer);
        }
        Instant instantToGoBack = (strNrDays = validatorConfigs.get("maxNrOfDaysBackCheckForCompatibility")) == null ? Instant.now().atOffset(ZoneOffset.UTC).minus(1L, ChronoUnit.YEARS).toInstant() : Instant.now().atOffset(ZoneOffset.UTC).minus(Integer.parseInt(strNrDays), ChronoUnit.DAYS).toInstant();
        String groupId = mavenProject.getGroupId();
        String artifactId = mavenProject.getArtifactId();
        List remoteProjectRepositories = mavenProject.getRemoteProjectRepositories();
        RepositorySystem repoSystem = mojo.getRepoSystem();
        RepositorySystemSession repositorySession = mojo.getMavenSession().getRepositorySession();
        try {
            rangeVersions = MavenRepositoryUtils.getVersions((String)groupId, (String)artifactId, (String)versionRange, (List)remoteProjectRepositories, (RepositorySystem)repoSystem, (RepositorySystemSession)repositorySession);
        }
        catch (VersionRangeResolutionException ex) {
            throw new RuntimeException("Invalid compatibiliy.versionRange = " + versionRange + " setting", ex);
        }
        rangeVersions = rangeVersions.stream().filter(v -> !v.toString().endsWith("SNAPSHOT")).collect(Collectors.toList());
        int tSize = rangeVersions.size();
        rangeVersions = rangeVersions.subList(Math.max(tSize - maxNrVersToCheck, 0), tSize);
        log.info((CharSequence)("Validating compatibility with previous versions " + rangeVersions + " newer than " + instantToGoBack));
        if (rangeVersions.isEmpty()) {
            return Validator.Result.valid();
        }
        String schemaArtifactClassifier = validatorConfigs.get("schemaArtifactClassifier");
        if (schemaArtifactClassifier != null && schemaArtifactClassifier.trim().isEmpty()) {
            schemaArtifactClassifier = null;
        }
        if ((schemaArtifactExtension = validatorConfigs.get("schemaArtifactExtension")) == null || schemaArtifactExtension.trim().isEmpty()) {
            schemaArtifactExtension = "jar";
        }
        ArrayList issues = new ArrayList(4);
        int size = rangeVersions.size();
        for (int i = size - 1; i >= 0; --i) {
            Version version = (Version)rangeVersions.get(i);
            this.validateCompatibility(groupId, artifactId, schemaArtifactClassifier, schemaArtifactExtension, version, remoteProjectRepositories, repoSystem, repositorySession, mojo, Boolean.parseBoolean(validatorConfigs.getOrDefault("deprecationRemoval", "true")), instantToGoBack, issues::add);
        }
        if (issues.isEmpty()) {
            return Validator.Result.valid();
        }
        return Validator.Result.failed("Schema compatibility issues:\n" + String.join((CharSequence)"\n", issues));
    }

    @SuppressFBWarnings(value={"PCAIL_POSSIBLE_CONSTANT_ALLOCATION_IN_LOOP"})
    public void validateCompatibility(String groupId, String artifactId, @Nullable String classifier, String extension, Version version, List<RemoteRepository> remoteProjectRepositories, RepositorySystem repoSystem, RepositorySystemSession repositorySession, ValidatorMojo mojo, boolean deprecationRemoval, Instant instantToGoBack, Consumer<String> issues) throws IOException {
        File prevSchemaArchive;
        Log log = mojo.getLog();
        log.info((CharSequence)("Validating compatibility with version: " + version + ", " + groupId + ':' + artifactId + ':' + classifier + ':' + extension));
        Path targetPath = mojo.getTarget().toPath();
        Path currSchemasPath = mojo.getGeneratedAvscTarget().toPath();
        try {
            prevSchemaArchive = MavenRepositoryUtils.resolveArtifact((String)groupId, (String)artifactId, (String)classifier, (String)extension, (String)version.toString(), remoteProjectRepositories, (RepositorySystem)repoSystem, (RepositorySystemSession)repositorySession);
        }
        catch (ArtifactResolutionException ex) {
            throw new RuntimeException("Cannot resolve previous version " + version, ex);
        }
        Path dest = targetPath.resolve("prevSchemas").resolve(version.toString());
        Files.createDirectories(dest, new FileAttribute[0]);
        log.debug((CharSequence)("Unzipping " + prevSchemaArchive + " to " + dest));
        List prevSchemas = Compress.unzip2((Path)prevSchemaArchive.toPath(), (Path)dest, p -> {
            Path fileName = p.getFileName();
            if (fileName == null) {
                return false;
            }
            String fname = fileName.toString();
            return fname.endsWith("avsc") || "codegen.properties".equals(fname) || "MANIFEST.MF".equals(fname);
        });
        Instant dependencyBuildTime = SchemaCompatibilityValidator.getDependencyBuildTime(dest, log);
        if (dependencyBuildTime == null) {
            log.info((CharSequence)("Package " + dest + " build time missing from manifest"));
        } else if (dependencyBuildTime.isBefore(instantToGoBack)) {
            return;
        }
        for (Path prevSchemaPath : prevSchemas) {
            Path fileName = prevSchemaPath.getFileName();
            if (fileName == null || !fileName.toString().endsWith("avsc")) continue;
            Path relPath = dest.relativize(prevSchemaPath);
            Path newSchemaPath = currSchemasPath.resolve(relPath);
            Schema previousSchema = new Schema.Parser().parse(prevSchemaPath.toFile());
            String previousSchemaName = previousSchema.getFullName();
            if (previousSchema.getProp("beta") != null) {
                log.debug((CharSequence)("Skipping beta schema " + previousSchemaName));
                continue;
            }
            log.debug((CharSequence)("Validating compatibility for " + previousSchemaName + " " + prevSchemaPath + " -> " + newSchemaPath));
            if (!Files.exists(newSchemaPath, new LinkOption[0])) {
                if (!deprecationRemoval || previousSchema.getProp("beta") != null || previousSchema.getProp("deprecated") != null) continue;
                issues.accept(previousSchemaName + " is being removed without being deprecated first");
                continue;
            }
            Schema newSchema = new Schema.Parser().parse(newSchemaPath.toFile());
            this.validateCompatiblityBetween2Schemas(newSchema, previousSchema, version, issues, log, deprecationRemoval);
        }
    }

    public void validateCompatiblityBetween2Schemas(Schema newSchema, Schema previousSchema, Version previousVersion, Consumer<String> issues, Log log, boolean deprecationRemoval) {
        if (newSchema.getProp("beta") != null) {
            log.debug((CharSequence)("Skipping beta schema " + newSchema.getFullName() + " compatibility validation"));
        } else {
            if (newSchema.getProp("noOldToNewCompatibility") == null) {
                SchemaCompatibility.SchemaPairCompatibility o2n = SchemaCompatibility.checkReaderWriterCompatibility((Schema)newSchema, (Schema)previousSchema);
                if (o2n.getType() == SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE) {
                    issues.accept(newSchema.getFullName() + " cannot convert from previous version " + previousVersion + ", incompatibilities: " + o2n.getResult().getIncompatibilities() + ",\n diff: \n" + SchemaCompatibilityValidator.diff(previousSchema, newSchema));
                }
            } else {
                log.debug((CharSequence)("Skipping  schema " + newSchema.getFullName() + " noOldToNewCompatibility validation"));
            }
            if (newSchema.getProp("noNewToOldCompatibility") == null) {
                SchemaCompatibility.SchemaPairCompatibility n2o = SchemaCompatibility.checkReaderWriterCompatibility((Schema)previousSchema, (Schema)newSchema);
                if (n2o.getType() == SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE) {
                    issues.accept(newSchema.getFullName() + " cannot convert current to previos version " + previousVersion + ", incompatibilities: " + n2o.getResult().getIncompatibilities() + ",\n diff: \n" + SchemaCompatibilityValidator.diff(previousSchema, newSchema));
                }
            } else {
                log.debug((CharSequence)("Skipping  schema " + newSchema.getFullName() + " noNewToOldCompatibility validation"));
            }
            if (deprecationRemoval) {
                Schemas.diff((Schema)previousSchema, (Schema)newSchema, diff -> {
                    Schema.Field leftField;
                    if (diff.getDiffType() == SchemaDiff.Type.FIELD_MISSING_RIGHT && (leftField = diff.getLeftField()).getProp("deprecated") == null) {
                        issues.accept(previousSchema.getFullName() + " at " + diff.getPath() + "field  " + leftField + " is being removed without being deprecated first");
                    }
                });
            }
        }
    }

    @Nullable
    private static Instant getDependencyBuildTime(Path location, Log log) throws IOException {
        block37: {
            Path codegenManifest;
            String buildTime;
            block36: {
                Path jarManifest = location.resolve("META-INF/MANIFEST.MF");
                if (Files.exists(jarManifest, new LinkOption[0])) {
                    Throwable throwable = null;
                    try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(jarManifest, new OpenOption[0]));){
                        Manifest manifest = new Manifest(bis);
                        Attributes mainAttributes = manifest.getMainAttributes();
                        buildTime = mainAttributes.getValue("Build-Time");
                        if (buildTime == null) break block36;
                        try {
                            Instant instant = Instant.parse(buildTime);
                            return instant;
                        }
                        catch (DateTimeParseException ex) {
                            try {
                                log.warn((CharSequence)("Cannot parse manifest build time " + buildTime), (Throwable)ex);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                throw throwable3;
                            }
                        }
                    }
                }
            }
            if (Files.exists(codegenManifest = location.resolve("codegen.properties"), new LinkOption[0])) {
                Throwable throwable = null;
                try (BufferedReader br = Files.newBufferedReader(codegenManifest, StandardCharsets.UTF_8);){
                    Properties props = new Properties();
                    props.load(br);
                    buildTime = props.getProperty("Build-Time");
                    if (buildTime == null) break block37;
                    try {
                        Instant ex = Instant.parse(buildTime);
                        return ex;
                    }
                    catch (DateTimeParseException ex) {
                        try {
                            log.warn((CharSequence)("Cannot parse manifest build time " + buildTime), (Throwable)ex);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throw throwable5;
                        }
                    }
                }
            }
        }
        return null;
    }

    static String diff(Schema schema1, Schema schema2) {
        String s1 = schema1.toString(true);
        String s2 = schema2.toString(true);
        DiffMatchPatch dmp = new DiffMatchPatch();
        LinkedList diffs = dmp.diffMain(s1, s2, false);
        dmp.diffCleanupSemantic(diffs);
        StringBuilder result = new StringBuilder();
        block5: for (DiffMatchPatch.Diff aDiff : diffs) {
            String text = aDiff.text;
            switch (aDiff.operation) {
                case INSERT: {
                    result.append("+<<<").append(text).append(">>>");
                    continue block5;
                }
                case DELETE: {
                    result.append("-<<<").append(text).append(">>>");
                    continue block5;
                }
                case EQUAL: {
                    result.append(text);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Not supported " + aDiff.operation);
        }
        return result.toString();
    }

    @Override
    public Class<Void> getValidationInput() {
        return Void.class;
    }
}

