/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp.validation.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.spf4j.avro.schema.SchemaVisitor;
import org.spf4j.avro.schema.SchemaVisitorAction;
import org.spf4j.avro.schema.Schemas;
import org.spf4j.base.CharSequences;
import org.spf4j.maven.plugin.avro.avscp.ValidatorMojo;
import org.spf4j.maven.plugin.avro.avscp.validation.Validator;
import org.spf4j.maven.plugin.avro.avscp.validation.Validators;

public final class SchemaDocValidator
implements Validator<Schema> {
    @Override
    public String getName() {
        return "docValidator";
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"AI_ANNOTATION_ISSUES_NEEDS_NULLABLE"})
    public Validator.Result validate(Schema schema, ValidatorMojo mojo) {
        return (Validator.Result)Schemas.visit((Schema)schema, (SchemaVisitor)new DocValidatorVisitor(schema));
    }

    @Nullable
    private static Schema.Type getCollectionType(Schema unionSchema) {
        for (Schema schema : unionSchema.getTypes()) {
            Schema.Type type = schema.getType();
            switch (type) {
                case ARRAY: 
                case MAP: 
                case STRING: {
                    return type;
                }
            }
        }
        return null;
    }

    @Override
    public Class<Schema> getValidationInput() {
        return Schema.class;
    }

    private static class DocValidatorVisitor
    implements SchemaVisitor<Validator.Result> {
        private final List<String> issues = new ArrayList<String>(4);
        private final Schema root;

        DocValidatorVisitor(Schema root) {
            this.root = root;
        }

        public SchemaVisitorAction visitTerminal(Schema schema) {
            switch (schema.getType()) {
                case ENUM: 
                case FIXED: {
                    String doc = schema.getDoc();
                    if (doc != null && !doc.trim().isEmpty()) break;
                    this.issues.add("Please document " + schema.getFullName());
                    break;
                }
            }
            return SchemaVisitorAction.CONTINUE;
        }

        public SchemaVisitorAction visitNonTerminal(Schema schema) {
            if (schema.getType() == Schema.Type.RECORD) {
                if (Validators.skipValidator(schema, "docValidator")) {
                    return SchemaVisitorAction.CONTINUE;
                }
                String doc = schema.getDoc();
                if (doc == null || doc.trim().isEmpty()) {
                    this.issues.add("Please document " + schema.getFullName());
                }
                for (Schema.Field field : schema.getFields()) {
                    Schema.Type collectionType;
                    doc = field.doc();
                    if (doc == null || doc.trim().isEmpty()) {
                        String errText = "Please document " + field.name() + '@' + schema.getFullName();
                        String source = schema.getProp("sourceIdl");
                        if (source != null) {
                            errText = errText + " from " + source;
                        }
                        this.issues.add(errText);
                        continue;
                    }
                    Schema fs = field.schema();
                    if (!Schemas.isNullableUnion((Schema)fs) || CharSequences.containsIgnoreCase((CharSequence)doc, (CharSequence)"null")) continue;
                    String issue = "please document the meaning of null for field " + field.name() + '@' + schema.getFullName();
                    String source = schema.getProp("sourceIdl");
                    if (source != null) {
                        issue = issue + " from " + source;
                    }
                    if ((collectionType = SchemaDocValidator.getCollectionType(fs)) != null) {
                        issue = issue + " and explain how its meaning is different from empty " + collectionType;
                    }
                    this.issues.add(issue);
                }
            }
            return SchemaVisitorAction.CONTINUE;
        }

        public SchemaVisitorAction afterVisitNonTerminal(Schema nonTerminal) {
            return SchemaVisitorAction.CONTINUE;
        }

        @Nonnull
        public Validator.Result get() {
            return this.issues.isEmpty() ? Validator.Result.valid() : Validator.Result.failed("Schema " + this.root.getFullName() + " doc issues:\n" + String.join((CharSequence)"\n", this.issues));
        }
    }
}

