/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.aspects;

import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.spf4j.annotations.Retry;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.failsafe.RetryPolicy;

@Aspect
public final class RetryAspect {
    private static final ConcurrentMap<String, RetryPolicy> POLICIES = new ConcurrentHashMap<String, RetryPolicy>();

    @Around(value="execution(@org.spf4j.annotations.Retry * *(..)) && @annotation(org.spf4j.annotations.Retry annot)", argNames="pjp,annot")
    @SuppressFBWarnings(value={"FII_USE_METHOD_REFERENCE"})
    public Object retriedMethod(ProceedingJoinPoint pjp, Retry annot) throws Throwable {
        try (ExecutionContext ctx = ExecutionContexts.start((String)pjp.toShortString(), (long)annot.timeout(), (TimeUnit)annot.units());){
            Callable<Object> c = () -> {
                try {
                    return pjp.proceed();
                }
                catch (Error | Exception e) {
                    throw e;
                }
                catch (Throwable ex) {
                    throw new UncheckedExecutionException(ex);
                }
            };
            String retryPolicyName = annot.retryPolicyName();
            if ("".equals(retryPolicyName)) {
                Object object = RetryPolicy.defaultPolicy().call(c, Exception.class, ctx.getDeadlineNanos());
                return object;
            }
            Object object = ((RetryPolicy)POLICIES.get(retryPolicyName)).call(c, Exception.class, ctx.getDeadlineNanos());
            return object;
        }
    }

    public static RetryPolicy registerRetryPolicy(String name, RetryPolicy policy) {
        return POLICIES.put(name, policy);
    }
}

