/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.aspects;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.spf4j.base.InstrumentationHelper;
import org.spf4j.perf.MeasurementRecorderSource;
import org.spf4j.perf.impl.RecorderFactory;

@Aspect
public final class AllocationMonitorAspect {
    private static final boolean RECORD_OBJECT_SIZE = Boolean.getBoolean("spf4j.perf.allocations.recordSize");
    private static final MeasurementRecorderSource RECORDER;
    public static final int SAMPLE_TIME_MILLIS;

    @AfterReturning(pointcut="call(*.new(..))", returning="obj", argNames="jp,obj")
    public void afterAllocation(JoinPoint jp, Object obj) {
        if (RECORD_OBJECT_SIZE) {
            RECORDER.getRecorder((Object)jp.getSourceLocation().getWithinType()).record(InstrumentationHelper.getObjectSize((Object)obj));
        } else {
            RECORDER.getRecorder((Object)jp.getSourceLocation().getWithinType()).record(1L);
        }
    }

    static {
        SAMPLE_TIME_MILLIS = Integer.getInteger("spf4j.perf.allocations.sampleTimeMillis", 300000);
        RECORDER = RECORD_OBJECT_SIZE ? RecorderFactory.createScalableCountingRecorderSource((Object)"allocations.all", (String)"bytes", (int)SAMPLE_TIME_MILLIS) : RecorderFactory.createScalableCountingRecorderSource((Object)"allocations.all", (String)"instances", (int)SAMPLE_TIME_MILLIS);
    }
}

