/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.zfork;

import com.fasterxml.jackson.core.JsonParser;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import org.apache.avro.AvroNamesRefResolver;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ExtendedJsonDecoder;
import org.apache.avro.io.ExtendedJsonEncoder;
import org.spf4j.avro.Adapter;
import org.spf4j.avro.SchemaResolver;
import org.spf4j.avro.Yaml;

public final class ZForkAvroAdapter
implements Adapter {
    public Encoder getJsonEncoder(Schema writerSchema, OutputStream os) throws IOException {
        return new ExtendedJsonEncoder(writerSchema, os);
    }

    public Encoder getJsonEncoder(Schema writerSchema, Appendable os) throws IOException {
        return new ExtendedJsonEncoder(writerSchema, Schema.FACTORY.createGenerator(CharStreams.asWriter((Appendable)os)));
    }

    public Schema.Field createField(String name, Schema schema, String doc, Object defaultVal, boolean validateDefault, boolean validateName, Schema.Field.Order order) {
        return new Schema.Field(name, schema, doc, defaultVal, validateDefault, validateName, order);
    }

    public Schema createRecordSchema(String name, String doc, String namespace, boolean isError, List<Schema.Field> fields, boolean validateName) {
        return Schema.createRecord((String)name, (String)doc, (String)namespace, (boolean)isError, fields, (boolean)validateName);
    }

    public Schema createRecordSchema(String name, String doc, String namespace, boolean isError, boolean validateName) {
        return Schema.createRecord((String)name, (String)doc, (String)namespace, (boolean)isError, (boolean)validateName);
    }

    public Decoder getJsonDecoder(Schema writerSchema, InputStream is) throws IOException {
        return new ExtendedJsonDecoder(writerSchema, is, true);
    }

    public Schema parseSchema(Reader reader, boolean allowUndefinedLogicalTypes, SchemaResolver resolver) throws IOException {
        return new Schema.Parser((Schema.Names)new AvroNamesRefResolver((org.apache.avro.SchemaResolver)new SchemaResolverAdapter(resolver))).setValidate(true).parse(Schema.FACTORY.createParser(reader), allowUndefinedLogicalTypes);
    }

    public Schema parseSchema(Reader reader) throws IOException {
        return new Schema.Parser().parse(Schema.FACTORY.createParser(reader), true);
    }

    public Decoder getJsonDecoder(Schema writerSchema, Reader reader) throws IOException {
        return new ExtendedJsonDecoder(writerSchema, Schema.FACTORY.createParser(reader), true);
    }

    public Decoder getYamlDecoder(Schema writerSchema, Reader reader) throws IOException {
        return new ExtendedJsonDecoder(writerSchema, Yaml.newParser((Reader)reader), true);
    }

    public Decoder getJsonDecoder(Schema writerSchema, JsonParser parser) throws IOException {
        return new ExtendedJsonDecoder(writerSchema, parser, true);
    }

    public boolean isCompatible() {
        try {
            Schema.Field.class.getConstructor(String.class, Schema.class, String.class, Object.class, Boolean.TYPE, Boolean.TYPE, Schema.Field.Order.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            return false;
        }
    }

    private static class SchemaResolverAdapter
    implements org.apache.avro.SchemaResolver {
        private final SchemaResolver resolver;

        SchemaResolverAdapter(SchemaResolver resolver) {
            this.resolver = resolver;
        }

        public Schema resolveSchema(String id) {
            return this.resolver.resolveSchema(id);
        }

        public String getId(Schema schema) {
            return this.resolver.getId(schema);
        }
    }
}

