/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.spf4j.avro.Adapter;

public final class AvroCompatUtils {
    private static final Adapter ADAPTER;

    private AvroCompatUtils() {
    }

    public static Schema.Field createField(String name, Schema schema, String doc, Object defaultVal, boolean validateDefault, boolean validateName, Schema.Field.Order order) {
        return ADAPTER.createField(name, schema, doc, defaultVal, validateDefault, validateName, order);
    }

    public static Schema createRecordSchema(String name, String doc, String namespace, boolean isError, List<Schema.Field> fields, boolean validateName) {
        return ADAPTER.createRecordSchema(name, doc, namespace, isError, fields, validateName);
    }

    public static Schema createRecordSchema(String name, String doc, String namespace, boolean isError, boolean validateName) {
        return ADAPTER.createRecordSchema(name, doc, namespace, isError, validateName);
    }

    public static Encoder getJsonEncoder(Schema writerSchema, OutputStream os) throws IOException {
        return ADAPTER.getJsonEncoder(writerSchema, os);
    }

    public static Encoder getJsonEncoder(Schema writerSchema, Appendable os) throws IOException {
        return ADAPTER.getJsonEncoder(writerSchema, os);
    }

    public static Decoder getJsonDecoder(Schema writerSchema, InputStream is) throws IOException {
        return ADAPTER.getJsonDecoder(writerSchema, is);
    }

    public static Adapter getAdapter() {
        return ADAPTER;
    }

    static {
        Adapter theOne = null;
        for (Adapter adapter : ServiceLoader.load(Adapter.class)) {
            if (!adapter.isCompatible()) continue;
            if (theOne == null) {
                theOne = adapter;
                continue;
            }
            throw new ExceptionInInitializerError("Multiple avro implementation adapters found: " + theOne + ", " + adapter);
        }
        if (theOne == null) {
            throw new ExceptionInInitializerError("No avro implementation adapter found");
        }
        ADAPTER = theOne;
    }
}

