/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;

public interface SchemaResolver {
    public static final SchemaResolver NONE = new SchemaResolver(){

        @Override
        public boolean customWrite(Schema schema, JsonGenerator gen) {
            return false;
        }

        @Override
        public Schema customRead(Function<String, JsonNode> object) {
            return null;
        }

        @Override
        public Schema resolveSchema(String id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId(Schema schema) {
            return null;
        }
    };

    default public boolean customWrite(Schema schema, JsonGenerator gen) throws IOException {
        String ref = this.getId(schema);
        if (ref != null) {
            gen.writeStartObject();
            gen.writeFieldName(this.getJsonAttrName());
            gen.writeString(ref);
            gen.writeEndObject();
            return true;
        }
        return false;
    }

    @Nullable
    default public Schema customRead(Function<String, JsonNode> object) {
        JsonNode refVal = object.apply(this.getJsonAttrName());
        if (refVal != null) {
            return this.resolveSchema(refVal.asText());
        }
        return null;
    }

    default public String getJsonAttrName() {
        return "$ref";
    }

    @Nonnull
    public Schema resolveSchema(String var1);

    @Nullable
    public String getId(Schema var1);
}

